/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.java.platform.JavaPlatformFactory;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ConfigurationImpl
implements ProjectConfiguration {
    private final File location;
    private final boolean missing;
    private static final Map<FileObject, ProviderImpl> jdkRoot2ConfigurationProvider = new HashMap<FileObject, ProviderImpl>();

    public ConfigurationImpl(File location, boolean missing) {
        this.location = location;
        this.missing = missing;
    }

    public String getDisplayName() {
        return (this.missing ? "<html><font color='#FF0000'>" : "") + this.location.getName();
    }

    public File getLocation() {
        return this.location;
    }

    public static ProviderImpl getProvider(FileObject jdkRoot) {
        ProviderImpl provider = jdkRoot2ConfigurationProvider.get(jdkRoot);
        if (provider == null) {
            provider = new ProviderImpl(jdkRoot, null);
            jdkRoot2ConfigurationProvider.put(jdkRoot, provider);
        }
        return provider;
    }

    public static final class ProviderImpl
    implements ProjectConfigurationProvider<ConfigurationImpl>,
    FileChangeListener {
        private static final RequestProcessor WORKER = new RequestProcessor(ProviderImpl.class.getName(), 1, false, false);
        private final FileObject jdkRoot;
        private final File buildDir;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final Set<File> buildDirsWithListeners = new HashSet<File>();
        private List<ConfigurationImpl> configurations = Collections.emptyList();
        private ConfigurationImpl active;
        private static final String PROP_ACTIVE_CONFIGURATION = "activeConfiguration";

        public ProviderImpl(FileObject jdkRoot, File buildDir) {
            this.jdkRoot = jdkRoot;
            this.buildDir = new File(FileUtil.toFile((FileObject)jdkRoot), "build");
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    FileUtil.addFileChangeListener((FileChangeListener)this, (File)buildDir);
                    this.updateConfigurations();
                }
            });
        }

        private synchronized void updateConfigurations() {
            File dirToSelect;
            File[] dirs = this.buildDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            HashMap<File, ConfigurationImpl> configurations2Remove = new HashMap<File, ConfigurationImpl>();
            for (ConfigurationImpl c : this.configurations) {
                configurations2Remove.put(c.getLocation(), c);
            }
            if (this.active != null) {
                dirToSelect = this.active.getLocation();
            } else {
                Preferences prefs = this.prefs();
                String activeConfig = prefs != null ? prefs.get(PROP_ACTIVE_CONFIGURATION, null) : null;
                dirToSelect = activeConfig != null ? new File(activeConfig) : null;
            }
            HashSet<File> missingBuildDirs = new HashSet<File>(this.buildDirsWithListeners);
            ArrayList<ConfigurationImpl> newConfigurations = new ArrayList<ConfigurationImpl>();
            ConfigurationImpl newActive = null;
            if (dirs != null) {
                for (File dir : dirs) {
                    if (!missingBuildDirs.remove(dir)) {
                        FileUtil.addFileChangeListener((FileChangeListener)this, (File)dir);
                        this.buildDirsWithListeners.add(dir);
                    }
                    if (!new File(dir, "Makefile").canRead()) continue;
                    ConfigurationImpl current = (ConfigurationImpl)configurations2Remove.remove(dir);
                    if (current != null) {
                        newConfigurations.add(current);
                    } else {
                        current = new ConfigurationImpl(dir, false);
                        newConfigurations.add(current);
                    }
                    if (!dir.equals(dirToSelect) && (dirToSelect != null || newActive != null)) continue;
                    newActive = current;
                }
            }
            for (File removedDir : missingBuildDirs) {
                FileUtil.removeFileChangeListener((FileChangeListener)this, (File)removedDir);
                this.buildDirsWithListeners.remove(removedDir);
            }
            if (newActive == null && dirToSelect != null) {
                newActive = new ConfigurationImpl(dirToSelect, true);
                newConfigurations.add(0, newActive);
            }
            Collections.sort(newConfigurations, new Comparator<ConfigurationImpl>(){

                @Override
                public int compare(ConfigurationImpl o1, ConfigurationImpl o2) {
                    return o1.getLocation().getName().compareTo(o2.getLocation().getName());
                }
            });
            this.configurations = newConfigurations;
            this.pcs.firePropertyChange("configurations", null, null);
            if (this.active != newActive) {
                this.setActiveConfiguration(newActive);
            }
        }

        public synchronized Collection<ConfigurationImpl> getConfigurations() {
            return this.configurations;
        }

        public synchronized ConfigurationImpl getActiveConfiguration() {
            return this.active;
        }

        public synchronized void setActiveConfiguration(ConfigurationImpl configuration) {
            this.active = configuration;
            try {
                this.jdkRoot.setAttribute("nb-jdk-project-build", (Object)configuration.location);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.pcs.firePropertyChange(PROP_ACTIVE_CONFIGURATION, null, this.active);
            Preferences prefs = this.prefs();
            if (prefs != null) {
                prefs.put(PROP_ACTIVE_CONFIGURATION, configuration.getLocation().getAbsolutePath());
            }
            WORKER.post(() -> this.checkAndRegisterPlatform());
        }

        private Preferences prefs() {
            Project javaBaseProject;
            FileObject javaBase = this.jdkRoot.getFileObject("jdk/src/java.base");
            if (javaBase == null) {
                javaBase = this.jdkRoot.getFileObject("jdk");
            }
            Project project = javaBaseProject = javaBase != null ? FileOwnerQuery.getOwner((FileObject)javaBase) : null;
            if (javaBaseProject != null) {
                return ProjectUtils.getPreferences((Project)javaBaseProject, ConfigurationImpl.class, (boolean)false);
            }
            return null;
        }

        private void checkAndRegisterPlatform() {
            if (this.active.missing) {
                return;
            }
            String name = this.jdkRoot.getNameExt() + " - " + this.active.getDisplayName();
            FileObject target = FileUtil.toFileObject((File)new File(this.active.getLocation(), "jdk"));
            if (target == null || target.getFileObject("bin/java") == null) {
                return;
            }
            for (JavaPlatform platform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                if (platform.getInstallFolders().stream().anyMatch(folder -> folder.equals(target))) {
                    return;
                }
                if (!name.equals(platform.getDisplayName())) continue;
                return;
            }
            for (JavaPlatformFactory.Provider provider : Lookup.getDefault().lookupAll(JavaPlatformFactory.Provider.class)) {
                JavaPlatformFactory factory = provider.forType("j2se");
                if (factory == null) continue;
                try {
                    factory.create(target, name, true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public boolean hasCustomizer() {
            return false;
        }

        public void customize() {
        }

        public boolean configurationsAffectAction(String command) {
            return false;
        }

        public void addPropertyChangeListener(PropertyChangeListener lst) {
            this.pcs.addPropertyChangeListener(lst);
        }

        public void removePropertyChangeListener(PropertyChangeListener lst) {
            this.pcs.removePropertyChangeListener(lst);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.updateConfigurations();
        }

        public void fileDataCreated(FileEvent fe) {
            this.updateConfigurations();
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            this.updateConfigurations();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.updateConfigurations();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

