/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.mx.project;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.modules.java.mx.project.SuiteProject;
import org.netbeans.modules.java.mx.project.SuiteSources;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.queries.AnnotationProcessingQueryImplementation;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;

final class SuiteClassPathProvider
extends ProjectOpenedHook
implements ClassPathProvider,
AnnotationProcessingQueryImplementation {
    private final SuiteProject project;
    private final ClassPath bootCP;

    public SuiteClassPathProvider(SuiteProject project) {
        this.project = project;
        List entries = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries().entries();
        ArrayList<URL> roots = new ArrayList<URL>();
        for (ClassPath.Entry entry : entries) {
            URL root = entry.getURL();
            if (root.getPath().contains("/graal-sdk.jar") || root.getPath().contains("/graaljs-scriptengine.jar") || root.getPath().contains("/graal-sdk.src.zip")) continue;
            roots.add(entry.getURL());
        }
        this.bootCP = ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[0]));
    }

    public ClassPath findClassPath(FileObject file, String type) {
        SuiteSources.Group g = this.project.getSources().findGroup(file);
        if (g == null) {
            return null;
        }
        if ("classpath/boot".equals(type)) {
            return this.bootCP;
        }
        if ("classpath/compile".equals(type)) {
            return g.getCP();
        }
        if ("classpath/source".equals(type)) {
            return g.getSourceCP();
        }
        if ("classpath/processor".equals(type)) {
            return g.getProcessorCP();
        }
        return null;
    }

    public void projectOpened() {
        GlobalPathRegistry.getDefault().register("classpath/boot", new ClassPath[]{this.bootCP});
        for (SuiteSources.Group s : this.project.getSources().groups()) {
            GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{s.getSourceCP()});
            GlobalPathRegistry.getDefault().register("classpath/compile", new ClassPath[]{s.getCP()});
        }
    }

    public void projectClosed() {
        GlobalPathRegistry.getDefault().unregister("classpath/boot", new ClassPath[]{this.bootCP});
        for (SuiteSources.Group s : this.project.getSources().groups()) {
            GlobalPathRegistry.getDefault().unregister("classpath/source", new ClassPath[]{s.getSourceCP()});
            GlobalPathRegistry.getDefault().unregister("classpath/compile", new ClassPath[]{s.getCP()});
        }
    }

    public AnnotationProcessingQuery.Result getAnnotationProcessingOptions(FileObject file) {
        SuiteSources.Group g = this.project.getSources().findGroup(file);
        return g;
    }
}

