/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.platform;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatformProvider;
import org.openide.util.Parameters;

public final class ConnectionMethod {
    private static final Logger LOG = Logger.getLogger(ConnectionMethod.class.getName());
    private static final String PLAT_PROP_HOST = "platform.host";
    private static final String PLAT_PROP_PORT = "platform.port";
    private final String host;
    private final int port;
    private final Authentification auth;

    private ConnectionMethod(@NonNull String host, int port, Authentification auth) {
        Parameters.notNull((CharSequence)"host", (Object)host);
        Parameters.notNull((CharSequence)"auth", (Object)auth);
        this.host = host;
        this.port = port;
        this.auth = auth;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @NonNull
    public Authentification getAuthentification() {
        return this.auth;
    }

    void store(@NonNull Map<String, String> props) {
        props.put(PLAT_PROP_HOST, this.getHost());
        props.put(PLAT_PROP_PORT, Integer.toString(this.getPort()));
        this.auth.store(props);
    }

    @NonNull
    Collection<String> getGlobalPropertyNames() {
        HashSet<String> result = new HashSet<String>();
        result.add(PLAT_PROP_HOST);
        result.add(PLAT_PROP_PORT);
        result.addAll(this.auth.getGlobalPropertyNames());
        return Collections.unmodifiableSet(result);
    }

    @NonNull
    public static ConnectionMethod sshPassword(@NonNull String host, @NonNull int port, @NonNull String username, @NonNull String password) {
        return new ConnectionMethod(host, port, new Authentification.Password(username, password));
    }

    @NonNull
    public static ConnectionMethod sshKey(@NonNull String host, @NonNull int port, @NonNull String username, @NonNull File keyFile, @NonNull String passphrase) {
        return new ConnectionMethod(host, port, new Authentification.Key(username, keyFile, passphrase));
    }

    @NonNull
    public static ConnectionMethod load(@NonNull Map<String, String> props) {
        String host = props.get(PLAT_PROP_HOST);
        if (host == null) {
            throw new IllegalStateException("No platform host");
        }
        String _port = props.get(PLAT_PROP_PORT);
        if (_port == null) {
            throw new IllegalStateException("No platfrom port");
        }
        try {
            int port = Integer.parseInt(_port);
            return new ConnectionMethod(host, port, Authentification.load(props));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException("Invalid platfrom port: " + _port);
        }
    }

    public static abstract class Authentification {
        private static final String PLAT_PROP_AUTH_KIND = "platform.auth.kind";
        private static final String PLAT_PROP_AUTH_USER = "platform.auth.username";
        private final Kind kind;
        private final String userName;

        private Authentification(@NonNull Kind kind, @NonNull String userName) {
            Parameters.notNull((CharSequence)"kind", (Object)((Object)kind));
            Parameters.notNull((CharSequence)"userName", (Object)userName);
            this.kind = kind;
            this.userName = userName;
        }

        @NonNull
        public Kind getKind() {
            return this.kind;
        }

        @NonNull
        public String getUserName() {
            return this.userName;
        }

        void store(@NonNull Map<String, String> props) {
            props.put(PLAT_PROP_AUTH_KIND, this.getKind().toString());
            props.put(PLAT_PROP_AUTH_USER, this.getUserName());
        }

        @NonNull
        Collection<String> getGlobalPropertyNames() {
            HashSet<String> result = new HashSet<String>();
            result.add(PLAT_PROP_AUTH_KIND);
            result.add(PLAT_PROP_AUTH_USER);
            return Collections.unmodifiableSet(result);
        }

        @NonNull
        static Authentification load(@NonNull Map<String, String> props) {
            String _kind = props.get(PLAT_PROP_AUTH_KIND);
            if (_kind == null) {
                throw new IllegalStateException("No authentification kind");
            }
            Kind kind = Kind.valueOf(_kind);
            return kind.create(props);
        }

        static void clear(@NonNull String antPlatformName) {
            Password.clear(antPlatformName);
            Key.clear(antPlatformName);
        }

        public static enum Kind {
            PASSWORD{

                @Override
                @NonNull
                Authentification create(@NonNull Map<String, String> props) {
                    String passwdStr;
                    String user = props.get(Authentification.PLAT_PROP_AUTH_USER);
                    if (user == null) {
                        throw new IllegalStateException("No user");
                    }
                    char[] passwd = Keyring.read((String)RemotePlatformProvider.createPropertyName(props.get("platform.ant.name"), "platform.auth.passwd"));
                    if (passwd == null) {
                        LOG.log(Level.WARNING, "No password for: {0} for platform: {1}", new Object[]{user, props.get("platform.ant.name")});
                        passwdStr = "";
                    } else {
                        passwdStr = String.valueOf(passwd);
                    }
                    return new Password(user, passwdStr);
                }
            }
            ,
            KEY{

                @Override
                @NonNull
                Authentification create(@NonNull Map<String, String> props) {
                    String passPhraseStr;
                    String user = props.get(Authentification.PLAT_PROP_AUTH_USER);
                    if (user == null) {
                        throw new IllegalStateException("No user");
                    }
                    String keyStore = props.get("platform.auth.keystore");
                    if (keyStore == null) {
                        throw new IllegalStateException("No key store");
                    }
                    char[] passPhrase = Keyring.read((String)RemotePlatformProvider.createPropertyName(props.get("platform.ant.name"), "platform.auth.passphrase"));
                    if (passPhrase == null) {
                        LOG.log(Level.WARNING, "No passprase for: {0} for platform: {1}", new Object[]{user, props.get("platform.ant.name")});
                        passPhraseStr = "";
                    } else {
                        passPhraseStr = String.valueOf(passPhrase);
                    }
                    return new Key(user, new File(keyStore), passPhraseStr);
                }
            };


            @NonNull
            abstract Authentification create(@NonNull Map<String, String> var1);
        }

        public static final class Password
        extends Authentification {
            private static final String PLAT_PROP_AUTH_PASSWD = "platform.auth.passwd";
            private final String password;

            private Password(@NonNull String userName, @NonNull String password) {
                super(Kind.PASSWORD, userName);
                Parameters.notNull((CharSequence)"password", (Object)password);
                this.password = password;
            }

            @NonNull
            public String getPassword() {
                return this.password;
            }

            @Override
            @NonNull
            void store(@NonNull Map<String, String> props) {
                super.store(props);
                Keyring.save((String)RemotePlatformProvider.createPropertyName(props.get("platform.ant.name"), PLAT_PROP_AUTH_PASSWD), (char[])this.getPassword().toCharArray(), null);
            }

            static void clear(@NonNull String antPlatformName) {
                Keyring.delete((String)RemotePlatformProvider.createPropertyName(antPlatformName, PLAT_PROP_AUTH_PASSWD));
            }
        }

        public static final class Key
        extends Authentification {
            private static final String PLAT_PROP_AUTH_KEYSTORE = "platform.auth.keystore";
            private static final String PLAT_PROP_AUTH_PASSPHRASE = "platform.auth.passphrase";
            private final File keyStore;
            private final String passPhrase;

            private Key(@NonNull String userName, @NonNull File keyStore, @NonNull String passPhrase) {
                super(Kind.KEY, userName);
                Parameters.notNull((CharSequence)"keyStore", (Object)keyStore);
                Parameters.notNull((CharSequence)"passphrase", (Object)passPhrase);
                this.keyStore = keyStore;
                this.passPhrase = passPhrase;
            }

            @NonNull
            public File getKeyStore() {
                return this.keyStore;
            }

            @NonNull
            public String getPassPhrase() {
                return this.passPhrase;
            }

            @Override
            void store(@NonNull Map<String, String> props) {
                super.store(props);
                props.put(PLAT_PROP_AUTH_KEYSTORE, this.getKeyStore().getAbsolutePath());
                Keyring.save((String)RemotePlatformProvider.createPropertyName(props.get("platform.ant.name"), PLAT_PROP_AUTH_PASSPHRASE), (char[])this.getPassPhrase().toCharArray(), null);
            }

            static void clear(@NonNull String antPlatformName) {
                Keyring.delete((String)RemotePlatformProvider.createPropertyName(antPlatformName, PLAT_PROP_AUTH_PASSPHRASE));
            }

            @Override
            @NonNull
            Collection<String> getGlobalPropertyNames() {
                HashSet<String> result = new HashSet<String>();
                result.addAll(super.getGlobalPropertyNames());
                result.add(PLAT_PROP_AUTH_KEYSTORE);
                return Collections.unmodifiableSet(result);
            }
        }
    }
}

