/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.BadLocationException;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.editor.GuardedException;
import org.netbeans.modules.java.editor.codegen.ImplementOverrideMethodGenerator;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.errors.CreateFixBase;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.friendapi.OverrideErrorMessage;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ImplementAllAbstractMethods
implements ErrorRule<Object>,
OverrideErrorMessage<Object> {
    private static final String PREMATURE_EOF_CODE = "compiler.err.premature.eof";
    private static final String RECORD = "RECORD";

    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.abstract.cant.be.instantiated", "compiler.err.does.not.override.abstract", "compiler.err.abstract.cant.be.instantiated", "compiler.err.enum.constant.does.not.override.abstract"));
    }

    private static TypeElement findTypeElement(CompilationInfo info, TreePath path) {
        Element e = info.getTrees().getElement(path);
        if (e == null) {
            return null;
        }
        if (e.getKind().isClass() || e.getKind().isInterface()) {
            return (TypeElement)e;
        }
        TypeMirror tm = info.getTrees().getTypeMirror(path);
        if ((tm == null || tm.getKind() != TypeKind.DECLARED) && path.getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
            tm = info.getTrees().getTypeMirror(new TreePath(path, ((NewClassTree)path.getLeaf()).getIdentifier()));
        }
        if (tm != null && tm.getKind() == TypeKind.DECLARED) {
            return (TypeElement)((DeclaredType)tm).asElement();
        }
        return null;
    }

    @Override
    public String createMessage(CompilationInfo info, Diagnostic diag, int offset, TreePath treePath, ErrorRule.Data<Object> data) {
        TreePath path = ImplementAllAbstractMethods.deepTreePath(info, offset);
        TypeElement e = ImplementAllAbstractMethods.findTypeElement(info, path);
        if (e == null) {
            return null;
        }
        HashMap<Tree, Boolean> d = (HashMap<Tree, Boolean>)data.getData();
        if (d == null) {
            d = new HashMap<Tree, Boolean>();
            data.setData(d);
        }
        List lee = info.getElementUtilities().findUnimplementedMethods(e, true);
        Scope s = info.getTrees().getScope(path);
        boolean hasDefault = false;
        for (ExecutableElement ee : lee) {
            if (!info.getTrees().isAccessible(s, ee, (DeclaredType)e.asType())) {
                d.put(path.getLeaf(), true);
                return Bundle.ERR_CannotOverrideAbstractMethods();
            }
            if (!ee.getModifiers().contains((Object)Modifier.DEFAULT)) continue;
            hasDefault = true;
        }
        if (hasDefault) {
            d.put(path.getLeaf(), Boolean.FALSE);
        }
        return null;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Object> data) {
        ArrayList<Fix> fixes;
        TypeElement tel;
        boolean containsDefaultMethod;
        Element e;
        TreePath path;
        block14: {
            path = ImplementAllAbstractMethods.deepTreePath(info, offset);
            if (path == null) {
                return null;
            }
            Map holder = data == null ? null : (Map)data.getData();
            Object saved = null;
            if (holder != null) {
                saved = holder.get(path.getLeaf());
            }
            if (Boolean.TRUE == saved) {
                return null;
            }
            e = info.getTrees().getElement(path);
            final Tree leaf = path.getLeaf();
            boolean isUsableElement = e != null && (e.getKind().isClass() || e.getKind().isInterface());
            containsDefaultMethod = saved == Boolean.FALSE;
            boolean completingAnonymous = e != null && e.getKind() == ElementKind.CONSTRUCTOR && leaf.getKind() == Tree.Kind.NEW_CLASS;
            tel = ImplementAllAbstractMethods.findTypeElement(info, path);
            if (!Utilities.isValidElement(tel)) {
                return null;
            }
            fixes = new ArrayList<Fix>();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)leaf.getKind()) || leaf.getKind().toString().equals(RECORD)) {
                CompilationUnitTree cut = info.getCompilationUnit();
                long start = info.getTrees().getSourcePositions().getStartPosition(cut, leaf);
                long end = info.getTrees().getSourcePositions().getEndPosition(cut, leaf);
                for (Diagnostic d : info.getDiagnostics()) {
                    long position = d.getPosition();
                    if (!d.getCode().equals(PREMATURE_EOF_CODE) || position <= start || position >= end) continue;
                    return null;
                }
            }
            if (completingAnonymous) {
                final boolean[] parentError = new boolean[]{false};
                new ErrorAwareTreePathScanner(){

                    public Object visitNewClass(NewClassTree nct, Object o) {
                        if (leaf == nct) {
                            parentError[0] = this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.ERRONEOUS;
                        }
                        return super.visitNewClass(nct, o);
                    }
                }.scan(path.getParentPath(), null);
                if (parentError[0]) {
                    return null;
                }
                fixes.add(new ImplementAbstractMethodsFix(info, path, tel, containsDefaultMethod));
            }
            boolean someAbstract = false;
            if (isUsableElement) {
                for (ExecutableElement ee : ElementFilter.methodsIn(e.getEnclosedElements())) {
                    if (!ee.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                    if (e.getKind() == ElementKind.ENUM) {
                        fixes.add(new ImplementOnEnumValues2(info, tel, containsDefaultMethod));
                        break block14;
                    }
                    if (!e.getKind().isClass()) continue;
                    someAbstract = true;
                    break;
                }
                if (!someAbstract) {
                    fixes.add(new ImplementAbstractMethodsFix(info, path, tel, containsDefaultMethod));
                }
                if (e.getKind() == ElementKind.CLASS && e.getSimpleName() != null && !e.getSimpleName().contentEquals("")) {
                    fixes.add(new MakeAbstractFix(info, path, e.getSimpleName().toString()).toEditorFix());
                }
            }
        }
        if (e != null && e.getKind() == ElementKind.ENUM_CONSTANT) {
            fixes.add(new ImplementAbstractMethodsFix(info, path, tel, containsDefaultMethod));
        }
        return fixes;
    }

    public void cancel() {
    }

    public String getId() {
        return ImplementAllAbstractMethods.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"LBL_Impl_Abstract_Methods");
    }

    public String getDescription() {
        return NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"DSC_Impl_Abstract_Methods");
    }

    private static TreePath deepTreePath(CompilationInfo info, int offset) {
        TreePath basic = info.getTreeUtilities().pathFor(offset);
        TreePath plusOne = info.getTreeUtilities().pathFor(offset + 1);
        TreePath parent = plusOne.getParentPath();
        if (parent == null) {
            return basic;
        }
        if (plusOne.getLeaf().getKind() == Tree.Kind.NEW_CLASS && parent.getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT && (parent = parent.getParentPath()) == null) {
            return basic;
        }
        if (parent.getLeaf() == basic.getLeaf()) {
            return plusOne;
        }
        return basic;
    }

    private static boolean generateClassBody2(WorkingCopy copy, TreePath p) throws Exception {
        int insertOffset = (int)copy.getTrees().getSourcePositions().getEndPosition(copy.getCompilationUnit(), p.getLeaf());
        if (insertOffset == -1) {
            return false;
        }
        try {
            copy.getDocument().insertString(insertOffset, " {}", null);
        }
        catch (GuardedException ex) {
            String message = NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"ERR_CannotApplyGuarded");
            StatusDisplayer.getDefault().setStatusText(message);
            return true;
        }
        catch (IOException | BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return true;
        }
        return false;
    }

    public static Map<? extends ExecutableElement, ? extends ExecutableElement> generateAllAbstractMethodImplementations(WorkingCopy wc, TreePath path, List<ElementHandle<? extends Element>> toImplementHandles) {
        ArrayList<ExecutableElement> toImplement;
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()) || path.getLeaf().getKind().toString().equals(RECORD));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te == null) {
            return null;
        }
        ClassTree clazz = (ClassTree)path.getLeaf();
        GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
        ElementUtilities elemUtils = wc.getElementUtilities();
        if (toImplementHandles != null) {
            ArrayList<ExecutableElement> els = new ArrayList<ExecutableElement>();
            for (ElementHandle<? extends Element> h : toImplementHandles) {
                Element e = h.resolve((CompilationInfo)wc);
                if (e.getKind() != ElementKind.METHOD) continue;
                els.add((ExecutableElement)e);
            }
            toImplement = els;
        } else {
            toImplement = elemUtils.findUnimplementedMethods(te);
        }
        Map<? extends ExecutableElement, ? extends ExecutableElement> ret = Utilities.findConflictingMethods((CompilationInfo)wc, te, (Iterable<? extends ExecutableElement>)toImplement);
        if (ret.size() < toImplement.size()) {
            toImplement.removeAll(ret.keySet());
            List res = gu.createAbstractMethodImplementations(te, toImplement);
            clazz = gu.insertClassMembers(clazz, (Iterable)res);
            wc.rewrite(path.getLeaf(), (Tree)clazz);
        }
        if (ret.isEmpty()) {
            return ret;
        }
        String msg = ret.size() == 1 ? NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"WARN_FoundConflictingMethods1", (Object)ret.keySet().iterator().next().getSimpleName()) : NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"WARN_FoundConflictingMethodsMany", (Object)ret.keySet().size());
        StatusDisplayer.getDefault().setStatusText(msg, 700);
        return ret;
    }

    static interface DebugFix {
        public String toDebugString();
    }

    private static class ImplementAbstractMethodsFix
    extends ImplementFixBase {
        public ImplementAbstractMethodsFix(CompilationInfo info, TreePath path, TypeElement clazz, boolean prompt) {
            super(info, path, clazz, prompt);
        }

        public String getText() {
            return NbBundle.getMessage(ImplementAbstractMethodsFix.class, (String)"LBL_FIX_Impl_Abstract_Methods");
        }

        @Override
        public ModificationResult getModificationResult() throws IOException {
            return this.source.runModificationTask(parameter -> {
                Element e;
                this.copy = parameter;
                parameter.toPhase(JavaSource.Phase.RESOLVED);
                TreePath tp = this.handle.resolve((CompilationInfo)parameter);
                if (tp != null && (e = parameter.getTrees().getElement(tp)) != null) {
                    Element el;
                    NewClassTree nct;
                    VariableTree var;
                    if ((e.getKind().isClass() || e.getKind().isInterface()) && this.implementType.equals((Object)ElementHandle.create((Element)e))) {
                        this.generateImplementation(e, tp);
                    }
                    if (e.getKind() == ElementKind.ENUM_CONSTANT && (var = (VariableTree)tp.getLeaf()).getInitializer() != null && var.getInitializer().getKind() == Tree.Kind.NEW_CLASS && (nct = (NewClassTree)var.getInitializer()).getClassBody() != null && (el = this.implementType.resolve((CompilationInfo)parameter)) != null) {
                        this.generateImplementation(el, tp);
                    }
                }
            });
        }

        @Override
        protected boolean executeRound(Element el, int round) throws Exception {
            switch (round) {
                case 0: {
                    return this.generateClassBody(this.path);
                }
                case 1: {
                    TreePath p = this.path;
                    if (this.path.getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                        p = new TreePath(this.path, ((NewClassTree)this.path.getLeaf()).getClassBody());
                    }
                    return this.generateImplementation(el, p);
                }
            }
            return false;
        }

        @Override
        public String toDebugString() {
            return "IAAM";
        }
    }

    private static class MakeAbstractFix
    extends JavaFix
    implements DebugFix {
        private final String makeClassAbstractName;

        public MakeAbstractFix(CompilationInfo info, TreePath tp, String makeClassAbstractName) {
            super(info, tp);
            this.makeClassAbstractName = makeClassAbstractName;
        }

        protected String getText() {
            return NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"LBL_FIX_Make_Class_Abstract", (Object)this.makeClassAbstractName);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            Tree.Kind k = ctx.getPath().getLeaf().getKind();
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)k)) {
                return;
            }
            ClassTree ct = (ClassTree)ctx.getPath().getLeaf();
            ModifiersTree mt = ct.getModifiers();
            HashSet<Modifier> mods = new HashSet<Modifier>(mt.getFlags());
            mods.remove((Object)Modifier.FINAL);
            mods.add(Modifier.ABSTRACT);
            ModifiersTree newMt = wc.getTreeMaker().Modifiers(mods, mt.getAnnotations());
            wc.rewrite((Tree)mt, (Tree)newMt);
        }

        @Override
        public String toDebugString() {
            return "MA:" + this.makeClassAbstractName;
        }
    }

    static final class ImplementOnEnumValues2
    extends ImplementFixBase {
        public ImplementOnEnumValues2(CompilationInfo info, TypeElement e, boolean prompt) {
            super(info, e, prompt);
        }

        public String getText() {
            return Bundle.LBL_FIX_Impl_Methods_Enum_Values2();
        }

        @Override
        public ModificationResult getModificationResult() throws IOException {
            return this.source.runModificationTask(parameter -> {});
        }

        @Override
        protected boolean executeRound(Element el, int round) throws Exception {
            if (el.getKind() != ElementKind.ENUM) {
                return false;
            }
            ClassTree ct = (ClassTree)this.path.getLeaf();
            ListIterator<? extends Tree> it = ct.getMembers().listIterator(ct.getMembers().size());
            block4: while (it.hasPrevious()) {
                Tree t = it.previous();
                if (t.getKind() != Tree.Kind.VARIABLE) continue;
                TreePath p = new TreePath(this.path, t);
                Element e = this.copy.getTrees().getElement(p);
                if (e == null || e.getKind() != ElementKind.ENUM_CONSTANT) continue;
                switch (round) {
                    case 0: {
                        if (this.generateClassBody(p)) continue block4;
                        return false;
                    }
                    case 1: {
                        if (this.generateImplementation(el, p)) continue block4;
                        return false;
                    }
                }
                throw new IllegalStateException();
            }
            return true;
        }

        @Override
        public String toDebugString() {
            return "IOEV";
        }
    }

    static abstract class ImplementFixBase
    extends CreateFixBase
    implements Task<WorkingCopy>,
    DebugFix {
        protected final JavaSource source;
        protected final TreePathHandle handle;
        protected final ElementHandle<TypeElement> implementType;
        protected final boolean displayUI;
        protected TreePath path;
        private boolean commit;
        protected WorkingCopy copy;
        private int round;
        private List<ElementHandle<? extends Element>> elementsToImplement;

        protected ImplementFixBase(CompilationInfo info, TreePath p, TypeElement el, boolean displayUI) {
            this.source = info.getJavaSource();
            this.handle = TreePathHandle.create((TreePath)p, (CompilationInfo)info);
            this.implementType = ElementHandle.create((Element)el);
            this.displayUI = displayUI;
        }

        protected ImplementFixBase(CompilationInfo info, TypeElement el, boolean displayUI) {
            this.source = info.getJavaSource();
            this.handle = TreePathHandle.create((Element)el, (CompilationInfo)info);
            this.implementType = ElementHandle.create((Element)el);
            this.displayUI = displayUI;
        }

        public ChangeInfo implement() throws Exception {
            if (this.displayUI) {
                final Future[] selector = new Future[]{null};
                this.source.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController ctrl) throws Exception {
                        TypeElement tel = (TypeElement)implementType.resolve((CompilationInfo)ctrl);
                        selector[0] = ImplementOverrideMethodGenerator.selectMethodsToImplement((CompilationInfo)ctrl, (TypeElement)tel);
                    }
                }, true);
                if (selector[0] != null) {
                    Future f = selector[0];
                    this.elementsToImplement = (List)f.get();
                    if (this.elementsToImplement == null) {
                        return null;
                    }
                }
            }
            ModificationResult res = this.source.runModificationTask((Task)this);
            if (!this.commit) {
                return null;
            }
            this.commit = false;
            ++this.round;
            res = this.source.runModificationTask((Task)this);
            if (this.commit) {
                res.commit();
            }
            return null;
        }

        protected abstract boolean executeRound(Element var1, int var2) throws Exception;

        public void run(WorkingCopy parameter) throws Exception {
            this.copy = parameter;
            parameter.toPhase(JavaSource.Phase.RESOLVED);
            this.path = this.handle.resolve((CompilationInfo)parameter);
            if (this.path == null) {
                return;
            }
            Element el = this.implementType.resolve((CompilationInfo)this.copy);
            if (el == null) {
                return;
            }
            this.commit = this.executeRound(el, this.round);
        }

        protected boolean generateClassBody(TreePath p) throws Exception {
            NewClassTree nct;
            VariableTree var;
            boolean isUsableElement;
            Element e = this.copy.getTrees().getElement(p);
            boolean bl = isUsableElement = e != null && (e.getKind().isClass() || e.getKind().isInterface());
            if (isUsableElement) {
                return true;
            }
            if (e.getKind() == ElementKind.ENUM_CONSTANT && (var = (VariableTree)p.getLeaf()).getInitializer() != null && var.getInitializer().getKind() == Tree.Kind.NEW_CLASS && (nct = (NewClassTree)var.getInitializer()).getClassBody() != null) {
                return true;
            }
            return !ImplementAllAbstractMethods.generateClassBody2(this.copy, p);
        }

        protected boolean generateImplementation(Element el, TreePath p) {
            Tree leaf = p.getLeaf();
            Element e = this.copy.getTrees().getElement(p);
            if (e != null && e.getKind() == ElementKind.ENUM_CONSTANT) {
                VariableTree var = (VariableTree)leaf;
                if (var.getInitializer() != null && var.getInitializer().getKind() == Tree.Kind.NEW_CLASS) {
                    NewClassTree nct = (NewClassTree)var.getInitializer();
                    assert (nct.getClassBody() != null);
                    TreePath enumInit = new TreePath(p, nct);
                    TreePath toModify = new TreePath(enumInit, nct.getClassBody());
                    ImplementAllAbstractMethods.generateAllAbstractMethodImplementations(this.copy, toModify, this.elementsToImplement);
                    return true;
                }
                return false;
            }
            if (el.getKind().isClass() || el.getKind().isInterface()) {
                ImplementAllAbstractMethods.generateAllAbstractMethodImplementations(this.copy, p, this.elementsToImplement);
                return true;
            }
            return false;
        }
    }
}

