/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.swing.JButton;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.introduce.FieldValidator;
import org.netbeans.modules.java.hints.introduce.IntroduceFieldPanel;
import org.netbeans.modules.java.hints.introduce.IntroduceFixBase;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.MemberSearchResult;
import org.netbeans.modules.java.hints.introduce.ReferenceTransformer;
import org.netbeans.modules.java.hints.introduce.TreeUtils;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

class IntroduceFieldFix
extends IntroduceFixBase
implements Fix {
    protected final String guessedName;
    private final int[] initilizeIn;
    private final boolean statik;
    private final boolean allowFinalInCurrentMethod;
    private final boolean permitDuplicates;
    private final TreePathHandle targetHandle;

    public IntroduceFieldFix(TreePathHandle handle, JavaSource js, String guessedName, int numDuplicates, int[] initilizeIn, boolean statik, boolean allowFinalInCurrentMethod, int offset, TreePathHandle target) {
        this(handle, js, guessedName, numDuplicates, initilizeIn, statik, allowFinalInCurrentMethod, offset, false, target);
    }

    public IntroduceFieldFix(TreePathHandle handle, JavaSource js, String guessedName, int numDuplicates, int[] initilizeIn, boolean statik, boolean allowFinalInCurrentMethod, int offset, boolean allowDuplicates, TreePathHandle target) {
        super(js, handle, numDuplicates, offset);
        this.guessedName = guessedName;
        this.initilizeIn = initilizeIn;
        this.statik = statik;
        this.allowFinalInCurrentMethod = allowFinalInCurrentMethod;
        this.permitDuplicates = allowDuplicates;
        this.targetHandle = target;
    }

    public String getText() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceField");
    }

    public String toString() {
        return "[IntroduceField:" + this.guessedName + ":" + this.duplicatesCount + ":" + this.statik + ":" + this.allowFinalInCurrentMethod + ":" + Arrays.toString(this.initilizeIn) + "]";
    }

    protected IntroduceFieldPanel createPanel(JButton btnOk) {
        return new IntroduceFieldPanel(this.guessedName, this.initilizeIn, this.permitDuplicates ? this.duplicatesCount : 1, this.allowFinalInCurrentMethod, this.handle.getKind() == Tree.Kind.VARIABLE, 0, "introduceField", btnOk);
    }

    protected String getCaption() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceField");
    }

    protected TreePath findTargetClass(WorkingCopy copy, TreePath resolved) {
        TreePath pathToClass;
        for (pathToClass = resolved; pathToClass != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)pathToClass.getLeaf().getKind()); pathToClass = pathToClass.getParentPath()) {
        }
        return pathToClass;
    }

    private TreePath findOutermostClass(WorkingCopy copy, TreePath resolved) {
        TreePath pathToClass;
        for (pathToClass = resolved; !(pathToClass == null || TreeUtilities.CLASS_TREE_KINDS.contains((Object)pathToClass.getLeaf().getKind()) && pathToClass.getParentPath().getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT); pathToClass = pathToClass.getParentPath()) {
        }
        return pathToClass;
    }

    public ChangeInfo implement() throws IOException, BadLocationException {
        JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
        btnOk.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceHint.class, (String)"AD_IntrHint_OK"));
        JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
        btnCancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceHint.class, (String)"AD_IntrHint_Cancel"));
        IntroduceFieldPanel panel = this.createPanel(btnOk);
        FieldValidator fv = new FieldValidator(this.js, null, this.handle);
        if (this.targetIsInterface) {
            panel.setAllowAccess(false);
        }
        DialogDescriptor dd = new DialogDescriptor((Object)panel, this.getCaption(), true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
        panel.setNotifier(dd.createNotificationLineSupport());
        panel.setTarget(this.targetHandle);
        panel.setValidator(fv);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
            return null;
        }
        this.js.runModificationTask((Task)new Worker(panel.getFieldName(), this.permitDuplicates && panel.isReplaceAll(), panel.isDeclareFinal(), panel.getAccess(), panel.getInitializeIn(), fv.getLastResult(), panel.isRefactorExisting())).commit();
        return null;
    }

    @Override
    public ModificationResult getModificationResult() throws IOException {
        return this.js.runModificationTask((Task)new Worker(this.guessedName, this.permitDuplicates, false, EnumSet.of(Modifier.PRIVATE), 2, null, false));
    }

    private final class Worker
    implements Task<WorkingCopy> {
        final String name;
        final boolean replaceAll;
        final boolean declareFinal;
        final Set<Modifier> access;
        final int initializeIn;
        final boolean refactorExisting;
        final MemberSearchResult searchResult;
        private ClassTree nueClass;
        private TreePath toRemoveFromParent;
        private boolean variableRewrite;
        private boolean expressionStatementRewrite;

        public Worker(String name, boolean replaceAll, boolean declareFinal, Set<Modifier> access, int initializeIn, MemberSearchResult searchResult, boolean refactorExisting) {
            this.name = name;
            this.replaceAll = replaceAll;
            this.declareFinal = declareFinal;
            this.access = access;
            this.initializeIn = initializeIn;
            this.refactorExisting = refactorExisting;
            this.searchResult = searchResult;
        }

        private boolean initializeFromMethod(WorkingCopy parameter, TreePath resolved, ExpressionTree expression, String name, TypeMirror tm) {
            TreeMaker make = parameter.getTreeMaker();
            TreePath statementPath = resolved;
            if ((statementPath = TreeUtils.findStatement(statementPath)) == null) {
                return false;
            }
            ExpressionStatementTree assignment = make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.Identifier((CharSequence)name), expression));
            StatementTree statement = (StatementTree)statementPath.getLeaf();
            this.insertStatement(parameter, statementPath.getParentPath(), statement, assignment, true);
            return true;
        }

        private boolean initializeConstructors(WorkingCopy parameter, TreePath method, TreePath pathToClass, ExpressionTree expression, String name) {
            TreeMaker make = parameter.getTreeMaker();
            for (TreePath constructor : TreeUtils.findConstructors((CompilationInfo)parameter, method)) {
                if (parameter.getTreeUtilities().isSynthetic(constructor)) {
                    LinkedList<ExpressionStatementTree> nueStatements = new LinkedList<ExpressionStatementTree>();
                    IdentifierTree reference = make.Identifier((CharSequence)name);
                    Element clazz = parameter.getTrees().getElement(pathToClass);
                    ModifiersTree modifiersTree = clazz == null || clazz.getKind() != ElementKind.ENUM ? make.Modifiers(EnumSet.of(Modifier.PUBLIC)) : make.Modifiers(Collections.EMPTY_SET);
                    nueStatements.add(make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)reference, expression)));
                    BlockTree nueBlock = make.Block(nueStatements, false);
                    MethodTree nueConstr = make.Method(modifiersTree, (CharSequence)"<init>", null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), nueBlock, null);
                    this.nueClass = IntroduceHint.INSERT_CLASS_MEMBER.insertClassMember(parameter, this.nueClass, nueConstr, IntroduceFieldFix.this.offset);
                    this.nueClass = make.removeClassMember(this.nueClass, constructor.getLeaf());
                    return true;
                }
                boolean hasParameterOfTheSameName = false;
                MethodTree constr = (MethodTree)constructor.getLeaf();
                if (constr.getBody() == null) continue;
                for (VariableTree variableTree : constr.getParameters()) {
                    if (!name.equals(variableTree.getName().toString())) continue;
                    hasParameterOfTheSameName = true;
                    break;
                }
                IdentifierTree reference = hasParameterOfTheSameName ? make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)name) : make.Identifier((CharSequence)name);
                ExpressionStatementTree expressionStatementTree = make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)reference, expression));
                this.insertStatement(parameter, new TreePath(constructor, constr.getBody()), null, expressionStatementTree, constructor.getLeaf() == method.getLeaf());
            }
            return true;
        }

        private void insertStatement(WorkingCopy parameter, TreePath target, Tree anchor, StatementTree assignment, boolean replace) {
            if ((this.variableRewrite || this.expressionStatementRewrite) && replace) {
                parameter.rewrite(this.toRemoveFromParent.getLeaf(), (Tree)assignment);
                this.toRemoveFromParent = null;
            } else {
                Utilities.insertStatement(parameter, target, anchor, Collections.singletonList(assignment), null, 0);
            }
        }

        public void run(WorkingCopy parameter) throws Exception {
            VariableTree field;
            EnumSet<Modifier> mods;
            TreePath matchPath;
            ExpressionTree expression;
            parameter.toPhase(JavaSource.Phase.RESOLVED);
            TreePath resolved = IntroduceFieldFix.this.handle.resolve((CompilationInfo)parameter);
            if (resolved == null) {
                return;
            }
            TypeMirror tm = IntroduceHint.resolveType((CompilationInfo)parameter, resolved);
            if (tm == null) {
                return;
            }
            tm = Utilities.convertIfAnonymous(Utilities.resolveTypeForDeclaration((CompilationInfo)parameter, tm));
            TreePath pathToClass = IntroduceFieldFix.this.findTargetClass(parameter, resolved);
            if (pathToClass == null) {
                return;
            }
            Tree original = resolved.getLeaf();
            boolean bl = this.variableRewrite = original.getKind() == Tree.Kind.VARIABLE;
            if (this.variableRewrite) {
                expression = ((VariableTree)original).getInitializer();
                matchPath = new TreePath(resolved, expression);
            } else {
                expression = (ExpressionTree)resolved.getLeaf();
                matchPath = resolved;
            }
            EnumSet<Modifier> enumSet = mods = this.declareFinal ? EnumSet.of(Modifier.FINAL) : EnumSet.noneOf(Modifier.class);
            if (IntroduceFieldFix.this.statik) {
                mods.add(Modifier.STATIC);
            }
            mods.addAll(this.access);
            TreeMaker make = parameter.getTreeMaker();
            boolean isAnyOccurenceStatic = false;
            Set<Tree> allNewUses = Collections.newSetFromMap(new IdentityHashMap());
            allNewUses.add(resolved.getLeaf());
            ArrayList<TreePath> duplicates = new ArrayList<TreePath>();
            if (this.replaceAll) {
                for (TreePath p : SourceUtils.computeDuplicates((CompilationInfo)parameter, (TreePath)resolved, (TreePath)IntroduceFieldFix.this.findOutermostClass(parameter, resolved), (AtomicBoolean)new AtomicBoolean())) {
                    if (this.variableRewrite) {
                        IntroduceHint.removeFromParent(parameter, p);
                    } else {
                        parameter.rewrite(p.getLeaf(), (Tree)make.Identifier((CharSequence)this.name));
                        allNewUses.add(p.getLeaf());
                    }
                    Scope occurenceScope = parameter.getTrees().getScope(p);
                    if (parameter.getTreeUtilities().isStaticContext(occurenceScope)) {
                        isAnyOccurenceStatic = true;
                    }
                    duplicates.add(p);
                }
            }
            if (!IntroduceFieldFix.this.statik && isAnyOccurenceStatic) {
                mods.add(Modifier.STATIC);
            }
            pathToClass = IntroduceHint.findTargetClassWithDuplicates(pathToClass, duplicates);
            ModifiersTree modsTree = make.Modifiers(mods);
            Tree parentTree = resolved.getParentPath().getLeaf();
            boolean bl2 = this.expressionStatementRewrite = parentTree.getKind() == Tree.Kind.EXPRESSION_STATEMENT;
            if (!this.variableRewrite) {
                Tree varType = make.Type(tm);
                field = make.Variable(modsTree, (CharSequence)this.name, varType, this.initializeIn == 2 ? expression : null);
                parameter.tag(varType, (Object)"typeTag");
                if (!this.expressionStatementRewrite) {
                    Tree nueParent = parameter.getTreeUtilities().translate(parentTree, Collections.singletonMap(resolved.getLeaf(), make.Identifier((CharSequence)this.name)));
                    parameter.rewrite(parentTree, nueParent);
                    this.toRemoveFromParent = null;
                } else {
                    this.toRemoveFromParent = resolved.getParentPath();
                }
            } else {
                Tree originalVarType = ((VariableTree)original).getType();
                field = make.Variable(modsTree, (CharSequence)this.name, originalVarType, this.initializeIn == 2 ? expression : null);
                parameter.tag(originalVarType, (Object)"typeTag");
                this.toRemoveFromParent = resolved;
            }
            this.nueClass = IntroduceHint.insertField(parameter, (ClassTree)pathToClass.getLeaf(), field, allNewUses, IntroduceFieldFix.this.offset);
            TreePath method = TreeUtils.findMethod(resolved);
            if ((this.initializeIn & 5) > 0) {
                if (method == null) {
                    return;
                }
                switch (this.initializeIn) {
                    case 1: {
                        if (this.initializeFromMethod(parameter, resolved, expression, this.name, tm)) break;
                        return;
                    }
                    case 4: {
                        if (this.initializeConstructors(parameter, method, pathToClass, expression, this.name)) break;
                        return;
                    }
                }
            }
            if (this.toRemoveFromParent != null) {
                IntroduceHint.removeFromParent(parameter, this.toRemoveFromParent);
            }
            if (this.refactorExisting) {
                new ReferenceTransformer(parameter, ElementKind.FIELD, this.searchResult, this.name, parameter.getTrees().getElement(pathToClass)).scan(pathToClass, null);
            }
            parameter.rewrite(pathToClass.getLeaf(), (Tree)this.nueClass);
        }
    }
}

