/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class ConvertTextBlockToString {
    public static ErrorDescription computeWarning(HintContext ctx) {
        TokenSequence ts = ctx.getInfo().getTokenHierarchy().tokenSequence();
        if (ts == null) {
            return null;
        }
        int textBlockIndex = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getPath().getCompilationUnit(), ctx.getPath().getLeaf());
        if (textBlockIndex == -1) {
            return null;
        }
        ts.move(textBlockIndex);
        if (!ts.moveNext() || ts.token().id() != JavaTokenId.MULTILINE_STRING_LITERAL) {
            return null;
        }
        String orignalString = (String)((LiteralTree)ctx.getPath().getLeaf()).getValue();
        String[] orignalStringArr = ConvertTextBlockToString.textBlockToStringArr(orignalString);
        Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), orignalStringArr).toEditorFix();
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ConvertTextBlockToString(), (Fix[])new Fix[]{fix});
    }

    private static String[] textBlockToStringArr(String textBlock) {
        String[] oneLine = textBlock.split("\n", -1);
        return oneLine;
    }

    private static final class FixImpl
    extends JavaFix {
        String[] orignalStringArr;

        public FixImpl(CompilationInfo info, TreePath tp, String[] orignalStringArr) {
            super(info, tp);
            this.orignalStringArr = orignalStringArr;
        }

        protected String getText() {
            return Bundle.FIX_ConvertTextBlockToString();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            ExpressionTree ext = ctx.getWorkingCopy().getTreeMaker().Literal((Object)this.orignalStringArr[this.orignalStringArr.length - 1]);
            if (this.orignalStringArr.length > 1) {
                ext = ctx.getWorkingCopy().getTreeMaker().Binary(Tree.Kind.PLUS, FixImpl.buildTree(this.orignalStringArr, this.orignalStringArr.length - 2, ctx), ext);
                if (this.orignalStringArr[this.orignalStringArr.length - 1].equals("")) {
                    ext = ((BinaryTree)ext).getLeftOperand();
                }
            }
            ctx.getWorkingCopy().rewrite(ctx.getPath().getLeaf(), (Tree)ext);
        }

        private static ExpressionTree buildTree(String[] textBlockLines, int currentLine, JavaFix.TransformationContext ctx) {
            if (currentLine == 0) {
                return ctx.getWorkingCopy().getTreeMaker().Literal((Object)(textBlockLines[0] + "\n"));
            }
            return ctx.getWorkingCopy().getTreeMaker().Binary(Tree.Kind.PLUS, FixImpl.buildTree(textBlockLines, currentLine - 1, ctx), (ExpressionTree)ctx.getWorkingCopy().getTreeMaker().Literal((Object)(textBlockLines[currentLine] + "\n")));
        }
    }
}

