/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import eu.hansolo.jdktools.Architecture;
import eu.hansolo.jdktools.ArchiveType;
import eu.hansolo.jdktools.Bitness;
import eu.hansolo.jdktools.Latest;
import eu.hansolo.jdktools.LibCType;
import eu.hansolo.jdktools.OperatingSystem;
import eu.hansolo.jdktools.PackageType;
import eu.hansolo.jdktools.ReleaseStatus;
import eu.hansolo.jdktools.TermOfSupport;
import eu.hansolo.jdktools.versioning.Semver;
import eu.hansolo.jdktools.versioning.VersionNumber;
import io.foojay.api.discoclient.DiscoClient;
import io.foojay.api.discoclient.event.Evt;
import io.foojay.api.discoclient.event.EvtObserver;
import io.foojay.api.discoclient.event.EvtType;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.MajorVersion;
import io.foojay.api.discoclient.pkg.Pkg;
import io.foojay.api.discoclient.pkg.Scope;
import io.foojay.api.discoclient.util.PkgInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netbeans.modules.java.disco.DiscoPlatformInstall;

public class Client {
    private static final Client INSTANCE = new Client();
    private DiscoClient client = null;
    private List<MajorVersion> majorVersions;
    private List<Distribution> distributions;

    private Client() {
    }

    public static Client getInstance() {
        return INSTANCE;
    }

    private synchronized DiscoClient getDisco() {
        if (this.client == null) {
            this.client = new DiscoClient(DiscoPlatformInstall.clientName());
        }
        return this.client;
    }

    public synchronized List<MajorVersion> getAllMajorVersions() {
        if (this.majorVersions == null) {
            this.majorVersions = Collections.unmodifiableList(new ArrayList(this.getDisco().getAllMajorVersions(true)));
        }
        return this.majorVersions;
    }

    public synchronized List<Distribution> getDistributions() {
        if (this.distributions == null) {
            this.distributions = Collections.unmodifiableList(this.getDisco().getDistributions().stream().filter(distribution -> distribution.getScopes().contains(Scope.BUILD_OF_OPEN_JDK)).filter(distribution -> distribution.getScopes().contains(Scope.PUBLIC)).collect(Collectors.toList()));
        }
        return this.distributions;
    }

    public Stream<MajorVersion> getAllMaintainedMajorVersions() {
        return this.getAllMajorVersions().stream().filter(v -> v.isEarlyAccessOnly() != null && v.isEarlyAccessOnly() == false).filter(MajorVersion::isMaintained);
    }

    public MajorVersion getLatestGAVersion() {
        return this.getAllMaintainedMajorVersions().findFirst().orElse(new MajorVersion(21));
    }

    public MajorVersion getLatestEAVersion() {
        return this.getAllMajorVersions().stream().filter(v -> v.isEarlyAccessOnly() != null && v.isEarlyAccessOnly() != false).findFirst().orElse(new MajorVersion(21));
    }

    public synchronized List<Pkg> getPkgs(Distribution distribution, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, Architecture architecture, ArchiveType archiveType, PackageType packageType, boolean ea, boolean javafxBundled) {
        return this.getDisco().getPkgs(List.of(distribution), versionNumber, latest, operatingSystem, LibCType.NONE, architecture, Bitness.NONE, archiveType, packageType, Boolean.valueOf(javafxBundled), Boolean.valueOf(true), ea ? List.of(ReleaseStatus.GA, ReleaseStatus.EA) : List.of(ReleaseStatus.GA), TermOfSupport.NONE, List.of(Scope.PUBLIC), null);
    }

    public Optional<Distribution> getDistribution(String text) {
        return this.getDistributions().stream().filter(d -> d.getSynonyms().contains(text)).findFirst();
    }

    public synchronized PkgInfo getPkgInfo(String ephemeralId, Semver javaVersion) {
        return this.getDisco().getPkgInfoByEphemeralId(ephemeralId, javaVersion);
    }

    public synchronized Future<?> downloadPkg(PkgInfo pkgInfo, String absolutePath) throws InterruptedException {
        return this.getDisco().downloadPkg(pkgInfo, absolutePath);
    }

    public synchronized void setOnEvt(EvtType<? extends Evt> type, EvtObserver observer) {
        this.getDisco().setOnEvt(type, observer);
    }

    public synchronized void removeAllObservers() {
        this.getDisco().removeAllObservers();
    }
}

