/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import com.google.common.collect.Maps;
import eu.hansolo.jdktools.Architecture;
import eu.hansolo.jdktools.ArchiveType;
import eu.hansolo.jdktools.Latest;
import eu.hansolo.jdktools.OperatingSystem;
import eu.hansolo.jdktools.PackageType;
import eu.hansolo.jdktools.TermOfSupport;
import eu.hansolo.jdktools.versioning.VersionNumber;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.MajorVersion;
import io.foojay.api.discoclient.pkg.Pkg;
import io.foojay.api.discoclient.util.Helper;
import java.awt.CardLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ListSelectionModel;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.netbeans.modules.java.disco.AdvancedPanel;
import org.netbeans.modules.java.disco.Client;
import org.netbeans.modules.java.disco.FirstPanel;
import org.netbeans.modules.java.disco.OS;
import org.netbeans.modules.java.disco.PkgSelection;
import org.netbeans.modules.java.disco.QuickPanel;
import org.netbeans.modules.java.disco.QuickPkgSelection;
import org.netbeans.modules.java.disco.SwingWorker2;
import org.openide.util.Exceptions;

public class SelectPackagePanel
extends FirstPanel {
    private static final Logger log = Logger.getLogger(SelectPackagePanel.class.getName());
    public static final String PROP_VALIDITY_CHANGED = "panelValidityChanged";
    private final Client discoClient = Client.getInstance();
    private final QuickPanel quickPanel = new QuickPanel();
    private final FooAdvancedPanel advancedPanel = new FooAdvancedPanel();
    private boolean initialLoad = false;

    @UIEffect
    public static SelectPackagePanel create() {
        SelectPackagePanel f = new SelectPackagePanel();
        f.init();
        return f;
    }

    @UIEffect
    private SelectPackagePanel() {
        ((CardLayout)this.getLayout()).first(this);
        this.tabs.add("Quick", this.quickPanel);
        this.tabs.add("Advanced", this.advancedPanel);
        this.tabs.addChangeListener(e -> this.firePropertyChange(PROP_VALIDITY_CHANGED, false, true));
    }

    @UIEffect
    private void init() {
        this.setName("Connect to OpenJDK Discovery Service");
    }

    @Override
    @UIEffect
    public void addNotify() {
        class Result {
            final List<Integer> versionNumbers;
            final Map<Integer, TermOfSupport> versionNumberSupport;
            final List<Distribution> distributions;

            public Result(List<Integer> versionNumbers, Map<Integer, TermOfSupport> versionNumberSupport, List<Distribution> distributions) {
                this.versionNumbers = versionNumbers;
                this.versionNumberSupport = versionNumberSupport;
                this.distributions = distributions;
            }
        }
        super.addNotify();
        if (this.initialLoad) {
            return;
        }
        this.initialLoad = true;
        SwingWorker2.submit(() -> {
            List<Distribution> distros = this.discoClient.getDistributions();
            Map<Integer, TermOfSupport> majorVersions = this.discoClient.getAllMajorVersions().stream().collect(Collectors.toMap(MajorVersion::getAsInt, MajorVersion::getTermOfSupport));
            MajorVersion nextRelease = this.discoClient.getLatestSts(true);
            Integer nextFeatureRelease = nextRelease.getAsInt();
            ArrayList<Integer> versionNumbers = new ArrayList<Integer>();
            Integer i = 6;
            while (i <= nextFeatureRelease) {
                versionNumbers.add(i);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            HashMap<Integer, TermOfSupport> versionNumberSupport = new HashMap<Integer, TermOfSupport>(Maps.filterKeys(majorVersions, v -> versionNumbers.contains(v)));
            return new Result(versionNumbers, versionNumberSupport, distros);
        }).then(c -> {
            ((CardLayout)this.getLayout()).next(this);
            this.advancedPanel.updateDistributions(c.distributions);
            this.advancedPanel.setVersions(c.versionNumbers, c.versionNumberSupport);
            this.quickPanel.setVersions(c.versionNumbers, c.versionNumberSupport);
            this.firePropertyChange(PROP_VALIDITY_CHANGED, false, true);
        }).handle(ex -> {
            this.loadingLabel.setText("Could not load list due to an error. Please try again later.");
            this.initialLoad = false;
            long currentTimeMillisStart = System.currentTimeMillis();
            SwingWorker2.submit(() -> {
                String body = (String)Helper.get((String)"http://www.example.com").body();
                return body != null && !"".equals(body);
            }).then(isOnline -> {
                long now = System.currentTimeMillis();
                if (isOnline.booleanValue() && now - currentTimeMillisStart <= 300L) {
                    Exceptions.printStackTrace((Throwable)ex);
                } else {
                    log.log(Level.INFO, "Could not load initial list", (Throwable)ex);
                }
            }).handle(ex2 -> {
                log.log(Level.INFO, "Could not load initial list", (Throwable)ex);
                log.log(Level.INFO, "Could not check network connectivity", (Throwable)ex2);
            }).execute();
        }).execute();
    }

    @UIEffect
    public @Nullable PkgSelection getSelectedPackage() {
        if (!this.tabs.isVisible()) {
            return null;
        }
        switch (this.tabs.getSelectedIndex()) {
            case 0: {
                return new QuickPkgSelection(this.quickPanel.getSelectedPackage());
            }
            case 1: {
                Pkg pkg = this.advancedPanel.getSelectedPackage();
                if (pkg == null) {
                    return null;
                }
                return PkgSelection.of(pkg);
            }
        }
        throw new IllegalStateException();
    }

    class FooAdvancedPanel
    extends AdvancedPanel {
        FooAdvancedPanel() {
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            selectionModel.addListSelectionListener(e -> SelectPackagePanel.this.firePropertyChange(SelectPackagePanel.PROP_VALIDITY_CHANGED, false, true));
        }

        @Override
        @UIEffect
        protected void updateData(Distribution distribution, Integer featureVersion, Latest latest, PackageType bundleType) {
            if (distribution == null) {
                return;
            }
            if (featureVersion == null) {
                return;
            }
            OperatingSystem operatingSystem = OS.getOperatingSystem();
            Architecture architecture = Architecture.NONE;
            ArchiveType extension = ArchiveType.NONE;
            Boolean fx = false;
            this.setEnabled(false);
            SwingWorker2.submit(() -> {
                List<Pkg> bundles = SelectPackagePanel.this.discoClient.getPkgs(distribution, new VersionNumber(featureVersion), latest, operatingSystem, architecture, extension, bundleType, fx);
                return bundles;
            }).then(this::setPackages).handle(Exceptions::printStackTrace).execute();
        }

        @Override
        protected void updateDistributions(List<Distribution> distros) {
            super.updateDistributions(distros);
        }

        @UIEffect
        private void setPackages(List<Pkg> bundles) {
            SelectPackagePanel.this.setEnabled(true);
            this.tableModel.setBundles(bundles);
        }
    }
}

