/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class SourcePathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final String BUILD_DIR = "build.dir";
    private static final String BUILD_GENERATED_DIR = "build.generated.sources.dir";
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private List<PathResourceImplementation> resources;
    private final SourceRoots sourceRoots;
    private final AntProjectHelper projectHelper;
    private final PropertyEvaluator evaluator;
    private File buildGeneratedDir = null;
    private final FileChangeListener buildGeneratedDirListener = new FileChangeAdapter(){

        public void fileFolderCreated(FileEvent fe) {
            SourcePathImplementation.this.invalidate();
        }

        public void fileDeleted(FileEvent fe) {
            SourcePathImplementation.this.invalidate();
        }

        public void fileRenamed(FileRenameEvent fe) {
            SourcePathImplementation.this.invalidate();
        }
    };

    SourcePathImplementation(SourceRoots sourceRoots, AntProjectHelper projectHelper, PropertyEvaluator evaluator) {
        assert (sourceRoots != null && projectHelper != null && evaluator != null);
        this.sourceRoots = sourceRoots;
        this.sourceRoots.addPropertyChangeListener(this);
        this.projectHelper = projectHelper;
        this.evaluator = evaluator;
        evaluator.addPropertyChangeListener((PropertyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        SourcePathImplementation sourcePathImplementation = this;
        synchronized (sourcePathImplementation) {
            this.resources = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        SourcePathImplementation sourcePathImplementation = this;
        synchronized (sourcePathImplementation) {
            if (this.resources != null) {
                return this.resources;
            }
        }
        URL[] roots = this.sourceRoots.getRootURLs();
        class PRI
        implements FilteringPathResourceImplementation,
        PropertyChangeListener {
            PropertyChangeSupport pcs = new PropertyChangeSupport(this);
            PathMatcher matcher;

            PRI() {
                SourcePathImplementation.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)SourcePathImplementation.this.evaluator));
            }

            public URL[] getRoots() {
                return new URL[]{root};
            }

            public boolean includes(URL root2, String resource) {
                if (this.matcher == null) {
                    this.matcher = new PathMatcher(SourcePathImplementation.this.evaluator.getProperty("includes"), SourcePathImplementation.this.evaluator.getProperty("excludes"), Utilities.toFile((URI)URI.create(root2.toExternalForm())));
                }
                return this.matcher.matches(resource, true);
            }

            public ClassPathImplementation getContent() {
                return null;
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
                this.pcs.addPropertyChangeListener(listener);
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
                this.pcs.removePropertyChangeListener(listener);
            }

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                String prop = ev.getPropertyName();
                if (prop == null || prop.equals("includes") || prop.equals("excludes")) {
                    this.matcher = null;
                    PropertyChangeEvent ev2 = new PropertyChangeEvent(this, "includes", null, null);
                    ev2.setPropagationId(ev);
                    this.pcs.firePropertyChange(ev2);
                }
            }
        }
        ArrayList<PRI> result = new ArrayList<PRI>(roots.length);
        for (final URL root : roots) {
            result.add(new PRI());
        }
        try {
            File file = this.getBuildGeneratedDir();
            if (file != null) {
                File[] children;
                File apSourcesDir;
                String apSourcesDirS = this.evaluator.getProperty("annotation.processing.source.output");
                File file2 = apSourcesDir = apSourcesDirS != null ? this.projectHelper.resolveFile(apSourcesDirS) : null;
                if (file.isDirectory() && (children = file.listFiles()) != null) {
                    for (File root : children) {
                        if (!root.isDirectory() || root.equals(apSourcesDir)) continue;
                        result.add((PRI)ClassPathSupport.createResource((URL)Utilities.toURI((File)root).toURL()));
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        SourcePathImplementation sourcePathImplementation2 = this;
        synchronized (sourcePathImplementation2) {
            if (this.resources == null) {
                this.resources = Collections.unmodifiableList(result);
            }
        }
        return this.resources;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (SourceRoots.PROP_ROOTS.equals(evt.getPropertyName())) {
            this.invalidate();
        } else if (this.evaluator != null && evt.getSource() == this.evaluator && (evt.getPropertyName() == null || BUILD_DIR.equals(evt.getPropertyName()))) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getBuildGeneratedDir() {
        String buildGeneratedDirS = this.evaluator.getProperty(BUILD_GENERATED_DIR);
        File _buildGeneratedDir = buildGeneratedDirS == null ? null : this.projectHelper.resolveFile(buildGeneratedDirS);
        SourcePathImplementation sourcePathImplementation = this;
        synchronized (sourcePathImplementation) {
            if (_buildGeneratedDir == null || !_buildGeneratedDir.equals(this.buildGeneratedDir)) {
                if (this.buildGeneratedDir != null) {
                    FileUtil.removeFileChangeListener((FileChangeListener)this.buildGeneratedDirListener, (File)this.buildGeneratedDir);
                }
                this.buildGeneratedDir = _buildGeneratedDir;
                if (this.buildGeneratedDir != null) {
                    FileUtil.addFileChangeListener((FileChangeListener)this.buildGeneratedDirListener, (File)this.buildGeneratedDir);
                }
            }
            return this.buildGeneratedDir;
        }
    }
}

