/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.glassfish.eecommon.api.config.GlassfishConfiguration;
import org.netbeans.modules.j2ee.dd.api.client.AppClientMetadata;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.sun.ddloaders.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public abstract class CommonBeanReader {
    protected String propertyName;
    private static WeakHashMap<String, Method> methodMap = new WeakHashMap();

    protected void addMapString(Map<String, Object> map, String property, String value) {
        if (Utils.notEmpty(value)) {
            map.put(property, value);
        }
    }

    public CommonBeanReader(String propertyName) {
        this.propertyName = propertyName;
    }

    public Map<String, Object> readDescriptor(CommonDDBean commonDD) {
        Map<String, Object> result = null;
        try {
            Object value;
            commonDD = this.normalizeParent(commonDD);
            Object object = value = commonDD != null ? CommonBeanReader.getChild(commonDD, this.propertyName) : null;
            if (value != null && value.getClass().isArray() && value instanceof CommonDDBean[]) {
                result = this.genProperties((CommonDDBean[])value);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return result;
    }

    public Map<String, Object> readAnnotations(DataObject dObj) {
        Map<String, Object> result = null;
        try {
            J2eeModule module;
            File key = FileUtil.toFile((FileObject)dObj.getPrimaryFile());
            GlassfishConfiguration dc = GlassfishConfiguration.getConfiguration((File)key);
            if (dc != null && (module = dc.getJ2eeModule()) != null) {
                if (J2eeModule.Type.WAR == module.getType()) {
                    result = this.readWebAppMetadata((MetadataModel<WebAppMetadata>)module.getMetadataModel(WebAppMetadata.class));
                } else if (J2eeModule.Type.EJB == module.getType()) {
                    result = this.readEjbJarMetadata((MetadataModel<EjbJarMetadata>)module.getMetadataModel(EjbJarMetadata.class));
                } else if (J2eeModule.Type.CAR == module.getType()) {
                    result = this.readAppClientMetadata((MetadataModel<AppClientMetadata>)module.getMetadataModel(AppClientMetadata.class));
                }
            }
        }
        catch (MetadataModelException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return result;
    }

    protected abstract Map<String, Object> genProperties(CommonDDBean[] var1);

    protected CommonDDBean normalizeParent(CommonDDBean oldParent) {
        return oldParent;
    }

    protected CommonDDBean findEjbByName(EjbJar ejbJar, String ejbName) {
        CommonDDBean match = null;
        EnterpriseBeans eb = ejbJar.getEnterpriseBeans();
        if (eb != null) {
            match = this.findEjbByName((Ejb[])eb.getSession(), ejbName);
            if (match == null) {
                match = this.findEjbByName((Ejb[])eb.getMessageDriven(), ejbName);
            }
            if (match == null) {
                match = this.findEjbByName((Ejb[])eb.getEntity(), ejbName);
            }
        }
        return match;
    }

    protected CommonDDBean findEjbByName(Ejb[] ejbs, String ejbName) {
        Ejb match = null;
        if (ejbs != null) {
            for (Ejb ejb : ejbs) {
                if (!ejbName.equals(ejb.getEjbName())) continue;
                match = ejb;
                break;
            }
        }
        return match;
    }

    public Map<String, Object> readWebAppMetadata(MetadataModel<WebAppMetadata> model) throws MetadataModelException, IOException {
        return (Map)model.runReadAction((MetadataModelAction)new WebAppCommonReader());
    }

    public Map<String, Object> readAppClientMetadata(MetadataModel<AppClientMetadata> model) throws MetadataModelException, IOException {
        return (Map)model.runReadAction((MetadataModelAction)new AppClientCommonReader());
    }

    public Map<String, Object> readEjbJarMetadata(MetadataModel<EjbJarMetadata> model) throws MetadataModelException, IOException {
        return (Map)model.runReadAction((MetadataModelAction)new EjbJarCommonReader());
    }

    public Map<String, Object> readWebservicesMetadata(MetadataModel<WebservicesMetadata> model) throws MetadataModelException, IOException {
        return (Map)model.runReadAction((MetadataModelAction)new WebservicesCommonReader());
    }

    private static Object getChild(CommonDDBean bean, String propertyName) {
        Object result = null;
        try {
            String getterName = "get" + propertyName;
            Class<?> beanClass = bean.getClass();
            String key = beanClass.getName() + getterName;
            Method getter = methodMap.get(key);
            if (getter == null) {
                getter = beanClass.getMethod(getterName, new Class[0]);
                methodMap.put(key, getter);
            }
            result = getter.invoke((Object)bean, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof UnsupportedOperationException) {
                ErrorManager.getDefault().log(16, "!!!" + bean.getClass().getName() + ".get" + propertyName + " is not supported by metamodel yet.");
            } else {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return result;
    }

    public class WebAppCommonReader
    extends CommonReader
    implements MetadataModelAction<WebAppMetadata, Map<String, Object>> {
        public Map<String, Object> run(WebAppMetadata metadata) throws Exception {
            return this.genCommonProperties((CommonDDBean)metadata.getRoot());
        }
    }

    public class AppClientCommonReader
    extends CommonReader
    implements MetadataModelAction<AppClientMetadata, Map<String, Object>> {
        public Map<String, Object> run(AppClientMetadata metadata) throws Exception {
            return this.genCommonProperties((CommonDDBean)metadata.getRoot());
        }
    }

    public class EjbJarCommonReader
    extends CommonReader
    implements MetadataModelAction<EjbJarMetadata, Map<String, Object>> {
        public Map<String, Object> run(EjbJarMetadata metadata) throws Exception {
            return this.genCommonProperties((CommonDDBean)metadata.getRoot());
        }
    }

    public class WebservicesCommonReader
    extends CommonReader
    implements MetadataModelAction<WebservicesMetadata, Map<String, Object>> {
        public Map<String, Object> run(WebservicesMetadata metadata) throws Exception {
            return this.genCommonProperties((CommonDDBean)metadata.getRoot());
        }
    }

    public class CommonReader {
        public Map<String, Object> genCommonProperties(CommonDDBean parentDD) {
            Object value;
            Map<String, Object> result = null;
            CommonDDBean relativeParentDD = CommonBeanReader.this.normalizeParent(parentDD);
            if (relativeParentDD != null && (value = CommonBeanReader.getChild(relativeParentDD, CommonBeanReader.this.propertyName)) != null && value.getClass().isArray() && value instanceof CommonDDBean[]) {
                result = CommonBeanReader.this.genProperties((CommonDDBean[])value);
            }
            return result;
        }
    }
}

