/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.j2ee.sun.ddloaders.SunDescriptorDataObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class SunDescriptorDataNode
extends DataNode {
    private static final String SUN_DD = "sundd";
    private SunDescriptorDataObject dataObject;
    public static final String PROPERTY_DOCUMENT_TYPE = "documentType";
    private PropertyChangeListener ddListener;

    public SunDescriptorDataNode(SunDescriptorDataObject obj) {
        this(obj, Children.LEAF);
    }

    public SunDescriptorDataNode(SunDescriptorDataObject obj, Children ch) {
        super((DataObject)obj, ch);
        this.dataObject = obj;
        this.initListeners();
        this.setIconBase(this.dataObject.getSaxError() == null);
    }

    private void initListeners() {
        this.ddListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                Object oldValue = evt.getOldValue();
                Object newValue = evt.getNewValue();
                if ("documentDTD".equals(propertyName)) {
                    SunDescriptorDataNode.this.firePropertyChange(SunDescriptorDataNode.PROPERTY_DOCUMENT_TYPE, oldValue, newValue);
                } else if ("valid".equals(propertyName) && Boolean.TRUE.equals(newValue)) {
                    SunDescriptorDataNode.this.removePropertyChangeListener(SunDescriptorDataNode.this.ddListener);
                } else if ("document_valid".equals(propertyName)) {
                    SunDescriptorDataNode.this.setIconBase(Boolean.TRUE.equals(newValue));
                } else if ("propertySets".equals(propertyName)) {
                    SunDescriptorDataNode.this.firePropertySetsChange(null, null);
                } else if ("sax_error".equals(propertyName)) {
                    SunDescriptorDataNode.this.fireShortDescriptionChange((String)oldValue, (String)newValue);
                }
            }
        };
        this.getDataObject().addPropertyChangeListener(this.ddListener);
    }

    private void setIconBase(boolean valid) {
        if (valid) {
            this.setIconBaseWithExtension(this.dataObject.getIconBaseForValidDocument());
        } else {
            this.setIconBaseWithExtension(this.dataObject.getIconBaseForInvalidDocument());
        }
        this.fireIconChange();
    }

    protected Sheet createSheet() {
        Sheet s = new Sheet();
        Sheet.Set ss = new Sheet.Set();
        ss.setName(SUN_DD);
        ss.setDisplayName(NbBundle.getMessage(SunDescriptorDataNode.class, (String)"PROP_deploymentSet"));
        ss.setShortDescription(NbBundle.getMessage(SunDescriptorDataNode.class, (String)"HINT_deploymentSet"));
        ss.setValue("helpID", (Object)"TBD: sun-dd node");
        s.put(ss);
        return s;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Image getIcon(int type) {
        String iconBase = this.dataObject.getIconBaseForValidDocument();
        Image sunDDIcon = ImageUtilities.loadImage((String)(iconBase + ".gif"));
        if (this.dataObject.getSaxError() == null) {
            return sunDDIcon;
        }
        Image errorBadgeIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/sun/ddloaders/resources/ErrorBadge.gif");
        return ImageUtilities.mergeImages((Image)sunDDIcon, (Image)errorBadgeIcon, (int)6, (int)6);
    }

    public String getShortDescription() {
        SAXException saxError = this.dataObject.getSaxError();
        if (saxError == null) {
            return NbBundle.getMessage(SunDescriptorDataNode.class, (String)"LBL_NodeShortDescription");
        }
        return saxError.getMessage();
    }
}

