/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.api.restricted;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishVersion;
import org.netbeans.modules.glassfish.tooling.utils.OsUtils;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.sun.api.ServerInterface;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceConfigurator;
import org.netbeans.modules.j2ee.sun.api.restricted.SunDatasource;
import org.netbeans.modules.j2ee.sun.api.restricted.SunMessageDestination;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JmsResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.MailResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PersistenceManagerFactoryResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PropertyElement;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePair;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ConnPoolBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.DataSourceBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JMSBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JavaMailSessionBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.PersistenceManagerBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.sunresources.beans.DatabaseUtils;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class ResourceUtils
implements WizardConstants {
    static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.sunresources.beans.Bundle");
    static final String[] sysDatasources = new String[]{"jdbc/__TimerPool", "jdbc/__CallFlowPool"};
    static final String[] sysConnpools = new String[]{"__CallFlowPool", "__TimerPool"};
    static final String SAMPLE_DATASOURCE = "jdbc/sample";
    static final String SAMPLE_CONNPOOL = "SamplePool";
    private static final Logger LOGGER = Logger.getLogger(ResourceUtils.class.getName());
    public static final String WEB_INF = "WEB-INF";
    public static final String META_INF = "META-INF";
    private static final String RESOURCE_FILES_SUFFIX = ".xml";
    static final String[] RESOURCE_FILES = new String[]{"glassfish-resources.xml", "sun-resources.xml"};
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static final char REPLACEMENT_CHAR = '_';
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|', ','};
    private static final char[] ILLEGAL_RESOURCE_NAME_CHARS = new char[]{':', '*', '?', '\"', '<', '>', '|', ','};

    public static void saveNodeToXml(FileObject resFile, Resources res) {
        try {
            res.write(FileUtil.toFile((FileObject)resFile));
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "saveNodeToXml failed", ex);
        }
    }

    public static void register(Resources resource, SunDeploymentManagerInterface sunDm, boolean update, String resType) throws Exception {
        if (sunDm.isRunning()) {
            ServerInterface mejb = sunDm.getManagement();
            if (resType.equals("jdbc-connection-pool")) {
                ResourceUtils.register(resource.getJdbcConnectionPool(0), mejb, update);
            } else if (resType.equals("jdbc-resource")) {
                ResourceUtils.register(resource.getJdbcResource(0), mejb, update);
            } else if (resType.equals("persistence-manager-factory-resource")) {
                ResourceUtils.register(resource.getPersistenceManagerFactoryResource(0), mejb, update);
            } else if (resType.equals("mail-resource")) {
                ResourceUtils.register(resource.getMailResource(0), mejb, update);
            } else if (resType.equals("jms-resource")) {
                if (resource.getAdminObjectResource().length != 0) {
                    ResourceUtils.register(resource.getAdminObjectResource(0), mejb, update);
                } else if (resource.getConnectorResource().length != 0 && resource.getConnectorConnectionPool().length != 0) {
                    ResourceUtils.register(resource.getConnectorConnectionPool(0), mejb, update);
                    ResourceUtils.register(resource.getConnectorResource(0), mejb, update);
                }
            }
        } else {
            throw new Exception(bundle.getString("Err_RegResServerStopped"));
        }
    }

    public static void register(JdbcConnectionPool resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource, mejb);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getJdbcConnectionPool")) {
            ResourceUtils.createResource("createJdbcConnectionPool", params, mejb);
        }
    }

    public static void register(JdbcResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getJdbcResource")) {
            ResourceUtils.createResource("createJdbcResource", params, mejb);
        }
    }

    public static void register(PersistenceManagerFactoryResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getPersistenceManagerFactoryResource")) {
            ResourceUtils.createResource("createPersistenceManagerFactoryResource", params, mejb);
        }
    }

    public static void register(AdminObjectResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getAdminObjectResource")) {
            ResourceUtils.createResource("createAdminObjectResource", params, mejb);
        }
    }

    public static void register(ConnectorResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        Properties propsList = new Properties();
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getConnectorResource")) {
            ResourceUtils.createResource("createConnectorResource", params, mejb);
        }
    }

    public static void register(ConnectorConnectionPool resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getConnectorConnectionPool")) {
            ResourceUtils.createResource("createConnectorConnectionPool", params, mejb);
        }
    }

    public static void register(MailResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getMailResource")) {
            ResourceUtils.createResource("createMailResource", params, mejb);
        }
    }

    public static void register(JmsResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String operName = NbBundle.getMessage(ResourceUtils.class, (String)"CreateJMS");
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getJmsResource")) {
            ResourceUtils.createResource(operName, params, mejb);
        }
    }

    private static boolean isResourceUpdated(String resourceName, ServerInterface mejb, AttributeList attrList, Properties props, String operName) {
        boolean isResUpdated = false;
        try {
            ObjectName objName = new ObjectName("com.sun.appserv:type=resources,category=config");
            ObjectName[] resourceObjects = null;
            if (operName.equals("getPersistenceManagerFactoryResource") || operName.equals("getJmsResource")) {
                String[] signature = new String[]{"java.lang.String"};
                Object[] params = new Object[]{null};
                resourceObjects = (ObjectName[])mejb.invoke(objName, operName, params, signature);
            } else {
                resourceObjects = (ObjectName[])mejb.invoke(objName, operName, null, null);
            }
            if (resourceObjects != null) {
                ObjectName resOnServer = null;
                resOnServer = operName.equals("getJdbcConnectionPool") || operName.equals("getConnectorConnectionPool") ? ResourceUtils.getResourceDeployed(resourceObjects, resourceName, false) : ResourceUtils.getResourceDeployed(resourceObjects, resourceName, true);
                if (resOnServer != null) {
                    isResUpdated = true;
                    ResourceUtils.updateResourceAttributes(resOnServer, attrList, mejb);
                    ResourceUtils.updateResourceProperties(resOnServer, props, mejb);
                }
            }
        }
        catch (Exception ex) {
            String errorMsg = MessageFormat.format(bundle.getString("Err_ResourceUpdate"), resourceName);
            LOGGER.log(Level.SEVERE, errorMsg, ex);
        }
        return isResUpdated;
    }

    private static ObjectName getResourceDeployed(ObjectName[] resourceObjects, String resourceName, boolean useJndi) {
        for (int i = 0; i < resourceObjects.length; ++i) {
            ObjectName resObj = resourceObjects[i];
            String jndiName = null;
            jndiName = useJndi ? resObj.getKeyProperty("jndi-name") : resObj.getKeyProperty("name");
            if (!jndiName.equals(resourceName)) continue;
            return resObj;
        }
        return null;
    }

    public static void updateResourceAttributes(ObjectName objName, AttributeList attrList, ServerInterface mejb) throws Exception {
        try {
            Map attributeInfos = ResourceUtils.getResourceAttributeNames(objName, mejb);
            String[] attrNames = attributeInfos.keySet().toArray(new String[attributeInfos.size()]);
            AttributeList existAttrList = mejb.getAttributes(objName, attrNames);
            if (existAttrList != null) {
                for (int i = 0; i < existAttrList.size(); ++i) {
                    Attribute existAttr = (Attribute)existAttrList.get(i);
                    String existAttrName = existAttr.getName();
                    for (int j = 0; j < attrList.size(); ++j) {
                        Attribute resAttr = (Attribute)attrList.get(j);
                        String resAttrName = resAttr.getName();
                        if (!existAttrName.equals(resAttrName)) continue;
                        if (resAttr.getValue() == null && existAttr.getValue() != null) {
                            mejb.setAttribute(objName, resAttr);
                            continue;
                        }
                        if (existAttr.getValue() == null) {
                            if (resAttr.getValue() == null || resAttr.getValue().toString().equals("")) continue;
                            mejb.setAttribute(objName, resAttr);
                            continue;
                        }
                        if (resAttr.getValue().toString().equals(existAttr.getValue().toString())) continue;
                        mejb.setAttribute(objName, resAttr);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getLocalizedMessage(), ex);
        }
    }

    public static void updateResourceProperties(ObjectName objName, Properties props, ServerInterface mejb) throws Exception {
        try {
            String[] signature = new String[]{"javax.management.Attribute"};
            Object[] params = null;
            AttributeList attrList = (AttributeList)mejb.invoke(objName, "getProperties", null, null);
            for (int i = 0; i < attrList.size(); ++i) {
                Attribute oldAttr = (Attribute)attrList.get(i);
                String oldAttrName = oldAttr.getName();
                if (props.containsKey(oldAttrName)) {
                    if (oldAttr.getValue() != null) {
                        String oldAttrValue = oldAttr.getValue().toString();
                        if (props.getProperty(oldAttrName).equals(oldAttrValue)) continue;
                        Attribute attr = new Attribute(oldAttrName, props.getProperty(oldAttrName));
                        params = new Object[]{attr};
                        mejb.invoke(objName, "setProperty", params, signature);
                        continue;
                    }
                    if (props.getProperty(oldAttrName) == null) continue;
                    Attribute attr = new Attribute(oldAttrName, props.getProperty(oldAttrName));
                    params = new Object[]{attr};
                    mejb.invoke(objName, "setProperty", params, signature);
                    continue;
                }
                Attribute removeAttr = new Attribute(oldAttrName, null);
                params = new Object[]{removeAttr};
                mejb.invoke(objName, "setProperty", params, signature);
            }
            ResourceUtils.addNewExtraProperties(objName, props, attrList, mejb);
        }
        catch (Exception ex) {
            throw new Exception(ex.getLocalizedMessage(), ex);
        }
    }

    public static Map getResourceAttributeNames(ObjectName objName, ServerInterface mejb) throws Exception {
        try {
            HashMap<String, MBeanAttributeInfo> attributeInfos = new HashMap<String, MBeanAttributeInfo>();
            MBeanInfo info = mejb.getMBeanInfo(objName);
            if (info != null) {
                MBeanAttributeInfo[] attrs = info.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    if (attrs[i] == null) continue;
                    attributeInfos.put(attrs[i].getName(), attrs[i]);
                }
            }
            return attributeInfos;
        }
        catch (Exception ex) {
            throw new Exception(ex.getLocalizedMessage(), ex);
        }
    }

    private static void addNewExtraProperties(ObjectName objName, Properties props, AttributeList attrList, ServerInterface mejb) throws Exception {
        try {
            String[] signature = new String[]{"javax.management.Attribute"};
            Object[] params = null;
            if (props.size() > attrList.size()) {
                Enumeration<?> listProps = props.propertyNames();
                while (listProps.hasMoreElements()) {
                    String propName = listProps.nextElement().toString();
                    if (attrList.contains(propName)) continue;
                    Attribute attr = new Attribute(propName, props.getProperty(propName));
                    params = new Object[]{attr};
                    mejb.invoke(objName, "setProperty", params, signature);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getLocalizedMessage(), ex);
        }
    }

    public static void createResource(String operName, Object[] params, ServerInterface mejb) throws Exception {
        try {
            ObjectName objName = new ObjectName("com.sun.appserv:type=resources,category=config");
            String[] signature = new String[]{"javax.management.AttributeList", "java.util.Properties", "java.lang.String"};
            mejb.invoke(objName, operName, params, signature);
        }
        catch (Exception ex) {
            throw new Exception(ex.getLocalizedMessage(), ex);
        }
    }

    public static AttributeList getResourceAttributes(JdbcConnectionPool connPool, ServerInterface mejb) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("name", connPool.getName()));
        attrs.add(new Attribute("datasource-classname", connPool.getDatasourceClassname()));
        attrs.add(new Attribute("res-type", connPool.getResType()));
        attrs.add(new Attribute("steady-pool-size", connPool.getSteadyPoolSize()));
        attrs.add(new Attribute("max-pool-size", connPool.getMaxPoolSize()));
        attrs.add(new Attribute("max-wait-time-in-millis", connPool.getMaxWaitTimeInMillis()));
        attrs.add(new Attribute("pool-resize-quantity", connPool.getPoolResizeQuantity()));
        attrs.add(new Attribute("idle-timeout-in-seconds", connPool.getIdleTimeoutInSeconds()));
        String isolation = connPool.getTransactionIsolationLevel();
        String defaultChoice = ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/editors/Bundle").getString("LBL_driver_default");
        if (isolation != null && (isolation.length() == 0 || isolation.equals(defaultChoice))) {
            isolation = null;
        }
        attrs.add(new Attribute("transaction-isolation-level", isolation));
        attrs.add(new Attribute("is-isolation-level-guaranteed", connPool.getIsIsolationLevelGuaranteed()));
        attrs.add(new Attribute("is-connection-validation-required", connPool.getIsConnectionValidationRequired()));
        attrs.add(new Attribute("connection-validation-method", connPool.getConnectionValidationMethod()));
        attrs.add(new Attribute("validation-table-name", connPool.getValidationTableName()));
        attrs.add(new Attribute("fail-all-connections", connPool.getFailAllConnections()));
        attrs.add(new Attribute("description", connPool.getDescription()));
        if (ResourceUtils.is90Server(mejb)) {
            attrs.add(new Attribute("non-transactional-connections", connPool.getNonTransactionalConnections()));
            attrs.add(new Attribute("allow-non-component-callers", connPool.getAllowNonComponentCallers()));
        }
        return attrs;
    }

    public static AttributeList getResourceAttributes(JdbcResource jdbcResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi-name", jdbcResource.getJndiName()));
        attrs.add(new Attribute("pool-name", jdbcResource.getPoolName()));
        attrs.add(new Attribute("object-type", jdbcResource.getObjectType()));
        attrs.add(new Attribute("enabled", jdbcResource.getEnabled()));
        attrs.add(new Attribute("description", jdbcResource.getDescription()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(PersistenceManagerFactoryResource pmResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi-name", pmResource.getJndiName()));
        attrs.add(new Attribute("factory-class", pmResource.getFactoryClass()));
        attrs.add(new Attribute("jdbc-resource-jndi-name", pmResource.getJdbcResourceJndiName()));
        attrs.add(new Attribute("enabled", pmResource.getEnabled()));
        attrs.add(new Attribute("description", pmResource.getDescription()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(AdminObjectResource aoResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi-name", aoResource.getJndiName()));
        attrs.add(new Attribute("description", aoResource.getDescription()));
        attrs.add(new Attribute("enabled", aoResource.getEnabled()));
        attrs.add(new Attribute("res-type", aoResource.getResType()));
        attrs.add(new Attribute("res-adapter", aoResource.getResAdapter()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(ConnectorResource connResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi-name", connResource.getJndiName()));
        attrs.add(new Attribute("pool-name", connResource.getPoolName()));
        attrs.add(new Attribute("description", connResource.getDescription()));
        attrs.add(new Attribute("enabled", connResource.getEnabled()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(ConnectorConnectionPool connPoolResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("name", connPoolResource.getName()));
        attrs.add(new Attribute("resource-adapter-name", connPoolResource.getResourceAdapterName()));
        attrs.add(new Attribute("connection-definition-name", connPoolResource.getConnectionDefinitionName()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(MailResource mailResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi-name", mailResource.getJndiName()));
        attrs.add(new Attribute("store-protocol", mailResource.getStoreProtocol()));
        attrs.add(new Attribute("store-protocol-class", mailResource.getStoreProtocolClass()));
        attrs.add(new Attribute("transport-protocol", mailResource.getTransportProtocol()));
        attrs.add(new Attribute("transport-protocol-class", mailResource.getTransportProtocolClass()));
        attrs.add(new Attribute("host", mailResource.getHost()));
        attrs.add(new Attribute("user", mailResource.getUser()));
        attrs.add(new Attribute("from", mailResource.getFrom()));
        attrs.add(new Attribute("debug", mailResource.getDebug()));
        attrs.add(new Attribute("enabled", mailResource.getEnabled()));
        attrs.add(new Attribute("description", mailResource.getDescription()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(JmsResource jmsResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi_name", jmsResource.getJndiName()));
        attrs.add(new Attribute("res-type", jmsResource.getResType()));
        attrs.add(new Attribute("enabled", jmsResource.getEnabled()));
        attrs.add(new Attribute("description", jmsResource.getDescription()));
        return attrs;
    }

    private static Properties getProperties(PropertyElement[] props) throws Exception {
        Properties propList = new Properties();
        for (int i = 0; i < props.length; ++i) {
            String name = props[i].getName();
            String value = props[i].getValue();
            if (value == null || value.trim().length() == 0) continue;
            propList.put(name, value);
        }
        return propList;
    }

    public static void saveConnPoolDatatoXml(ResourceConfigData data, String baseName) {
        Resources res = ResourceUtils.getServerResourcesGraph(data.getTargetFileObject(), baseName.contains("glassfish-resources") ? "1.50" : "1.30");
        ResourceUtils.saveConnPoolDatatoXml(data, res, baseName);
    }

    public static void saveConnPoolDatatoXml(ResourceConfigData data, Resources res, String baseName) {
        try {
            JdbcConnectionPool connPool = res.newJdbcConnectionPool();
            String[] keys = data.getFieldNames();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (key.equals("properties")) {
                    Vector props = data.getProperties();
                    for (int j = 0; j < props.size(); ++j) {
                        NameValuePair pair = (NameValuePair)props.elementAt(j);
                        PropertyElement prop = connPool.newPropertyElement();
                        prop = ResourceUtils.populatePropertyElement(prop, pair);
                        connPool.addPropertyElement(prop);
                    }
                    continue;
                }
                String value = data.getString(key);
                if (key.equals("name")) {
                    connPool.setName(value);
                    data.setTargetFile(value);
                    continue;
                }
                if (key.equals("datasource-classname")) {
                    connPool.setDatasourceClassname(value);
                    continue;
                }
                if (key.equals("res-type")) {
                    connPool.setResType(value);
                    continue;
                }
                if (key.equals("steady-pool-size")) {
                    connPool.setSteadyPoolSize(value);
                    continue;
                }
                if (key.equals("max-pool-size")) {
                    connPool.setMaxPoolSize(value);
                    continue;
                }
                if (key.equals("max-wait-time-in-millis")) {
                    connPool.setMaxWaitTimeInMillis(value);
                    continue;
                }
                if (key.equals("pool-resize-quantity")) {
                    connPool.setPoolResizeQuantity(value);
                    continue;
                }
                if (key.equals("idle-timeout-in-seconds")) {
                    connPool.setIdleTimeoutInSeconds(value);
                    continue;
                }
                if (key.equals("transaction-isolation-level")) {
                    String defaultChoice = ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/editors/Bundle").getString("LBL_driver_default");
                    if (value.equals(defaultChoice)) {
                        value = null;
                    }
                    connPool.setTransactionIsolationLevel(value);
                    continue;
                }
                if (key.equals("is-isolation-level-guaranteed")) {
                    connPool.setIsIsolationLevelGuaranteed(value);
                    continue;
                }
                if (key.equals("is-connection-validation-required")) {
                    connPool.setIsConnectionValidationRequired(value);
                    continue;
                }
                if (key.equals("connection-validation-method")) {
                    connPool.setConnectionValidationMethod(value);
                    continue;
                }
                if (key.equals("validation-table-name")) {
                    connPool.setValidationTableName(value);
                    continue;
                }
                if (key.equals("fail-all-connections")) {
                    connPool.setFailAllConnections(value);
                    continue;
                }
                if (key.equals("description")) {
                    connPool.setDescription(value);
                    continue;
                }
                if (key.equals("non-transactional-connections")) {
                    connPool.setNonTransactionalConnections(value);
                    continue;
                }
                if (!key.equals("allow-non-component-callers")) continue;
                connPool.setAllowNonComponentCallers(value);
            }
            res.addJdbcConnectionPool(connPool);
            ResourceUtils.createFile(data, res, baseName);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Unable to saveConnPoolDatatoXml", ex);
        }
    }

    public static File createPathForFile(File resourceFile) {
        File resourceFileDir = resourceFile.getParentFile();
        if (resourceFileDir != null && !resourceFileDir.exists()) {
            resourceFileDir.mkdirs();
        }
        return resourceFileDir;
    }

    public static J2eeModuleProvider getJavaEEModuleProvider(FileObject targetFolder) {
        Project holdingProj = FileOwnerQuery.getOwner((FileObject)targetFolder);
        return holdingProj != null ? (J2eeModuleProvider)holdingProj.getLookup().lookup(J2eeModuleProvider.class) : null;
    }

    public static GlassFishServer getGlassFishServer(J2eeModuleProvider provider) {
        J2eePlatform platform;
        ServerInstance serverInstance = provider != null && provider.getServerInstanceID() != null ? Deployment.getDefault().getServerInstance(provider.getServerInstanceID()) : null;
        try {
            platform = serverInstance != null ? serverInstance.getJ2eePlatform() : null;
        }
        catch (InstanceRemovedException ex) {
            platform = null;
            LOGGER.log(Level.INFO, "Could not get Java EE platform", ex);
        }
        return platform != null ? (GlassFishServer)platform.getLookup().lookup(GlassFishServer.class) : null;
    }

    public static final String getJavaEEModuleConfigDir(J2eeModule module) {
        J2eeModule.Type type = module.getType();
        if (type.equals(J2eeModule.Type.WAR)) {
            return WEB_INF;
        }
        return META_INF;
    }

    public static final String getResourcesFileName(GlassFishVersion version) {
        return GlassFishVersion.ge((Enum)version, (Enum)GlassFishVersion.GF_3_1) ? RESOURCE_FILES[0] : RESOURCE_FILES[1];
    }

    public static final String getResourcesFileModulePath(J2eeModule module, GlassFishVersion version) {
        return OsUtils.joinPaths((String)ResourceUtils.getJavaEEModuleConfigDir(module), (String)ResourceUtils.getResourcesFileName(version));
    }

    public static void saveJDBCResourceDatatoXml(ResourceConfigData dsData, ResourceConfigData cpData, String baseName) {
        try {
            Resources res = ResourceUtils.getServerResourcesGraph(dsData.getTargetFileObject(), baseName.contains("glassfish-resources") ? "1.50" : "1.30");
            JdbcResource datasource = res.newJdbcResource();
            String[] keys = dsData.getFieldNames();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (key.equals("properties")) {
                    Vector props = dsData.getProperties();
                    for (int j = 0; j < props.size(); ++j) {
                        NameValuePair pair = (NameValuePair)props.elementAt(j);
                        PropertyElement prop = datasource.newPropertyElement();
                        prop = ResourceUtils.populatePropertyElement(prop, pair);
                        datasource.addPropertyElement(prop);
                    }
                    continue;
                }
                String value = dsData.getString(key);
                if (key.equals("jndi-name")) {
                    datasource.setJndiName(value);
                    dsData.setTargetFile(value);
                    continue;
                }
                if (key.equals("pool-name")) {
                    datasource.setPoolName(value);
                    continue;
                }
                if (key.equals("object-type")) {
                    datasource.setObjectType(value);
                    continue;
                }
                if (key.equals("enabled")) {
                    datasource.setEnabled(value);
                    continue;
                }
                if (!key.equals("description")) continue;
                datasource.setDescription(value);
            }
            res.addJdbcResource(datasource);
            if (cpData != null) {
                ResourceUtils.saveConnPoolDatatoXml(cpData, res, baseName);
            }
            ResourceUtils.createFile(dsData, res, baseName);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Unable to saveJDBCResourceDatatoXml", ex);
        }
    }

    public static void savePMFResourceDatatoXml(ResourceConfigData pmfData, ResourceConfigData dsData, ResourceConfigData cpData, String baseName) {
        try {
            Resources res = ResourceUtils.getServerResourcesGraph(pmfData.getTargetFileObject(), baseName.contains("glassfish-resources") ? "1.50" : "1.30");
            PersistenceManagerFactoryResource pmfresource = res.newPersistenceManagerFactoryResource();
            String[] keys = pmfData.getFieldNames();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (key.equals("properties")) {
                    Vector props = pmfData.getProperties();
                    for (int j = 0; j < props.size(); ++j) {
                        NameValuePair pair = (NameValuePair)props.elementAt(j);
                        PropertyElement prop = pmfresource.newPropertyElement();
                        prop = ResourceUtils.populatePropertyElement(prop, pair);
                        pmfresource.addPropertyElement(prop);
                    }
                    continue;
                }
                String value = pmfData.getString(key);
                if (key.equals("jndi-name")) {
                    pmfresource.setJndiName(value);
                    pmfData.setTargetFile(value);
                    continue;
                }
                if (key.equals("factory-class")) {
                    pmfresource.setFactoryClass(value);
                    continue;
                }
                if (key.equals("jdbc-resource-jndi-name")) {
                    pmfresource.setJdbcResourceJndiName(value);
                    continue;
                }
                if (key.equals("enabled")) {
                    pmfresource.setEnabled(value);
                    continue;
                }
                if (!key.equals("description")) continue;
                pmfresource.setDescription(value);
            }
            res.addPersistenceManagerFactoryResource(pmfresource);
            ResourceUtils.createFile(pmfData, res, baseName);
            if (dsData != null) {
                ResourceUtils.saveJDBCResourceDatatoXml(dsData, cpData, baseName);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Unable to savePMFResourceDatatoXml", ex);
        }
    }

    public static void saveJMSResourceDatatoXml(ResourceConfigData jmsData, String baseName) {
        try {
            Resources res = ResourceUtils.getServerResourcesGraph(jmsData.getTargetFileObject(), baseName.contains("glassfish-resources") ? "1.50" : "1.30");
            String type = jmsData.getString("res-type");
            if (type.equals("javax.jms.Queue") || type.equals("javax.jms.Topic")) {
                AdminObjectResource aoresource = res.newAdminObjectResource();
                aoresource.setDescription(jmsData.getString("description"));
                aoresource.setEnabled(jmsData.getString("enabled"));
                aoresource.setJndiName(jmsData.getString("jndi-name"));
                aoresource.setResType(jmsData.getString("res-type"));
                aoresource.setResAdapter("jmsra");
                Vector props = jmsData.getProperties();
                for (int j = 0; j < props.size(); ++j) {
                    NameValuePair pair = (NameValuePair)props.elementAt(j);
                    PropertyElement prop = aoresource.newPropertyElement();
                    prop = ResourceUtils.populatePropertyElement(prop, pair);
                    aoresource.addPropertyElement(prop);
                }
                res.addAdminObjectResource(aoresource);
            } else {
                ConnectorResource connresource = res.newConnectorResource();
                connresource.setDescription(jmsData.getString("description"));
                connresource.setEnabled(jmsData.getString("enabled"));
                connresource.setJndiName(jmsData.getString("jndi-name"));
                connresource.setPoolName(jmsData.getString("jndi-name") + "-Connection-Pool");
                ConnectorConnectionPool connpoolresource = res.newConnectorConnectionPool();
                connpoolresource.setName(jmsData.getString("jndi-name") + "-Connection-Pool");
                connpoolresource.setConnectionDefinitionName(jmsData.getString("res-type"));
                connpoolresource.setResourceAdapterName("jmsra");
                Vector props = jmsData.getProperties();
                for (int j = 0; j < props.size(); ++j) {
                    NameValuePair pair = (NameValuePair)props.elementAt(j);
                    PropertyElement prop = connpoolresource.newPropertyElement();
                    prop = ResourceUtils.populatePropertyElement(prop, pair);
                    connpoolresource.addPropertyElement(prop);
                }
                res.addConnectorResource(connresource);
                res.addConnectorConnectionPool(connpoolresource);
            }
            ResourceUtils.createFile(jmsData, res, baseName);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Unable to saveJMSResourceDatatoXml", ex);
        }
    }

    public static void saveMailResourceDatatoXml(ResourceConfigData data, String baseName) {
        try {
            Vector vec = data.getProperties();
            Resources res = ResourceUtils.getServerResourcesGraph(data.getTargetFileObject(), baseName.contains("glassfish-resources") ? "1.50" : "1.30");
            MailResource mlresource = res.newMailResource();
            String[] keys = data.getFieldNames();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (key.equals("properties")) {
                    Vector props = data.getProperties();
                    for (int j = 0; j < props.size(); ++j) {
                        NameValuePair pair = (NameValuePair)props.elementAt(j);
                        PropertyElement prop = mlresource.newPropertyElement();
                        prop = ResourceUtils.populatePropertyElement(prop, pair);
                        mlresource.addPropertyElement(prop);
                    }
                    continue;
                }
                String value = data.getString(key);
                if (key.equals("jndi-name")) {
                    mlresource.setJndiName(value);
                    data.setTargetFile(value);
                    continue;
                }
                if (key.equals("store-protocol")) {
                    mlresource.setStoreProtocol(value);
                    continue;
                }
                if (key.equals("store-protocol-class")) {
                    mlresource.setStoreProtocolClass(value);
                    continue;
                }
                if (key.equals("transport-protocol")) {
                    mlresource.setTransportProtocol(value);
                    continue;
                }
                if (key.equals("transport-protocol-class")) {
                    mlresource.setTransportProtocolClass(value);
                    continue;
                }
                if (key.equals("host")) {
                    mlresource.setHost(value);
                    continue;
                }
                if (key.equals("user")) {
                    mlresource.setUser(value);
                    continue;
                }
                if (key.equals("from")) {
                    mlresource.setFrom(value);
                    continue;
                }
                if (key.equals("debug")) {
                    mlresource.setDebug(value);
                    continue;
                }
                if (!key.equals("description")) continue;
                mlresource.setDescription(value);
            }
            res.addMailResource(mlresource);
            ResourceUtils.createFile(data, res, baseName);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Unable to saveMailResourceDatatoXml", ex);
        }
    }

    public static String createUniqueFileName(String in_targetName, FileObject fo, String defName) {
        List resources;
        String targetName = in_targetName;
        if (targetName == null || targetName.length() == 0) {
            targetName = defName;
        }
        if ((resources = ResourceUtils.getProjectResources(fo, defName)).contains(targetName)) {
            targetName = ResourceUtils.getUniqueResourceName(targetName, resources);
        }
        return targetName;
    }

    public static List getRegisteredConnectionPools(ResourceConfigData data) {
        List<String> connPools = new ArrayList();
        try {
            String keyProp = "name";
            InstanceProperties instanceProperties = ResourceUtils.getTargetServer(data.getTargetFileObject());
            if (instanceProperties != null) {
                connPools = ResourceUtils.getResourceNames(instanceProperties, "getJdbcConnectionPool", keyProp);
            }
            connPools.removeAll(Arrays.asList(sysConnpools));
            FileObject targetFolder = data.getTargetFileObject();
            List projectCP = ResourceUtils.getProjectResources(targetFolder, "connectionPool");
            for (int i = 0; i < projectCP.size(); ++i) {
                String localCP = projectCP.get(i).toString();
                if (connPools.contains(localCP)) continue;
                connPools.add(localCP);
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            LOGGER.log(Level.SEVERE, "getRegisteredConnectionPools failed", ncdfe);
        }
        return connPools;
    }

    public static List getRegisteredJdbcResources(ResourceConfigData data) {
        List<String> dataSources = new ArrayList();
        try {
            String keyProp = "jndi-name";
            InstanceProperties instanceProperties = ResourceUtils.getTargetServer(data.getTargetFileObject());
            if (instanceProperties != null) {
                dataSources = ResourceUtils.getResourceNames(instanceProperties, "getJdbcResource", keyProp);
            }
            dataSources.removeAll(Arrays.asList(sysDatasources));
            FileObject targetFolder = data.getTargetFileObject();
            List projectDS = ResourceUtils.getProjectResources(targetFolder, "jdbc/myDatasource");
            for (int i = 0; i < projectDS.size(); ++i) {
                String localDS = projectDS.get(i).toString();
                if (dataSources.contains(localDS)) continue;
                dataSources.add(localDS);
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            LOGGER.log(Level.SEVERE, "getRegisteredJdbcResources failed", ncdfe);
        }
        return dataSources;
    }

    private static List getResourceNames(InstanceProperties instProps, String query, String keyProperty) {
        List<Object> retVal = new ArrayList();
        Object dm = null;
        LOGGER.log(Level.INFO, "investigate", new Exception());
        if (dm instanceof SunDeploymentManagerInterface) {
            SunDeploymentManagerInterface eightDM = dm;
            if (eightDM.isRunning()) {
                retVal = ResourceUtils.getResourceNames(eightDM, query, keyProperty);
            } else if (eightDM.isLocal()) {
                if (query.equals("getJdbcResource")) {
                    HashMap dsources = eightDM.getSunDatasourcesFromXml();
                    retVal = new ArrayList(dsources.keySet());
                } else if (query.equals("getJdbcConnectionPool")) {
                    HashMap pools = eightDM.getConnPoolsFromXml();
                    retVal = new ArrayList(pools.keySet());
                }
            }
        }
        return retVal;
    }

    private static List getResourceNames(SunDeploymentManagerInterface eightDM, String query, String keyProperty) {
        ArrayList<String> resList = new ArrayList<String>();
        try {
            ServerInterface mejb = eightDM.getManagement();
            ObjectName objName = new ObjectName("com.sun.appserv:type=resources,category=config");
            ObjectName[] beans = (ObjectName[])mejb.invoke(objName, query, null, null);
            for (int i = 0; i < beans.length; ++i) {
                String resName = beans[i].getKeyProperty(keyProperty);
                resList.add(resName);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "getResourceNames failed", ex);
        }
        return resList;
    }

    private static List getProjectResources(FileObject targetFolder, String resourceType) {
        File resource;
        List projectResources = new ArrayList();
        if (targetFolder != null && (resource = ResourceUtils.getServerResourcesFile(targetFolder, true)) != null && resource.exists()) {
            projectResources = resourceType.equals("connectionPool") ? ResourceUtils.getConnectionPools(resource, projectResources) : (resourceType.equals("jdbc/myDatasource") ? ResourceUtils.getDataSources(resource, projectResources) : (resourceType.equals("mail/mySession") ? ResourceUtils.getMailResources(resource, projectResources) : (resourceType.equals("jms/myQueue") ? ResourceUtils.getJMSResources(resource, projectResources) : (resourceType.equals("persistence") ? ResourceUtils.getPersistenceResources(resource, projectResources) : ResourceUtils.getAllResourceNames(resource, projectResources)))));
        }
        return projectResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getConnectionPools(File primaryFile, List projectCP) {
        block6: {
            try {
                if (primaryFile.isDirectory()) break block6;
                try (FileInputStream in = new FileInputStream(primaryFile);){
                    Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                    JdbcConnectionPool[] pools = resources.getJdbcConnectionPool();
                    for (int i = 0; i < pools.length; ++i) {
                        projectCP.add(pools[i].getName());
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "getConnectionPools failed", ex);
            }
        }
        return projectCP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getDataSources(File primaryFile, List projectDS) {
        block6: {
            try {
                if (primaryFile.isDirectory()) break block6;
                try (FileInputStream in = new FileInputStream(primaryFile);){
                    Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                    JdbcResource[] dataSources = resources.getJdbcResource();
                    for (int i = 0; i < dataSources.length; ++i) {
                        projectDS.add(dataSources[i].getJndiName());
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "filterDataSources failed", ex);
            }
        }
        return projectDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getMailResources(File primaryFile, List projectRes) {
        block6: {
            try {
                if (primaryFile.isDirectory()) break block6;
                try (FileInputStream in = new FileInputStream(primaryFile);){
                    Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                    MailResource[] res = resources.getMailResource();
                    for (int i = 0; i < res.length; ++i) {
                        projectRes.add(res[i].getJndiName());
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "getMailResources failed", ex);
            }
        }
        return projectRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getJMSResources(File primaryFile, List projectRes) {
        block7: {
            try {
                if (primaryFile.isDirectory()) break block7;
                try (FileInputStream in = new FileInputStream(primaryFile);){
                    Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                    AdminObjectResource[] aoRes = resources.getAdminObjectResource();
                    for (int i = 0; i < aoRes.length; ++i) {
                        projectRes.add(aoRes[i].getJndiName());
                    }
                    ConnectorResource[] connRes = resources.getConnectorResource();
                    for (int i = 0; i < connRes.length; ++i) {
                        projectRes.add(connRes[i].getJndiName());
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "getJMSResources failed", ex);
            }
        }
        return projectRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getPersistenceResources(File primaryFile, List projectRes) {
        block6: {
            try {
                if (primaryFile.isDirectory()) break block6;
                try (FileInputStream in = new FileInputStream(primaryFile);){
                    Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                    PersistenceManagerFactoryResource[] pmfRes = resources.getPersistenceManagerFactoryResource();
                    for (int i = 0; i < pmfRes.length; ++i) {
                        projectRes.add(pmfRes[i].getJndiName());
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "getPersistenceManagerFactoryResource failed", ex);
            }
        }
        return projectRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllResourceNames(File primaryFile, List projectRes) {
        block10: {
            try {
                if (primaryFile.isDirectory()) break block10;
                try (FileInputStream in = new FileInputStream(primaryFile);){
                    Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                    JdbcConnectionPool[] pools = resources.getJdbcConnectionPool();
                    for (int i = 0; i < pools.length; ++i) {
                        projectRes.add(pools[i].getName());
                    }
                    JdbcResource[] dataSources = resources.getJdbcResource();
                    for (int i = 0; i < dataSources.length; ++i) {
                        projectRes.add(dataSources[i].getJndiName());
                    }
                    MailResource[] mailRes = resources.getMailResource();
                    for (int i = 0; i < mailRes.length; ++i) {
                        projectRes.add(mailRes[i].getJndiName());
                    }
                    AdminObjectResource[] aoRes = resources.getAdminObjectResource();
                    for (int i = 0; i < aoRes.length; ++i) {
                        projectRes.add(aoRes[i].getJndiName());
                    }
                    ConnectorResource[] connRes = resources.getConnectorResource();
                    for (int i = 0; i < connRes.length; ++i) {
                        projectRes.add(connRes[i].getJndiName());
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "getAllResourceNames failed", ex);
            }
        }
        return projectRes;
    }

    public static FileObject setUpExists(FileObject targetFolder) {
        FileObject pkgLocation = ResourceUtils.getResourceDirectory(targetFolder);
        if (pkgLocation == null) {
            return targetFolder;
        }
        return pkgLocation;
    }

    private static Resources getResourceGraph(String version) {
        return DDProvider.getDefault().getResourcesGraph(version);
    }

    private static PropertyElement populatePropertyElement(PropertyElement prop, NameValuePair pair) {
        prop.setName(pair.getParamName());
        prop.setValue(pair.getParamValue());
        if ("()".equals(prop.getValue())) {
            prop.setValue("");
        }
        return prop;
    }

    public static boolean isLegalFilename(String filename) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            if (filename.indexOf(ILLEGAL_FILENAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFriendlyFilename(String filename) {
        if (filename.indexOf(32) >= 0 || filename.indexOf(46) >= 0) {
            return false;
        }
        return ResourceUtils.isLegalFilename(filename);
    }

    public static String makeLegalFilename(String filename) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            filename = filename.replace(ILLEGAL_FILENAME_CHARS[i], '_');
        }
        return filename;
    }

    public static boolean isLegalResourceName(String filename) {
        for (int i = 0; i < ILLEGAL_RESOURCE_NAME_CHARS.length; ++i) {
            if (filename.indexOf(ILLEGAL_RESOURCE_NAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    public static FileObject getResourceDirectory(FileObject fo) {
        File resourceLoc;
        J2eeModuleProvider provider;
        Project holdingProj = FileOwnerQuery.getOwner((FileObject)fo);
        FileObject resourceDir = null;
        if (holdingProj != null && (provider = (J2eeModuleProvider)holdingProj.getLookup().lookup(J2eeModuleProvider.class)) != null && (resourceLoc = provider.getJ2eeModule().getResourceDirectory()) != null) {
            if (resourceLoc.exists()) {
                resourceDir = FileUtil.toFileObject((File)resourceLoc);
            } else {
                try {
                    resourceDir = FileUtil.createFolder((File)resourceLoc);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "getResourceDirectory failed", ex);
                }
            }
        }
        return resourceDir;
    }

    private static DeploymentManager getDeploymentManager(J2eeModuleProvider provider) {
        DeploymentManager dm = null;
        InstanceProperties ip = provider.getInstanceProperties();
        if (ip != null) {
            LOGGER.log(Level.INFO, "investigate", new Exception());
        }
        return dm;
    }

    public static void createSampleDataSource(J2eeModuleProvider provider) {
        DeploymentManager dm = ResourceUtils.getDeploymentManager(provider);
        if (dm != null && dm instanceof SunDeploymentManagerInterface) {
            SunDeploymentManagerInterface eightDM = (SunDeploymentManagerInterface)dm;
            try {
                ObjectName configObjName = new ObjectName("com.sun.appserv:type=resources,category=config");
                if (eightDM.isRunning()) {
                    ResourceUtils.updateSampleDatasource(eightDM, configObjName);
                } else {
                    eightDM.createSampleDataSourceinDomain();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "createSampleDataSource failed", ex);
            }
        }
    }

    public static HashSet getServerDataSources(DeploymentManager dm) {
        HashSet datasources = new HashSet();
        try {
            ObjectName configObjName = new ObjectName("com.sun.appserv:type=resources,category=config");
            SunDeploymentManagerInterface eightDM = (SunDeploymentManagerInterface)dm;
            ServerInterface mejb = eightDM.getManagement();
            List<String> systemDS = Arrays.asList(sysDatasources);
            if (eightDM.isRunning()) {
                ResourceUtils.updateSampleDatasource(eightDM, configObjName);
                ObjectName[] resourceObjects = (ObjectName[])mejb.invoke(configObjName, "getJdbcResource", null, null);
                for (int i = 0; i < resourceObjects.length; ++i) {
                    String url;
                    String poolName;
                    HashMap poolValues;
                    ObjectName objName = resourceObjects[i];
                    String dsJndiName = (String)mejb.getAttribute(objName, "jndi-name");
                    if (systemDS.contains(dsJndiName) || (poolValues = ResourceUtils.fillInPoolValues(eightDM, configObjName, poolName = (String)mejb.getAttribute(objName, "pool-name"))).isEmpty() || (url = (String)poolValues.get("URL")) == null || url.equals("")) continue;
                    String username = (String)poolValues.get("User");
                    String password = (String)poolValues.get("Password");
                    String driverClassName = (String)poolValues.get("driverClass");
                    SunDatasource ds = new SunDatasource(dsJndiName, url, username, password, driverClassName);
                    datasources.add(ds);
                }
            } else if (eightDM.isLocal()) {
                datasources = ResourceUtils.formatXmlSunDatasources(eightDM.getSunDatasourcesFromXml());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "getServerDataSources failed", ex);
        }
        return datasources;
    }

    private static void updateSampleDatasource(SunDeploymentManagerInterface eightDM, ObjectName configObjName) {
        try {
            if (!eightDM.isLocal()) {
                return;
            }
            List datasources = ResourceUtils.getResourceNames(eightDM, "getJdbcResource", "jndi-name");
            if (!datasources.contains(SAMPLE_DATASOURCE)) {
                ServerInterface mejb = eightDM.getManagement();
                List pools = ResourceUtils.getResourceNames(eightDM, "getJdbcConnectionPool", "name");
                if (!pools.contains(SAMPLE_CONNPOOL)) {
                    AttributeList poolAttrs = new AttributeList();
                    Attribute attr = new Attribute("name", SAMPLE_CONNPOOL);
                    poolAttrs.add(attr);
                    attr = new Attribute("datasource-classname", "org.apache.derby.jdbc.ClientDataSource");
                    poolAttrs.add(attr);
                    attr = new Attribute("res-type", "javax.sql.DataSource");
                    poolAttrs.add(attr);
                    Properties propsList = new Properties();
                    propsList.put("User", "app");
                    propsList.put("Password", "app");
                    propsList.put("serverName", "localhost");
                    propsList.put("PortNumber", "1527");
                    propsList.put("DatabaseName", "sample");
                    propsList.put("URL", "jdbc:derby://localhost:1527/sample");
                    Object[] poolParams = new Object[]{poolAttrs, propsList, null};
                    ResourceUtils.createResource("createJdbcConnectionPool", poolParams, mejb);
                }
                AttributeList attrs = new AttributeList();
                attrs.add(new Attribute("jndi-name", SAMPLE_DATASOURCE));
                attrs.add(new Attribute("pool-name", SAMPLE_CONNPOOL));
                attrs.add(new Attribute("object-type", "user"));
                attrs.add(new Attribute("enabled", "true"));
                Object[] params = new Object[]{attrs, new Properties(), null};
                ResourceUtils.createResource("createJdbcResource", params, mejb);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "updateSampleDatasource failed", ex);
        }
    }

    public static HashMap fillInPoolValues(SunDeploymentManagerInterface eightDM, ObjectName configObjName, String poolName) throws Exception {
        HashMap<String, String> connPoolAttrs = new HashMap<String, String>();
        ServerInterface mejb = eightDM.getManagement();
        List connPools = ResourceUtils.getResourceNames(eightDM, "getJdbcConnectionPool", "name");
        if (connPools.contains(poolName)) {
            ObjectName connPoolObj = ResourceUtils.getConnectionPoolByName(mejb, configObjName, poolName);
            String dsClassName = (String)mejb.getAttribute(connPoolObj, "datasource-classname");
            String resType = (String)mejb.getAttribute(connPoolObj, "res-type");
            String url = "";
            String username = "";
            String password = "";
            String serverName = "";
            String portNo = "";
            String dbName = "";
            String sid = "";
            String driverClass = "";
            String informixServerName = "";
            String informixHostName = "";
            String derbyConnAttr = "";
            AttributeList attrList = (AttributeList)mejb.invoke(connPoolObj, "getProperties", null, null);
            HashMap attrs = ResourceUtils.getObjMap(attrList);
            Object[] keys = attrs.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String keyName = (String)keys[i];
                if (keyName.equalsIgnoreCase("databaseName")) {
                    if (dsClassName.indexOf("pointbase") != -1) {
                        url = ResourceUtils.getStringVal(attrs.get(keyName));
                        continue;
                    }
                    dbName = ResourceUtils.getStringVal(attrs.get(keyName));
                    continue;
                }
                if (keyName.equalsIgnoreCase("User")) {
                    username = ResourceUtils.getStringVal(attrs.get(keyName));
                    continue;
                }
                if (keyName.equalsIgnoreCase("Password")) {
                    password = ResourceUtils.getStringVal(attrs.get(keyName));
                    continue;
                }
                if (keyName.equalsIgnoreCase("URL")) {
                    url = ResourceUtils.getStringVal(attrs.get(keyName));
                    continue;
                }
                if (keyName.equalsIgnoreCase("serverName")) {
                    serverName = ResourceUtils.getStringVal(attrs.get(keyName));
                    continue;
                }
                if (keyName.equalsIgnoreCase("PortNumber")) {
                    portNo = ResourceUtils.getStringVal(attrs.get(keyName));
                    continue;
                }
                if (keyName.equalsIgnoreCase("SID")) {
                    sid = ResourceUtils.getStringVal(attrs.get(keyName));
                    continue;
                }
                if (keyName.equalsIgnoreCase("driverClass")) {
                    driverClass = ResourceUtils.getStringVal(attrs.get(keyName));
                    continue;
                }
                if (keyName.equalsIgnoreCase("InformixServer")) {
                    informixServerName = ResourceUtils.getStringVal(attrs.get(keyName));
                    continue;
                }
                if (keyName.equalsIgnoreCase("IfxIFXHOST")) {
                    informixHostName = ResourceUtils.getStringVal(attrs.get(keyName));
                    continue;
                }
                if (!keyName.equalsIgnoreCase("connectionAttributes")) continue;
                derbyConnAttr = ResourceUtils.getStringVal(attrs.get(keyName));
            }
            if (url == null || url.equals("")) {
                if (dsClassName.indexOf("derby") != -1) {
                    url = "jdbc:derby://";
                    if (serverName != null) {
                        url = url + serverName;
                        if (portNo != null && portNo.length() > 0) {
                            url = url + ":" + portNo;
                        }
                        url = url + "/" + dbName;
                        if (derbyConnAttr != null && !derbyConnAttr.equals("")) {
                            url = url + derbyConnAttr;
                        }
                    }
                } else {
                    String urlPrefix = DatabaseUtils.getUrlPrefix(dsClassName, resType);
                    String vName = ResourceConfigurator.getDatabaseVendorName(urlPrefix, null);
                    if (serverName != null) {
                        if (vName.equals("sybase2")) {
                            url = urlPrefix + serverName;
                        }
                        url = vName.equals("informix") ? urlPrefix + "//" + informixHostName : urlPrefix + "//" + serverName;
                        if (portNo != null && portNo.length() > 0) {
                            url = url + ":" + portNo;
                        }
                    }
                    if (vName.equals("sun_oracle") || vName.equals("datadirect_oracle")) {
                        url = url + ";SID=" + sid;
                    } else if (Arrays.asList(Reqd_DBName).contains(vName)) {
                        url = url + ";databaseName=" + dbName;
                    } else if (Arrays.asList(VendorsDBNameProp).contains(vName)) {
                        url = url + "/" + dbName;
                    }
                    if (vName.equals("informix")) {
                        url = url + ":INFORMIXSERVER=" + serverName;
                    } else if (vName.equals("datadirect_informix")) {
                        url = url + ";InformixServer=" + informixServerName;
                    }
                }
            }
            if (url != null && !url.equals("")) {
                if (!eightDM.isLocal() && url.indexOf("localhost") != -1) {
                    String hostName = eightDM.getHost();
                    url = url.replaceFirst("localhost", hostName);
                }
                DatabaseConnection databaseConnection = ResourceUtils.getDatabaseConnection(url);
                if (driverClass == null || driverClass.equals("")) {
                    if (databaseConnection != null) {
                        driverClass = databaseConnection.getDriverClass();
                    } else {
                        String drivername = DatabaseUtils.getDriverName(url);
                        if (drivername != null) {
                            driverClass = drivername;
                        }
                    }
                }
            }
            connPoolAttrs.put("User", username);
            connPoolAttrs.put("Password", password);
            connPoolAttrs.put("URL", url);
            connPoolAttrs.put("driverClass", driverClass);
        }
        return connPoolAttrs;
    }

    private static ObjectName getConnectionPoolByName(ServerInterface mejb, ObjectName configObjName, String poolName) throws Exception {
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{poolName};
        ObjectName connPoolObj = (ObjectName)mejb.invoke(configObjName, "getJdbcConnectionPoolByName", params, signature);
        return connPoolObj;
    }

    private static String getStringVal(Object val) {
        String value = null;
        if (val != null) {
            value = val.toString();
        }
        return value;
    }

    private static HashMap getObjMap(AttributeList attrList) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (int k = 0; k < attrList.size(); ++k) {
            Attribute currAttr = (Attribute)attrList.get(k);
            String pname = currAttr.getName();
            Object pObjvalue = currAttr.getValue();
            attrs.put(pname, pObjvalue);
        }
        return attrs;
    }

    public static String revertToResName(String filename) {
        if (filename.indexOf("jdbc_") != -1) {
            filename = filename.replaceFirst("jdbc_", "jdbc/");
        }
        if (filename.indexOf("mail_") != -1) {
            filename = filename.replaceFirst("mail_", "mail/");
        }
        if (filename.indexOf("jms_") != -1) {
            filename = filename.replaceFirst("jms_", "jms/");
        }
        return filename;
    }

    public static boolean isUniqueFileName(String in_targetName, FileObject fo, String defName) {
        boolean isUniq = true;
        String targetName = in_targetName;
        if (targetName != null && targetName.length() != 0) {
            targetName = ResourceUtils.makeLegalFilename(targetName);
            targetName = targetName + "." + "sun-resource";
            File targFile = new File(fo.getPath(), targetName);
            if (targFile.exists()) {
                isUniq = false;
            }
        }
        return isUniq;
    }

    public static DatabaseConnection getDatabaseConnection(String url) {
        DatabaseConnection[] dbConns = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < dbConns.length; ++i) {
            String dbConnUrl = dbConns[i].getDatabaseURL();
            if (!dbConnUrl.startsWith(url)) continue;
            return dbConns[i];
        }
        return null;
    }

    public static InstanceProperties getTargetServer(FileObject fo) {
        J2eeModuleProvider modProvider;
        InstanceProperties serverName = null;
        Project holdingProj = FileOwnerQuery.getOwner((FileObject)fo);
        if (holdingProj != null && (modProvider = (J2eeModuleProvider)holdingProj.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            serverName = modProvider.getInstanceProperties();
        }
        return serverName;
    }

    public static HashMap getConnPoolValues(File resourceDir, String poolName) {
        HashMap poolValues = new HashMap();
        try {
            ObjectName configObjName = new ObjectName("com.sun.appserv:type=resources,category=config");
            InstanceProperties instanceProperties = ResourceUtils.getTargetServer(FileUtil.toFileObject((File)resourceDir));
            if (instanceProperties != null) {
                Object eightDM = null;
                LOGGER.log(Level.INFO, "investigate", new Exception());
                return poolValues;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "getConnPoolValues failed", ex);
        }
        return poolValues;
    }

    public static HashSet formatXmlSunDatasources(HashMap dsMap) {
        HashSet<SunDatasource> datasources = new HashSet<SunDatasource>();
        String[] keys = dsMap.keySet().toArray(new String[dsMap.size()]);
        for (int i = 0; i < keys.length; ++i) {
            String jndiName = keys[i];
            HashMap poolValues = (HashMap)dsMap.get(jndiName);
            poolValues = ResourceUtils.formatPoolMap(poolValues);
            String url = ResourceUtils.getStringVal(poolValues.get("URL"));
            String username = ResourceUtils.getStringVal(poolValues.get("User"));
            String password = ResourceUtils.getStringVal(poolValues.get("Password"));
            String driverClassName = ResourceUtils.getStringVal(poolValues.get("driverClass"));
            if (url == null || url.equals("")) continue;
            SunDatasource ds = new SunDatasource(jndiName, url, username, password, driverClassName);
            datasources.add(ds);
        }
        return datasources;
    }

    private static HashMap formatPoolMap(HashMap poolValues) {
        String driverClassName = ResourceUtils.getStringVal(poolValues.get("dsClassName"));
        String resType = ResourceUtils.getStringVal(poolValues.get("resType"));
        String url = "";
        String serverName = ResourceUtils.getStringVal(poolValues.get("serverName"));
        String portNo = ResourceUtils.getStringVal(poolValues.get("PortNumber"));
        String dbName = ResourceUtils.getStringVal(poolValues.get("DatabaseName"));
        String dbVal = ResourceUtils.getStringVal(poolValues.get("databaseName"));
        String portVal = ResourceUtils.getStringVal(poolValues.get("portNumber"));
        String sid = ResourceUtils.getStringVal(poolValues.get("SID"));
        String urlValue = ResourceUtils.getStringVal(poolValues.get("URL"));
        String driverClass = ResourceUtils.getStringVal(poolValues.get("driverClass"));
        String derbyConnAttr = ResourceUtils.getStringVal(poolValues.get("connectionAttributes"));
        if (driverClassName != null) {
            if (driverClassName.indexOf("pointbase") != -1) {
                url = ResourceUtils.getStringVal(poolValues.get("databaseName"));
            }
            if (urlValue == null || urlValue.equals("")) {
                if (driverClassName.indexOf("derby") != -1) {
                    if (serverName != null) {
                        url = "jdbc:derby://" + serverName;
                        if (portNo != null && portNo.length() > 0) {
                            url = url + ":" + portNo;
                        }
                        url = url + "/" + dbName;
                        if (derbyConnAttr != null && !derbyConnAttr.equals("")) {
                            url = url + derbyConnAttr;
                        }
                    }
                } else if (url == null || url.equals("")) {
                    String urlPrefix = DatabaseUtils.getUrlPrefix(driverClassName, resType);
                    String vName = ResourceConfigurator.getDatabaseVendorName(urlPrefix, null);
                    if (serverName != null) {
                        url = vName.equals("sun_oracle") ? urlPrefix + serverName : urlPrefix + "//" + serverName;
                        if (portVal != null && portVal.length() > 0) {
                            url = url + ":" + portVal;
                        }
                    }
                    if (vName.equals("sun_oracle") || vName.equals("datadirect_oracle")) {
                        url = url + ";SID=" + sid;
                    } else if (Arrays.asList(Reqd_DBName).contains(vName)) {
                        url = url + ";databaseName=" + dbVal;
                    } else if (Arrays.asList(VendorsDBNameProp).contains(vName)) {
                        url = url + "/" + dbVal;
                    }
                }
            } else {
                url = urlValue;
            }
        }
        if (url != null && !url.equals("") && (driverClass == null || driverClass.equals(""))) {
            DatabaseConnection databaseConnection = ResourceUtils.getDatabaseConnection(url);
            if (databaseConnection != null) {
                driverClass = databaseConnection.getDriverClass();
            } else {
                String drivername = DatabaseUtils.getDriverName(url);
                if (drivername != null) {
                    driverClass = drivername;
                }
            }
        }
        poolValues.put("URL", url);
        poolValues.put("driverClass", driverClass);
        return poolValues;
    }

    public static HashSet getServerDestinations(DeploymentManager dm) {
        HashSet<SunMessageDestination> destinations = new HashSet<SunMessageDestination>();
        try {
            ObjectName configObjName = new ObjectName("com.sun.appserv:type=resources,category=config");
            SunDeploymentManagerInterface eightDM = (SunDeploymentManagerInterface)dm;
            ServerInterface mejb = eightDM.getManagement();
            if (eightDM.isRunning()) {
                ObjectName[] resourceObjects = (ObjectName[])mejb.invoke(configObjName, "getAdminObjectResource", null, null);
                for (int i = 0; i < resourceObjects.length; ++i) {
                    ObjectName objName = resourceObjects[i];
                    String jndiName = (String)mejb.getAttribute(objName, "jndi-name");
                    String type = (String)mejb.getAttribute(objName, "res-type");
                    SunMessageDestination sunMessage = null;
                    sunMessage = type.equals("javax.jms.Queue") ? new SunMessageDestination(jndiName, MessageDestination.Type.QUEUE) : new SunMessageDestination(jndiName, MessageDestination.Type.TOPIC);
                    destinations.add(sunMessage);
                }
            } else if (eightDM.isLocal()) {
                HashMap aoMap = eightDM.getAdminObjectResourcesFromXml();
                String[] keys = aoMap.keySet().toArray(new String[aoMap.size()]);
                for (int i = 0; i < keys.length; ++i) {
                    String jndiName = keys[i];
                    String type = (String)aoMap.get(jndiName);
                    SunMessageDestination sunMessage = null;
                    sunMessage = type.equals("javax.jms.Queue") ? new SunMessageDestination(jndiName, MessageDestination.Type.QUEUE) : new SunMessageDestination(jndiName, MessageDestination.Type.TOPIC);
                    destinations.add(sunMessage);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "getServerDestinations failed", ex);
        }
        return destinations;
    }

    public static boolean is90Server(ServerInterface mejb) {
        boolean is90Server = true;
        SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)mejb.getDeploymentManager();
        if (sunDm.isLocal()) {
            is90Server = ResourceUtils.is90ServerLocal(sunDm);
        } else {
            try {
                ObjectName serverObj = new ObjectName("com.sun.appserv:j2eeType=J2EEServer,name=server,category=runtime");
                String serverName = (String)mejb.getAttribute(serverObj, "serverVersion");
                if (serverName != null && serverName.indexOf("8.") != -1) {
                    is90Server = false;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "is90Server failed", ex);
            }
        }
        return is90Server;
    }

    private static boolean is90ServerLocal(SunDeploymentManagerInterface sunDm) {
        boolean isGlassfish = true;
        try {
            isGlassfish = ServerLocationManager.isGlassFish(sunDm.getPlatformRoot());
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "is90ServerLocal failed", ex);
        }
        return isGlassfish;
    }

    public static Resources getServerResourcesGraph(File targetFolder) {
        FileObject location = FileUtil.toFileObject((File)targetFolder.getParentFile());
        try {
            location = FileUtil.createFolder((File)targetFolder);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "getServerResourcesGraph failed", ex);
        }
        return ResourceUtils.getServerResourcesGraph(location, "");
    }

    public static Resources getServerResourcesGraph(FileObject targetFolder, String version) {
        Resources res = ResourceUtils.getResourceGraph(version);
        File sunResource = ResourceUtils.getServerResourcesFile(targetFolder = ResourceUtils.setUpExists(targetFolder), true);
        if (sunResource != null) {
            res = ResourceUtils.getResourcesGraph(sunResource);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resources getResourcesGraph(File sunResource) {
        Resources res = null;
        if (sunResource != null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(sunResource);
                res = DDProvider.getDefault().getResourcesGraph((InputStream)in);
            }
            catch (FileNotFoundException ex) {
                LOGGER.log(Level.SEVERE, "getResourcesGraph failed", ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "getResourcesGraph failed", ex);
            }
            catch (SAXException ex) {
                LOGGER.log(Level.SEVERE, "getResourcesGraph failed", ex);
            }
            finally {
                try {
                    if (null != in) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "getResourcesGraph failed", ex);
                }
            }
        }
        return res;
    }

    public static void createFile(File targetFolder, Resources res, String baseName) {
        ResourceUtils.createFile(FileUtil.toFileObject((File)targetFolder), res, baseName);
    }

    public static void createFile(FileObject targetFolder, Resources res, String baseName) {
        FileObject folderToWrite = ResourceUtils.setUpExists(targetFolder);
        if (!ResourceUtils.overwriteExistingResourcesFile(folderToWrite, res)) {
            File resourceFile = new File(FileUtil.toFile((FileObject)folderToWrite), baseName);
            ResourceUtils.writeNewResourceFile(resourceFile, res);
        }
    }

    public static void createFile(ResourceConfigData configData, Resources res, String baseName) {
        if (!ResourceUtils.overwriteExistingResourcesFile(configData.getTargetFileObject(), res)) {
            File resourceFile = configData.targetFileForNewResourceFile(baseName);
            ResourceUtils.writeNewResourceFile(resourceFile, res);
        }
    }

    private static boolean overwriteExistingResourcesFile(FileObject targetFolder, Resources res) {
        File resourceFile = ResourceUtils.getServerResourcesFile(targetFolder, true);
        if (resourceFile != null && resourceFile.exists()) {
            try {
                res.write(resourceFile);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to overwrite server resources file", ex);
            }
            return true;
        }
        return false;
    }

    private static void writeNewResourceFile(final File resourceFile, final Resources res) {
        try {
            FileObject resourceFileDir = FileUtil.toFileObject((File)resourceFile.getParentFile());
            FileSystem fs = resourceFileDir.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    resourceFile.createNewFile();
                    FileObject resourceFileFo = FileUtil.toFileObject((File)resourceFile);
                    FileLock lock = resourceFileFo.lock();
                    Writer out = null;
                    try {
                        out = new OutputStreamWriter(resourceFileFo.getOutputStream(lock), "UTF8");
                        res.write(out);
                        out.flush();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.SEVERE, "Failed to write new server resources file", ex);
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                        lock.releaseLock();
                    }
                }
            });
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to write new server resources file", ex);
        }
    }

    public static File getServerResourcesFile(FileObject targetFolder, boolean search) {
        File serverResource = null;
        if (targetFolder != null) {
            FileObject setUpFolder = ResourceUtils.setUpExists(targetFolder);
            if (search) {
                FileObject metaInf = setUpFolder.getParent().getFileObject("web/WEB-INF");
                if (null == metaInf && null == (metaInf = setUpFolder.getParent().getFileObject("src/java/META-INF"))) {
                    metaInf = targetFolder.getParent().getFileObject("java/META-INF");
                }
                if (null != metaInf) {
                    FileObject resourcesFO = metaInf.getFileObject(RESOURCE_FILES[0]);
                    if (null == resourcesFO) {
                        resourcesFO = metaInf.getFileObject(RESOURCE_FILES[1]);
                    }
                    if (null != resourcesFO) {
                        return FileUtil.toFile((FileObject)resourcesFO);
                    }
                }
            }
            Enumeration en = setUpFolder.getData(false);
            while (en.hasMoreElements()) {
                FileObject resourceFile = (FileObject)en.nextElement();
                File resource = FileUtil.toFile((FileObject)resourceFile);
                if (resource.getName().equals(RESOURCE_FILES[1])) {
                    serverResource = resource;
                }
                if (!resource.getName().equals(RESOURCE_FILES[0])) continue;
                serverResource = resource;
                break;
            }
        }
        return serverResource;
    }

    public static void migrateResources(File resourceDir, String baseName) {
        ResourceUtils.migrateResources(FileUtil.toFileObject((File)resourceDir), baseName);
    }

    public static void migrateResources(FileObject targetFolder, String baseName) {
        File resourceDir;
        File[] resources;
        File sunResource = ResourceUtils.getServerResourcesFile(targetFolder = ResourceUtils.setUpExists(targetFolder), false);
        if (!(sunResource != null && sunResource.exists() || (resources = (resourceDir = FileUtil.toFile((FileObject)targetFolder)).listFiles(new OldResourceFileFilter())).length <= 0)) {
            Resources newGraph = DDProvider.getDefault().getResourcesGraph("1.30");
            try {
                for (int i = 0; i < resources.length; ++i) {
                    File oldResource = resources[i];
                    FileInputStream in = new FileInputStream(oldResource);
                    Resources existResource = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                    newGraph = ResourceUtils.getResourceGraphs(newGraph, existResource);
                    boolean success = oldResource.delete();
                    if (success) continue;
                    LOGGER.log(Level.INFO, "Unable to delete *.sun-resource file(s)");
                }
                ResourceUtils.createFile(targetFolder, newGraph, baseName);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "migrateResources failed", ex);
            }
        }
    }

    private static Resources getResourceGraphs(Resources consolidatedGraph, Resources existResource) {
        PersistenceManagerFactoryResource[] pmfResources;
        AdminObjectResource[] aoResources;
        MailResource[] mailResources;
        JdbcResource[] dataSources;
        JdbcConnectionPool[] pools = existResource.getJdbcConnectionPool();
        if (pools.length != 0) {
            ConnPoolBean currCPBean = ConnPoolBean.createBean(pools[0]);
            currCPBean.getBeanInGraph(consolidatedGraph);
        }
        if ((dataSources = existResource.getJdbcResource()).length != 0) {
            DataSourceBean currDSBean = DataSourceBean.createBean(dataSources[0]);
            currDSBean.getBeanInGraph(consolidatedGraph);
        }
        if ((mailResources = existResource.getMailResource()).length != 0) {
            JavaMailSessionBean currMailBean = JavaMailSessionBean.createBean(mailResources[0]);
            currMailBean.getBeanInGraph(consolidatedGraph);
        }
        if ((aoResources = existResource.getAdminObjectResource()).length != 0) {
            JMSBean jmsBean = JMSBean.createBean(aoResources[0]);
            jmsBean.getAdminObjectBeanInGraph(consolidatedGraph);
        }
        ConnectorResource[] connResources = existResource.getConnectorResource();
        ConnectorConnectionPool[] connPoolResources = existResource.getConnectorConnectionPool();
        if (connResources.length != 0 && connPoolResources.length != 0) {
            JMSBean jmsBean = JMSBean.createBean(existResource);
            jmsBean.getConnectorBeanInGraph(consolidatedGraph);
        }
        if ((pmfResources = existResource.getPersistenceManagerFactoryResource()).length != 0) {
            PersistenceManagerBean currPMFBean = PersistenceManagerBean.createBean(pmfResources[0]);
            currPMFBean.getBeanInGraph(consolidatedGraph);
        }
        return consolidatedGraph;
    }

    public static String getUniqueResourceName(String name, HashMap resources) {
        int i = 1;
        String resourceName;
        while (resources.containsKey(resourceName = name + "_" + i)) {
            ++i;
        }
        return resourceName;
    }

    public static String getUniqueResourceName(String name, List resources) {
        int i = 1;
        String resourceName;
        while (resources.contains(resourceName = name + "_" + i)) {
            ++i;
        }
        return resourceName;
    }

    private static class OldResourceFileFilter
    implements FileFilter {
        private OldResourceFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return !f.isDirectory() && f.getName().toLowerCase(Locale.ENGLISH).endsWith(".sun-resource");
        }
    }
}

