/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.jpqleditor;

import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.util.Elements;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblemResourceBundle;
import org.eclipse.persistence.jpa.jpql.parser.DefaultJPQLGrammar;
import org.eclipse.persistence.jpa.jpql.tools.DefaultJPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.tools.spi.IQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceEnvironment;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.jpqleditor.JPQLResult;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.jpql.ManagedTypeProvider;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Query;
import org.openide.filesystems.FileObject;

public class JPQLExecutor {
    private static final Logger LOG = Logger.getLogger(JPQLExecutor.class.getName());
    private static final String ECLIPSELINK_QUERY = "org.eclipse.persistence.jpa.JpaQuery";
    private static final String ECLIPSELINK_QUERY_SQL0 = "getDatabaseQuery";
    private static final String ECLIPSELINK_QUERY_SQL1 = "getSQLString";
    private static final String HIBERNATE_QUERY = "org.hibernate.ejb.HibernateQuery";
    private static final String HIBERNATE_QUERY_SQL0 = "getSessionFactory";
    private static final String HIBERNATE_QUERY_SQL1 = "getQueryPlanCache";
    private static final String HIBERNATE_QUERY_SQL2 = "getHQLQueryPlan";
    private static final String HIBERNATE_QUERY_SQL3 = "getTranslators";
    private static final String HIBERNATE_QUERY_SQL4 = "getSQLString";
    private static final String OPENJPA_QUERY = "org.apache.openjpa.persistence.QueryImpl";
    private static final String OPENJPA_QUERY_SQL = "getQueryString";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPQLResult execute(String jpql, Persistence persistence, PersistenceUnit persistenceUnit, PersistenceEnvironment pe, HashMap<String, String> props, Provider provider, int maxRowCount, ProgressHandle ph, boolean execute) {
        JPQLResult result;
        block27: {
            result = new JPQLResult();
            jpql = jpql.trim();
            try {
                Object emf = null;
                Object em = null;
                Object transaction = null;
                try {
                    Method method;
                    Class<?> qClass;
                    ph.progress(60);
                    Class<?> pClass = this.isJakarta(persistence.getVersion()) ? Thread.currentThread().getContextClassLoader().loadClass("jakarta.persistence.Persistence") : Thread.currentThread().getContextClassLoader().loadClass("javax.persistence.Persistence");
                    Object persistenceManager = pClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    emf = this.invokeReflectively(persistenceManager, "createEntityManagerFactory", List.of(String.class, Map.class), List.of(persistenceUnit.getName(), props));
                    em = this.invokeReflectively(emf, "createEntityManager", List.of(), List.of());
                    Logger.getLogger("org.hibernate.hql.internal.ast.ErrorCounter").setFilter(record -> {
                        if (record.getLevel().intValue() > Level.INFO.intValue()) {
                            record.setLevel(Level.INFO);
                        }
                        return true;
                    });
                    Object query = this.invokeReflectively(em, "createQuery", List.of(String.class), List.of(jpql));
                    String queryStr = null;
                    if ("org.eclipse.persistence.jpa.PersistenceProvider".equals(provider.getProviderClass())) {
                        Method method2;
                        qClass = Thread.currentThread().getContextClassLoader().loadClass(ECLIPSELINK_QUERY);
                        if (qClass != null && (method2 = qClass.getMethod(ECLIPSELINK_QUERY_SQL0, new Class[0])) != null) {
                            Method method22;
                            Object dqOject = method2.invoke(query, new Object[0]);
                            Method method3 = method22 = dqOject != null ? dqOject.getClass().getMethod("getSQLString", new Class[0]) : null;
                            if (method22 != null) {
                                queryStr = (String)method22.invoke(dqOject, new Object[0]);
                            }
                        }
                    } else if ("org.hibernate.jpa.HibernatePersistenceProvider".equals(provider.getProviderClass())) {
                        Method method4 = emf.getClass().getMethod(HIBERNATE_QUERY_SQL0, new Class[0]);
                        Object sessionFactoryImpl = method4.invoke(emf, new Object[0]);
                        Method method2 = sessionFactoryImpl.getClass().getMethod(HIBERNATE_QUERY_SQL1, new Class[0]);
                        Object qPlanCache = method2.invoke(sessionFactoryImpl, new Object[0]);
                        Method method3 = qPlanCache.getClass().getMethod(HIBERNATE_QUERY_SQL2, String.class, Boolean.TYPE, Map.class);
                        Object cache = method3.invoke(qPlanCache, jpql, true, Collections.emptyMap());
                        Method method42 = cache.getClass().getMethod(HIBERNATE_QUERY_SQL3, new Class[0]);
                        Object[] translators = (Object[])method42.invoke(cache, new Object[0]);
                        StringBuilder stringBuff = new StringBuilder();
                        if (translators != null && translators.length > 0) {
                            Method method5 = translators[0].getClass().getMethod("getSQLString", new Class[0]);
                            for (Object translator : translators) {
                                stringBuff.append(method5.invoke(translator, new Object[0])).append("\n");
                            }
                        }
                        queryStr = stringBuff.toString();
                    } else if ("org.apache.openjpa.persistence.PersistenceProviderImpl".equals(provider.getProviderClass()) && (qClass = Thread.currentThread().getContextClassLoader().loadClass(OPENJPA_QUERY)) != null && (method = qClass.getMethod(OPENJPA_QUERY_SQL, new Class[0])) != null) {
                        queryStr = (String)method.invoke(query, new Object[0]);
                    }
                    result.setSqlQuery(queryStr);
                    ph.progress(70);
                    if (execute) {
                        transaction = this.invokeReflectively(em, "getTransaction", List.of(), List.of());
                        this.invokeReflectively(transaction, "begin", List.of(), List.of());
                        this.invokeReflectively(query, "setMaxResults", List.of(Integer.TYPE), List.of(Integer.valueOf(maxRowCount)));
                        String jpql0 = jpql.toUpperCase();
                        if (jpql0.startsWith("UPDATE") || jpql0.startsWith("DELETE")) {
                            result.setUpdateOrDeleteResult((Integer)this.invokeReflectively(query, "executeUpdate", List.of(), List.of()));
                        } else {
                            result.setQueryResults((List)this.invokeReflectively(query, "getResultList", List.of(), List.of()));
                        }
                        this.invokeReflectively(transaction, "commit", List.of(), List.of());
                    }
                }
                catch (ReflectiveOperationException | RuntimeException e) {
                    result.getExceptions().add(e);
                    Project project = pe.getProject();
                    SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
                    JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)sourceGroups[0].getRootFolder()), (FileObject[])new FileObject[0]);
                    ArrayList problems = new ArrayList();
                    String jpql0 = jpql;
                    try {
                        js.runUserActionTask(controller -> {
                            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            EntityClassScopeProvider provider1 = (EntityClassScopeProvider)project.getLookup().lookup(EntityClassScopeProvider.class);
                            EntityClassScope ecs = null;
                            if (provider1 != null) {
                                ecs = provider1.findEntityClassScope(pe.getLocation().getFileObject("persistence.xml"));
                            }
                            EntityClassScope scope = ecs;
                            MetadataModel entityMappingsModel = null;
                            if (scope != null) {
                                entityMappingsModel = scope.getEntityMappingsModel(false);
                            }
                            if (entityMappingsModel != null) {
                                Elements elms = controller.getElements();
                                entityMappingsModel.runReadAction(metadata -> {
                                    ManagedTypeProvider mtp = new ManagedTypeProvider(project, (EntityMappingsMetadata)metadata, elms);
                                    DefaultJPQLQueryHelper helper = new DefaultJPQLQueryHelper(DefaultJPQLGrammar.instance());
                                    helper.setQuery((IQuery)new Query(null, jpql0, mtp));
                                    try {
                                        problems.addAll(helper.validate());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    return null;
                                });
                            }
                        }, false);
                    }
                    catch (IOException method2) {
                    }
                    finally {
                        if (transaction != null) {
                            this.invokeReflectively(transaction, "isActive");
                            this.invokeReflectively(transaction, "rollback");
                        }
                        if (em != null) {
                            this.invokeReflectively(em, "clear");
                            this.invokeReflectively(em, "close");
                        }
                        if (emf != null) {
                            this.invokeReflectively(emf, "close");
                        }
                    }
                    if (problems.isEmpty()) break block27;
                    StringBuilder message = new StringBuilder();
                    for (int i = 0; i < problems.size(); ++i) {
                        ListResourceBundle msgBundle;
                        try {
                            msgBundle = (ListResourceBundle)ResourceBundle.getBundle(JPQLQueryProblemResourceBundle.class.getName());
                        }
                        catch (MissingResourceException ex) {
                            msgBundle = (ListResourceBundle)ResourceBundle.getBundle(JPQLQueryProblemResourceBundle.class.getName(), Locale.ENGLISH);
                        }
                        message.append(MessageFormat.format(msgBundle.getString(((JPQLQueryProblem)problems.get(i)).getMessageKey()), ((JPQLQueryProblem)problems.get(i)).getMessageArguments())).append("\n");
                    }
                    result.setQueryProblems(message.toString());
                }
            }
            catch (ReflectiveOperationException | SecurityException ex) {
                LOG.log(Level.INFO, "Failed to execute JPA query", ex);
            }
        }
        return result;
    }

    private Object invokeReflectively(Object thisObj, String methodName) throws SecurityException, ReflectiveOperationException {
        return this.invokeReflectively(thisObj, methodName, List.of(), List.of());
    }

    private Object invokeReflectively(Object thisObj, String methodName, List<?> parameterClass, List<Object> args) throws SecurityException, ReflectiveOperationException {
        Class<?> clazz = thisObj.getClass();
        Method targetMethod = clazz.getMethod(methodName, (Class[])parameterClass.toArray(Class[]::new));
        return targetMethod.invoke(thisObj, (Object[])args.toArray(Object[]::new));
    }

    private boolean isJakarta(String versionString) {
        String[] versionParts = versionString.split("\\.");
        Integer version = null;
        try {
            version = Integer.valueOf(versionParts[0]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
            LOG.log(Level.INFO, "Failed to parse persistence version: " + versionString, ex);
        }
        return version == null || version >= 3;
    }
}

