/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.tools.ResultQuery;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.j2ee.persistence.editor.JPAEditorUtil;
import org.netbeans.modules.j2ee.persistence.editor.completion.CCPaintComponent;
import org.netbeans.modules.j2ee.persistence.editor.completion.PUCompletionManager;
import org.netbeans.modules.j2ee.persistence.editor.completion.PersistenceCompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class JPACompletionItem
implements CompletionItem {
    protected int substituteOffset = -1;
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    static String toAdd;

    static JPACompletionItem createAttribValueItem(int substitutionOffset, String displayText) {
        return new AttribValueItem(substitutionOffset, displayText);
    }

    static JPACompletionItem createTypeItem(int substitutionOffset, TypeElement typeElement, ElementHandle<TypeElement> create, boolean deprecated, boolean b) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    static JPACompletionItem createDatabaseTableItem(int i, String tableName) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    static JPACompletionItem createCascadeStyleItem(int i, String string, String string0) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    static JPACompletionItem createPackageItem(int substitutionOffset, String displayText) {
        return new AttribValueItem(substitutionOffset, displayText);
    }

    static JPACompletionItem createClassPropertyItem(int substitutionOffset, VariableElement variableElem, ElementHandle<VariableElement> elemHandle, boolean deprecated) {
        return new ClassPropertyItem(substitutionOffset, variableElem, elemHandle, deprecated);
    }

    static JPACompletionItem createMappingFileItem(int substitutionOffset, String displayText) {
        return new MappingFileItem(substitutionOffset, displayText);
    }

    static JPACompletionItem createHbPropertyValueItem(int substitutionOffset, String displayText) {
        return new PropertyValueItem(substitutionOffset, displayText);
    }

    public abstract String getItemText();

    public String getSubstitutionText() {
        return this.getItemText();
    }

    public int getSubstituteOffset() {
        return this.substituteOffset;
    }

    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean substituteText(JTextComponent c, int offset, int len, boolean shifted) {
        BaseDocument doc = (BaseDocument)c.getDocument();
        Object text = this.getSubstitutionText();
        if (text != null) {
            if (toAdd != null && !toAdd.equals("\n")) {
                text = (String)text + toAdd;
            }
            doc.atomicLock();
            try {
                String textToReplace = doc.getText(offset, len);
                if (((String)text).equals(textToReplace)) {
                    boolean bl = false;
                    return bl;
                }
                if (!shifted) {
                    char ch;
                    if (!((String)text).startsWith("\"")) {
                        text = this.quoteText((String)text);
                    }
                    if ((ch = doc.getText(offset + len, 1).charAt(0)) == '\"') {
                        ++len;
                    }
                }
                doc.remove(offset, len);
                doc.insertString(offset, (String)text, null);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                doc.atomicUnlock();
            }
            return true;
        }
        return false;
    }

    public boolean canFilter() {
        return true;
    }

    public boolean cutomPosition() {
        return false;
    }

    public int getCutomPosition() {
        return -1;
    }

    public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
        Component ret = this.getPaintComponent(isSelected);
        if (ret == null) {
            return null;
        }
        if (isSelected) {
            ret.setBackground(list.getSelectionBackground());
            ret.setForeground(list.getSelectionForeground());
        } else {
            ret.setBackground(list.getBackground());
            ret.setForeground(list.getForeground());
        }
        ret.getAccessibleContext().setAccessibleName(this.getItemText());
        ret.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return ret;
    }

    public abstract Component getPaintComponent(boolean var1);

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        Component renderComponent = this.getPaintComponent(false);
        return renderComponent.getPreferredSize().width;
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        Component renderComponent = this.getPaintComponent(selected);
        renderComponent.setFont(defaultFont);
        renderComponent.setForeground(defaultColor);
        renderComponent.setBackground(backgroundColor);
        renderComponent.setBounds(0, 0, width, height);
        ((CCPaintComponent)renderComponent).paintComponent(g);
    }

    public String toString() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 400) {
            Completion completion = Completion.get();
            switch (evt.getKeyChar()) {
                case ' ': {
                    if (evt.getModifiers() != 0) break;
                    completion.hideCompletion();
                    completion.hideDocumentation();
                }
            }
        }
    }

    protected String quoteText(String s) {
        return "\"" + s + "\"";
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent c) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(c);
        return true;
    }

    public void defaultAction(JTextComponent component) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(component, "");
    }

    private boolean defaultAction(JTextComponent component, String addText) {
        int substOffset = this.substituteOffset;
        if (substOffset == -1) {
            substOffset = component.getCaret().getDot();
        }
        toAdd = addText;
        return this.substituteText(component, substOffset, component.getCaret().getDot() - substOffset, false);
    }

    private static class AttribValueItem
    extends PersistenceXmlCompletionItem {
        private String displayText;

        public AttribValueItem(int substitutionOffset, String displayText) {
            super(substitutionOffset);
            this.displayText = displayText;
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public CharSequence getSortText() {
            return this.displayText;
        }

        @Override
        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayText;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                    String docText = null;
                    try {
                        docText = NbBundle.getMessage(PUCompletionManager.class, (String)(displayText + "_DESC"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (docText != null) {
                        PersistenceCompletionDocumentation documentation = PersistenceCompletionDocumentation.getAttribValueDoc(docText);
                        resultSet.setDocumentation((CompletionDocumentation)documentation);
                    }
                    resultSet.finish();
                }
            });
        }

        @Override
        public String getItemText() {
            return this.displayText;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class ClassPropertyItem
    extends PersistenceXmlCompletionItem {
        private static final String FIELD_ICON = "org/netbeans/modules/editor/resources/completion/field_16.png";
        private ElementHandle<VariableElement> elemHandle;
        private String displayName;

        public ClassPropertyItem(int substitutionOffset, VariableElement elem, ElementHandle<VariableElement> elemHandle, boolean deprecated) {
            super(substitutionOffset);
            this.elemHandle = elemHandle;
            this.displayName = elem.getSimpleName().toString();
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public CharSequence getSortText() {
            return this.displayName;
        }

        @Override
        public CharSequence getInsertPrefix() {
            return this.displayName;
        }

        @Override
        public String getDisplayText() {
            return this.displayName;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayName;
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)FIELD_ICON, (boolean)false);
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                    try {
                        JavaSource js = JPAEditorUtil.getJavaSource(doc);
                        if (js == null) {
                            return;
                        }
                        js.runUserActionTask(cc -> {
                            cc.toPhase(JavaSource.Phase.RESOLVED);
                            Element element = elemHandle.resolve((CompilationInfo)cc);
                            if (element == null) {
                                return;
                            }
                            PersistenceCompletionDocumentation doc1 = PersistenceCompletionDocumentation.createJavaDoc(cc, element);
                            resultSet.setDocumentation((CompletionDocumentation)doc1);
                        }, false);
                        resultSet.finish();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }, EditorRegistry.lastFocusedComponent());
        }

        @Override
        public String getItemText() {
            return this.displayName;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class MappingFileItem
    extends PersistenceXmlCompletionItem {
        private static final String HB_MAPPING_ICON = "org/netbeans/modules/j2ee/persistence/resources/hibernate-mapping.png";
        private String displayText;

        public MappingFileItem(int substitutionOffset, String displayText) {
            super(substitutionOffset);
            this.displayText = displayText;
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public CharSequence getSortText() {
            return this.displayText;
        }

        @Override
        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayText;
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)HB_MAPPING_ICON, (boolean)false);
        }

        @Override
        public String getItemText() {
            return this.displayText;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class PropertyValueItem
    extends PersistenceXmlCompletionItem {
        private String displayText;

        public PropertyValueItem(int substitutionOffset, String displayText) {
            super(substitutionOffset);
            this.displayText = displayText;
        }

        public int getSortPriority() {
            if (this.displayText.startsWith("--")) {
                return 101;
            }
            if (this.displayText.equals("true")) {
                return 98;
            }
            if (this.displayText.equals("false")) {
                return 99;
            }
            return 100;
        }

        @Override
        public CharSequence getSortText() {
            return this.displayText;
        }

        @Override
        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayText;
        }

        @Override
        public String getItemText() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static abstract class PersistenceXmlCompletionItem
    extends JPACompletionItem {
        protected int substitutionOffset;

        protected PersistenceXmlCompletionItem(int substitutionOffset) {
            this.substitutionOffset = substitutionOffset;
        }

        @Override
        public void defaultAction(JTextComponent component) {
            if (component != null) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
                int caretOffset = component.getSelectionEnd();
                this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(JTextComponent c, int offset, int len, String toAdd) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            CharSequence prefix = this.getInsertPrefix();
            Object text = prefix.toString();
            if (toAdd != null) {
                text = (String)text + toAdd;
            }
            doc.atomicLock();
            try {
                Position position = doc.createPosition(offset);
                doc.remove(offset, len);
                doc.insertString(position.getOffset(), (String)text, null);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                doc.atomicUnlock();
            }
        }

        @Override
        public String getSubstitutionText() {
            return this.getInsertPrefix().toString();
        }

        @Override
        public void processKeyEvent(KeyEvent evt) {
        }

        @Override
        public int getPreferredWidth(Graphics g, Font defaultFont) {
            return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
        }

        @Override
        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return null;
        }

        @Override
        public CompletionTask createToolTipTask() {
            return null;
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            this.defaultAction(component);
            return true;
        }

        protected String getLeftHtmlText() {
            return null;
        }

        protected String getRightHtmlText() {
            return null;
        }

        protected ImageIcon getIcon() {
            return null;
        }

        public abstract String getDisplayText();
    }

    public static final class AddConnectionElementItem
    extends JPACompletionItem {
        private static CCPaintComponent.AddConnectionItemPaintComponent paintComponent = null;

        public int getSortPriority() {
            return 1000;
        }

        @Override
        public String getItemText() {
            return "";
        }

        @Override
        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            ConnectionManager.getDefault().showAddConnectionDialog(null);
            return false;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.AddConnectionItemPaintComponent();
            }
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }

        public Object getAssociatedObject() {
            return this;
        }
    }

    public static final class NoConnectionElementItem
    extends JPACompletionItem {
        private static CCPaintComponent.NoConnectionItemPaintComponent paintComponent = null;
        private DatabaseConnection dbconn;

        public NoConnectionElementItem(DatabaseConnection dbconn) {
            this.dbconn = dbconn;
        }

        public int getSortPriority() {
            return 1;
        }

        @Override
        public String getItemText() {
            return "";
        }

        @Override
        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            ConnectionManager.getDefault().showConnectionDialog(this.dbconn);
            return false;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.NoConnectionItemPaintComponent();
            }
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }

        public Object getAssociatedObject() {
            return this;
        }
    }

    public static final class ColumnElementItem
    extends DBElementItem {
        private String tableName;
        protected static CCPaintComponent.ColumnElementPaintComponent paintComponent = null;

        public ColumnElementItem(String columnName, String tableName, boolean quote, int substituteOffset) {
            super(columnName, quote, substituteOffset);
            this.tableName = tableName;
        }

        @Override
        public String getTypeName() {
            return "Column";
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public String getItemText() {
            return "\"" + this.getName() + "\"";
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.ColumnElementPaintComponent();
            }
            paintComponent.setContent(this.getName(), this.tableName);
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }

        @Override
        public Object getAssociatedObject() {
            return this;
        }
    }

    public static final class IndexElementItem
    extends DBElementItem {
        public static final String ASC = "ASC";
        public static final String DESC = "DESC";
        public static final String[] PARAMS = new String[]{"ASC", "DESC"};
        private final int shift;
        protected static CCPaintComponent.TableElementPaintComponent paintComponent = null;

        public IndexElementItem(String name, boolean quote, int substituteOffset, int shift) {
            super(name, quote, substituteOffset);
            this.shift = shift;
        }

        @Override
        public String getTypeName() {
            return "Table";
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.TableElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }

        @Override
        public Object getAssociatedObject() {
            return this;
        }

        @Override
        public int getSubstituteOffset() {
            return super.getSubstituteOffset() + this.shift;
        }

        @Override
        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            return super.substituteText(c, offset + this.shift, len - this.shift, this.shift != 0);
        }
    }

    public static final class TableElementItem
    extends DBElementItem {
        protected static CCPaintComponent.TableElementPaintComponent paintComponent = null;

        public TableElementItem(String name, boolean quote, int substituteOffset) {
            super(name, quote, substituteOffset);
        }

        @Override
        public String getTypeName() {
            return "Table";
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.TableElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }

        @Override
        public Object getAssociatedObject() {
            return this;
        }
    }

    public static final class SchemaElementItem
    extends DBElementItem {
        public SchemaElementItem(String name, boolean quote, int substituteOffset) {
            super(name, quote, substituteOffset);
        }

        @Override
        public String getTypeName() {
            return "Schema";
        }

        public int getSortPriority() {
            return 100;
        }
    }

    public static final class CatalogElementItem
    extends DBElementItem {
        public CatalogElementItem(String name, boolean quote, int substituteOffset) {
            super(name, quote, substituteOffset);
        }

        @Override
        public String getTypeName() {
            return "Catalog";
        }

        public int getSortPriority() {
            return 100;
        }
    }

    public static final class JPQLElementItem
    extends DBElementItem {
        protected static CCPaintComponent.EntityPropertyElementPaintComponent paintComponent = null;
        private final String initialvalue;
        private final ContentAssistProposals caProposal;
        private final int internalOffset;
        private int customOffset = 0;
        private boolean toQuote = true;

        public JPQLElementItem(String name, boolean quote, boolean toQuote, int substituteOffset, int internalOffset, String valueInitial, ContentAssistProposals buildContentAssistProposals) {
            super(name, quote, substituteOffset);
            this.initialvalue = valueInitial;
            this.caProposal = buildContentAssistProposals;
            this.internalOffset = internalOffset;
            this.toQuote = toQuote;
        }

        public JPQLElementItem(String name, boolean quote, int substituteOffset, int internalOffset, String valueInitial, ContentAssistProposals buildContentAssistProposals) {
            this(name, quote, true, substituteOffset, internalOffset, valueInitial, buildContentAssistProposals);
        }

        @Override
        public String getTypeName() {
            return "JPQL";
        }

        @Override
        public boolean canFilter() {
            return false;
        }

        @Override
        public boolean cutomPosition() {
            return true;
        }

        @Override
        public int getCutomPosition() {
            return this.customOffset + (this.toQuote ? 1 : 0);
        }

        @Override
        public String getSubstitutionText() {
            ResultQuery buildEscapedQuery = this.caProposal.buildEscapedQuery(this.initialvalue, this.getName(), this.internalOffset, false);
            String newQ = buildEscapedQuery.getQuery();
            this.customOffset = buildEscapedQuery.getPosition();
            return newQ;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            len = this.initialvalue.length() + (this.getQuoted() ? 2 : 0);
            BaseDocument doc = (BaseDocument)c.getDocument();
            Object text = this.getSubstitutionText();
            if (text != null) {
                if (toAdd != null && !toAdd.equals("\n")) {
                    text = (String)text + toAdd;
                }
                doc.atomicLock();
                try {
                    String textToReplace = doc.getText(offset, len);
                    if (((String)text).equals(textToReplace)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.toQuote && !((String)text).startsWith("\"")) {
                        text = this.quoteText((String)text);
                    }
                    char ch = doc.getText(offset + len, 1).charAt(0);
                    if (this.toQuote && ch == '\"') {
                        ++len;
                    }
                    doc.remove(offset, this.getCutomPosition() - (((String)text).length() - (this.toQuote ? 2 : 0) - this.initialvalue.length()));
                    doc.insertString(offset, ((String)text).substring(0, this.getCutomPosition()), null);
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    doc.atomicUnlock();
                }
                return true;
            }
            return false;
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.EntityPropertyElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }
    }

    public static final class EntityPropertyElementItem
    extends DBElementItem {
        protected static CCPaintComponent.EntityPropertyElementPaintComponent paintComponent = null;

        public EntityPropertyElementItem(String name, boolean quote, int substituteOffset) {
            super(name, quote, substituteOffset);
        }

        @Override
        public String getTypeName() {
            return "Persistence Unit";
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.EntityPropertyElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }
    }

    public static final class NamedQueryNameItem
    extends DBElementItem {
        protected static CCPaintComponent.NamedQueryNameElementPaintComponent paintComponent = null;
        private String entity;
        private String query;

        public NamedQueryNameItem(String nqname, String entityName, String query, boolean quote, int substituteOffset) {
            super(nqname, quote, substituteOffset);
            this.entity = entityName;
            this.query = query;
        }

        @Override
        public String getTypeName() {
            return "Named Query";
        }

        @Override
        protected String getName() {
            return super.getName() + " (" + this.entity + ")";
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.NamedQueryNameElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            if (this.query != null) {
                return new AsyncCompletionTask(new AsyncCompletionQuery(){

                    protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                        String docText = null;
                        try {
                            docText = NbBundle.getMessage(PUCompletionManager.class, (String)"NAMED_QUERY_TEXT", (Object)this.getSubstitutionText(), (Object)entity, (Object)query);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (docText != null) {
                            PersistenceCompletionDocumentation documentation = PersistenceCompletionDocumentation.getAttribValueDoc(docText);
                            resultSet.setDocumentation((CompletionDocumentation)documentation);
                        }
                        resultSet.finish();
                    }
                });
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            Object text = this.getSubstitutionText();
            if (text != null) {
                if (toAdd != null && !toAdd.equals("\n")) {
                    text = (String)text + toAdd;
                }
                doc.atomicLock();
                try {
                    char ch;
                    String textToReplace = doc.getText(offset, len);
                    if (((String)text).equals(textToReplace)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!((String)text).startsWith("\"")) {
                        text = this.quoteText((String)text);
                    }
                    if ((ch = doc.getText(offset + len, 1).charAt(0)) == '\"') {
                        ++len;
                    }
                    if ((ch = doc.getText(offset - 1, 1).charAt(0)) == '\"') {
                        ++len;
                        --offset;
                    }
                    doc.remove(offset, len);
                    doc.insertString(offset, (String)text, null);
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    doc.atomicUnlock();
                }
                return true;
            }
            return false;
        }
    }

    public static final class PersistenceUnitElementItem
    extends DBElementItem {
        protected static CCPaintComponent.PersistenceUnitElementPaintComponent paintComponent = null;

        public PersistenceUnitElementItem(String name, boolean quote, int substituteOffset) {
            super(name, quote, substituteOffset);
        }

        @Override
        public String getTypeName() {
            return "Persistence Unit";
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.PersistenceUnitElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }
    }

    static abstract class DBElementItem
    extends JPACompletionItem {
        private String name;
        private boolean quote;
        protected static CCPaintComponent.DBElementPaintComponent paintComponent = null;

        public DBElementItem(String name, boolean quote, int substituteOffset) {
            this.name = name;
            this.quote = quote;
            this.substituteOffset = substituteOffset;
        }

        public DBElementItem(String name, boolean quote) {
            this(name, quote, -1);
        }

        protected String getName() {
            return this.name;
        }

        protected boolean getQuoted() {
            return this.quote;
        }

        @Override
        public String getItemText() {
            if (this.quote) {
                return this.quoteText(this.name);
            }
            return this.name;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.DBElementPaintComponent();
            }
            paintComponent.setString(this.getTypeName() + ": " + this.name);
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }

        public Object getAssociatedObject() {
            return this;
        }

        public abstract String getTypeName();
    }
}

