/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.Property;
import org.netbeans.modules.schema2beans.BaseBean;

public abstract class Provider {
    public static final String TABLE_GENERATION_CREATE = "tableGenerationCreate";
    public static final String TABLE_GENERATION_DROPCREATE = "tableGenerationDropCreate";
    public static final String TABLE_GENERATTION_UNKOWN = "tableGenerationUnknown";
    private final String providerClass;
    private final Set vendorSpecificProperties;
    private final String version;

    protected Provider(String providerClass) {
        this(providerClass, null);
    }

    protected Provider(String providerClass, String version) {
        assert (null != providerClass && !"".equals(providerClass.trim())) : "Provider class must be given!";
        this.providerClass = providerClass;
        this.version = version;
        this.vendorSpecificProperties = this.initPropertyNames();
    }

    public abstract String getDisplayName();

    public final String getProviderClass() {
        return this.providerClass;
    }

    public boolean isOnClassPath(ClassPath cp) {
        boolean ret;
        String classRelativePath = this.getProviderClass().replace('.', '/') + ".class";
        boolean bl = ret = cp.findResource(classRelativePath) != null;
        if (ret && this.version != null) {
            if ("3.1".equals(this.version)) {
                ret &= cp.findResource("jakarta/persistence/spi/TransformerException.class.class") != null;
            } else if ("3.0".equals(this.version)) {
                ret &= cp.findResource("jakarta/persistence/Entity.class") != null;
            } else if ("2.2".equals(this.version)) {
                ret &= cp.findResource("javax/persistence/TableGenerators.class") != null;
            } else if ("2.1".equals(this.version)) {
                ret &= cp.findResource("javax/persistence/criteria/CriteriaUpdate.class") != null;
            } else if ("2.0".equals(this.version)) {
                ret &= cp.findResource("javax/persistence/criteria/JoinType.class") != null;
            } else if ("1.0".equals(this.version)) {
                ret &= cp.findResource("javax/persistence/Entity.class") != null && cp.findResource("javax/persistence/criteria/JoinType.class") == null;
            }
        }
        return ret;
    }

    protected String getVersion() {
        return this.version;
    }

    protected boolean isJakartaNamespace() {
        return this.getVersion() != null && Float.parseFloat("2.2") < Float.parseFloat(this.getVersion());
    }

    private Set initPropertyNames() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getJdbcDriver());
        result.add(this.getJdbcUsername());
        result.add(this.getJdbcUrl());
        result.add(this.getJdbcPassword());
        result.add(this.getTableGenerationPropertyName());
        for (String propertyName : this.getUnresolvedVendorSpecificProperties().keySet()) {
            result.add(propertyName);
        }
        return result;
    }

    public Set getPropertyNames() {
        return this.vendorSpecificProperties;
    }

    public final org.netbeans.modules.j2ee.persistence.dd.common.Property getTableGenerationProperty(String strategy, String version) {
        if ("".equals(this.getTableGenerationPropertyName())) {
            return null;
        }
        BaseBean result = "3.1".equals(version) ? new Property() : ("3.0".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.Property() : ("2.2".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.Property() : ("2.1".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.Property() : ("2.0".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.Property() : new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Property()))));
        result.setName(this.getTableGenerationPropertyName());
        if (TABLE_GENERATION_CREATE.equals(strategy)) {
            result.setValue(this.getTableGenerationCreateValue());
        } else if (TABLE_GENERATION_DROPCREATE.equals(strategy)) {
            result.setValue(this.getTableGenerationDropCreateValue());
        } else {
            return null;
        }
        return result;
    }

    public final String getDefaultJtaDatasource() {
        return "jdbc/__default";
    }

    public String getJdbcUrl() {
        if (this.isJakartaNamespace()) {
            return "jakarta.persistence.jdbc.url";
        }
        return "javax.persistence.jdbc.url";
    }

    public String getJdbcDriver() {
        if (this.isJakartaNamespace()) {
            return "jakarta.persistence.jdbc.driver";
        }
        return "javax.persistence.jdbc.driver";
    }

    public String getJdbcUsername() {
        if (this.isJakartaNamespace()) {
            return "jakarta.persistence.jdbc.user";
        }
        return "javax.persistence.jdbc.user";
    }

    public String getJdbcPassword() {
        if (this.isJakartaNamespace()) {
            return "jakarta.persistence.jdbc.password";
        }
        return "javax.persistence.jdbc.password";
    }

    public String getAnnotationProcessor() {
        return null;
    }

    public String getAnnotationSubPackageProperty() {
        return null;
    }

    public String getTableGenerationPropertyName() {
        return "javax.persistence.schema-generation.database.action";
    }

    public String getTableGenerationCreateValue() {
        return "create";
    }

    public String getTableGenerationDropCreateValue() {
        return "drop-and-create";
    }

    public abstract Map getUnresolvedVendorSpecificProperties();

    public abstract Map getDefaultVendorSpecificProperties();

    public final Map<String, String> getConnectionPropertiesMap(DatabaseConnection connection, String version) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(this.getJdbcDriver(), connection != null ? connection.getDriverClass() : "");
        result.put(this.getJdbcUrl(), connection != null ? connection.getDatabaseURL() : "");
        result.put(this.getJdbcUsername(), connection != null ? connection.getUser() : "");
        result.put(this.getJdbcPassword(), connection != null && connection.getPassword() != null ? connection.getPassword() : "");
        return result;
    }

    public final boolean supportsTableGeneration() {
        return this.getTableGenerationPropertyName() != null && !"".equals(this.getTableGenerationPropertyName().trim());
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        return this.providerClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Provider)) {
            return false;
        }
        Provider that = (Provider)obj;
        boolean sameVersion = this.getVersion() != null && this.getVersion().equals(that.getVersion()) || this.getVersion() == null && that.getVersion() == null;
        return this.getClass().equals(that.getClass()) && this.providerClass.equals(that.providerClass) && sameVersion;
    }
}

