/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreatePersistenceUnit;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CreateTemporalAnnotationHint
implements Fix {
    private FileObject fileObject;
    private ElementHandle<Element> elementHandle;

    public CreateTemporalAnnotationHint(FileObject fileObject, ElementHandle<Element> elementHandle) {
        this.elementHandle = elementHandle;
        this.fileObject = fileObject;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                Element elem = CreateTemporalAnnotationHint.this.elementHandle.resolve((CompilationInfo)workingCopy);
                if (elem != null) {
                    Tree tree = workingCopy.getTrees().getTree(elem);
                    TreeMaker make = workingCopy.getTreeMaker();
                    ModifiersTree modifiersTree = null;
                    if (tree.getKind() == Tree.Kind.VARIABLE) {
                        modifiersTree = ((VariableTree)tree).getModifiers();
                    } else if (tree.getKind() == Tree.Kind.METHOD) {
                        modifiersTree = ((MethodTree)tree).getModifiers();
                    } else {
                        throw new IllegalStateException();
                    }
                    TypeElement temporalAnnType = workingCopy.getElements().getTypeElement("javax.persistence.Temporal");
                    ExpressionTree annType = make.QualIdent((Element)temporalAnnType);
                    AnnotationTree temporalAnn = make.Annotation((Tree)annType, Collections.singletonList(make.Identifier((CharSequence)"javax.persistence.TemporalType.DATE")));
                    ArrayList<? extends AnnotationTree> newAnnots = new ArrayList<AnnotationTree>();
                    newAnnots.addAll(modifiersTree.getAnnotations());
                    newAnnots.add(temporalAnn);
                    ModifiersTree newModifiers = make.Modifiers(modifiersTree, newAnnots);
                    workingCopy.rewrite((Tree)modifiersTree, (Tree)newModifiers);
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)task).commit();
        }
        catch (IOException e) {
            JPAProblemFinder.LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String getText() {
        return NbBundle.getMessage(CreatePersistenceUnit.class, (String)"LBL_CreateTemporalAnnotationHint");
    }
}

