/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.HashSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Id;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.IdClass;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class NoIdClassOnEntitySubclass {
    public static ErrorDescription apply(final HintContext hc) {
        Entity entity;
        if (hc.isCanceled() || hc.getPath().getLeaf().getKind() != Tree.Kind.IDENTIFIER || hc.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return null;
        }
        final JPAProblemContext ctx = ModelUtils.getOrCreateCachedContext(hc);
        if (ctx == null || hc.isCanceled()) {
            return null;
        }
        Entity entity2 = entity = ctx.getModelElement() instanceof Entity ? (Entity)ctx.getModelElement() : null;
        if (entity == null) {
            return null;
        }
        final TypeElement subject = ctx.getJavaClass();
        final ErrorDescription[] ret = new ErrorDescription[]{null};
        try {
            MetadataModel<EntityMappingsMetadata> model = ModelUtils.getModel(hc.getInfo().getFileObject());
            model.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

                public Void run(EntityMappingsMetadata metadata) {
                    TypeMirror superClassType;
                    IdClass idclass = entity.getIdClass();
                    if (idclass == null && (superClassType = subject.getSuperclass()).getKind() == TypeKind.DECLARED) {
                        TypeElement superClassElem = (TypeElement)((DeclaredType)superClassType).asElement();
                        Entity parentEntity = ModelUtils.getEntity(ctx.getMetaData(), superClassElem);
                        if (parentEntity != null) {
                            HashSet<String> parentEntityIds = new HashSet<String>(1);
                            for (Id id : parentEntity.getAttributes().getId()) {
                                parentEntityIds.add(id.getName());
                            }
                            for (Id id : entity.getAttributes().getId()) {
                                TreePath par;
                                if (parentEntityIds.contains(id.getName())) continue;
                                for (par = hc.getPath(); par != null && par.getParentPath() != null && par.getLeaf().getKind() != Tree.Kind.CLASS; par = par.getParentPath()) {
                                }
                                Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), par.getLeaf());
                                ret[0] = ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(NoIdClassOnEntitySubclass.class, (String)"MSG_EntitySubclassHasIdClass"), (Fix[])new Fix[0]);
                                return null;
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret[0];
    }
}

