/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;

public final class FileSearchUtility {
    private FileSearchUtility() {
    }

    public static Enumeration<FileObject> getChildrenToDepth(FileObject root, final int depth, final boolean onlyWritables) {
        class WithChildren
        implements Enumerations.Processor<FileObject, FileObject> {
            private int rootDepth;

            public WithChildren(int rootDepth) {
                this.rootDepth = rootDepth;
            }

            public FileObject process(FileObject fo, Collection<FileObject> toAdd) {
                if ((!onlyWritables || onlyWritables && fo.canWrite()) && fo.isFolder() && FileSearchUtility.getDepth(fo) - this.rootDepth < depth) {
                    toAdd.addAll(Arrays.asList(fo.getChildren()));
                }
                return fo;
            }
        }
        return Enumerations.queue((Enumeration)Enumerations.array((Object[])root.getChildren()), (Enumerations.Processor)new WithChildren(FileSearchUtility.getDepth(root)));
    }

    public static FileObject guessWebInf(FileObject dir) {
        Enumeration<FileObject> ch = FileSearchUtility.getChildrenToDepth(dir, 3, true);
        while (ch.hasMoreElements()) {
            FileObject webXmlFO;
            FileObject f = ch.nextElement();
            if (!f.isFolder() || (webXmlFO = f.getFileObject("web.xml")) == null || !webXmlFO.isData()) continue;
            return f;
        }
        return null;
    }

    public static FileObject guessDocBase(FileObject dir) {
        FileObject potentialDocBase = null;
        Enumeration<FileObject> ch = FileSearchUtility.getChildrenToDepth(dir, 3, true);
        while (ch.hasMoreElements()) {
            FileObject f = ch.nextElement();
            if (f.isData() && f.getExt().equals("jsp")) {
                return f.getParent();
            }
            if (!f.isFolder() || !f.getName().equalsIgnoreCase("web") && !f.getName().equalsIgnoreCase("webroot")) continue;
            potentialDocBase = f;
        }
        return potentialDocBase;
    }

    public static FileObject guessLibrariesFolder(FileObject dir) {
        FileObject lib;
        FileObject webInf = FileSearchUtility.guessWebInf(dir);
        if (webInf != null && (lib = webInf.getFileObject("lib")) != null) {
            return lib;
        }
        Enumeration<FileObject> ch = FileSearchUtility.getChildrenToDepth(dir, 3, true);
        while (ch.hasMoreElements()) {
            FileObject f = ch.nextElement();
            if (!f.getExt().equals("jar")) continue;
            return f.getParent();
        }
        return null;
    }

    public static FileObject[] guessJavaRoots(FileObject dir) {
        FileObject classes;
        FileObject webInf;
        ArrayList<FileObject> foundRoots = new ArrayList<FileObject>();
        if (null == dir) {
            return null;
        }
        Enumeration<FileObject> ch = FileSearchUtility.getChildrenToDepth(dir, 10, true);
        try {
            while (ch.hasMoreElements() && foundRoots.isEmpty()) {
                FileObject f = ch.nextElement();
                if (!f.getExt().equals("java") || f.isFolder()) continue;
                String pckg = FileSearchUtility.guessPackageName(f);
                String pkgPath = f.getParent().getPath();
                if (pckg == null || !pkgPath.endsWith(pckg.replace('.', '/'))) continue;
                String rootName = pkgPath.substring(0, pkgPath.length() - pckg.length());
                FileObject fr = f.getFileSystem().findResource(rootName);
                if (fr.getNameExt().equals("test") || foundRoots.contains(fr)) continue;
                foundRoots.add(fr);
            }
        }
        catch (FileStateInvalidException fsie) {
            Logger.getLogger("global").log(Level.INFO, null, fsie);
        }
        if (foundRoots.size() == 0 && (webInf = FileSearchUtility.guessWebInf(dir)) != null && (classes = webInf.getFileObject("classes")) != null) {
            foundRoots.add(classes);
        }
        if (foundRoots.size() == 0 && dir.getFileObject("src/java") != null) {
            foundRoots.add(dir.getFileObject("src/java"));
        }
        if (foundRoots.size() == 0) {
            return null;
        }
        FileObject[] resultArr = new FileObject[foundRoots.size()];
        for (int i = 0; i < foundRoots.size(); ++i) {
            resultArr[i] = (FileObject)foundRoots.get(i);
        }
        return resultArr;
    }

    public static File[] guessJavaRootsAsFiles(FileObject dir) {
        FileObject[] rootsFOs = FileSearchUtility.guessJavaRoots(dir);
        if (rootsFOs == null) {
            return new File[0];
        }
        File[] resultArr = new File[rootsFOs.length];
        for (int i = 0; i < resultArr.length; ++i) {
            resultArr[i] = FileUtil.toFile((FileObject)rootsFOs[i]);
        }
        return resultArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String guessPackageName(FileObject f) {
        Reader r = null;
        try {
            int idx2;
            int len;
            r = new BufferedReader(new InputStreamReader(f.getInputStream(), "utf-8"));
            StringBuffer sb = new StringBuffer();
            char[] buffer = new char[4096];
            while ((len = r.read(buffer)) != -1) {
                sb.append(buffer, 0, len);
            }
            int idx = sb.indexOf("package");
            if (idx >= 0 && (idx2 = sb.indexOf(";", idx)) >= 0) {
                String string = sb.substring(idx + "package".length(), idx2).trim();
                return string;
            }
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.INFO, null, ioe);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        return "";
    }

    private static int getDepth(FileObject fo) {
        String path = FileUtil.toFile((FileObject)fo).getAbsolutePath();
        StringTokenizer toker = new StringTokenizer(path, File.separator);
        return toker.countTokens();
    }

    public static FileObject guessConfigFilesPath(FileObject dir, String configFileName) {
        if (null == dir) {
            return null;
        }
        Enumeration<FileObject> ch = FileSearchUtility.getChildrenToDepth(dir, 3, true);
        try {
            while (ch.hasMoreElements()) {
                FileObject f = ch.nextElement();
                if (!f.getNameExt().equals(configFileName)) continue;
                String rootName = f.getParent().getPath();
                return f.getFileSystem().findResource(rootName);
            }
        }
        catch (FileStateInvalidException fsie) {
            Logger.getLogger("global").log(Level.INFO, null, fsie);
        }
        return null;
    }
}

