/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.EventListener;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

class MainClassUpdater
extends FileChangeAdapter
implements PropertyChangeListener {
    private static RequestProcessor RP = new RequestProcessor();
    private final Project project;
    private final PropertyEvaluator eval;
    private final UpdateHelper helper;
    private final ClassPath sourcePath;
    private final String mainClassPropName;
    private FileObject current;
    private FileChangeListener listener;

    public MainClassUpdater(Project project, PropertyEvaluator eval, UpdateHelper helper, ClassPath sourcePath, String mainClassPropName) {
        assert (project != null);
        assert (eval != null);
        assert (helper != null);
        assert (sourcePath != null);
        assert (mainClassPropName != null);
        this.project = project;
        this.eval = eval;
        this.helper = helper;
        this.sourcePath = sourcePath;
        this.mainClassPropName = mainClassPropName;
        this.eval.addPropertyChangeListener((PropertyChangeListener)this);
        this.addFileChangeListener();
    }

    public synchronized void unregister() {
        if (this.current != null && this.listener != null) {
            this.current.removeFileChangeListener(this.listener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.mainClassPropName.equals(evt.getPropertyName())) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    MainClassUpdater.this.addFileChangeListener();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileRenamed(FileRenameEvent evt) {
        FileObject _current;
        if (!this.project.getProjectDirectory().isValid()) {
            return;
        }
        MainClassUpdater mainClassUpdater = this;
        synchronized (mainClassUpdater) {
            _current = this.current;
        }
        if (evt.getFile() == _current) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        String oldMainClass = (String)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String>(){

                            public String run() throws Exception {
                                return MainClassUpdater.this.eval.getProperty(MainClassUpdater.this.mainClassPropName);
                            }
                        });
                        Collection main = SourceUtils.getMainClasses((FileObject)_current);
                        String newMainClass = null;
                        if (!main.isEmpty()) {
                            ElementHandle mainHandle = (ElementHandle)main.iterator().next();
                            newMainClass = mainHandle.getQualifiedName();
                        }
                        if (newMainClass != null && !newMainClass.equals(oldMainClass) && MainClassUpdater.this.helper.requestUpdate()) {
                            final String newMainClassFinal = newMainClass;
                            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                                public Void run() throws Exception {
                                    EditableProperties props = MainClassUpdater.this.helper.getProperties("nbproject/project.properties");
                                    props.put(MainClassUpdater.this.mainClassPropName, newMainClassFinal);
                                    MainClassUpdater.this.helper.putProperties("nbproject/project.properties", props);
                                    ProjectManager.getDefault().saveProject(MainClassUpdater.this.project);
                                    return null;
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                    catch (MutexException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileChangeListener() {
        MainClassUpdater mainClassUpdater = this;
        synchronized (mainClassUpdater) {
            if (this.current != null && this.listener != null) {
                this.current.removeFileChangeListener(this.listener);
                this.current = null;
                this.listener = null;
            }
        }
        final String mainClassName = this.eval.getProperty(this.mainClassPropName);
        if (mainClassName != null) {
            try {
                FileObject[] roots = this.sourcePath.getRoots();
                if (roots.length > 0) {
                    ClassPath bootCp = ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/boot");
                    ClassPath compileCp = ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/compile");
                    final ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)bootCp, (ClassPath)compileCp, (ClassPath)this.sourcePath);
                    JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
                    js.runWhenScanFinished((Task)new Task<CompilationController>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(CompilationController c) throws Exception {
                            TypeElement te = c.getElements().getTypeElement(mainClassName);
                            if (te != null) {
                                MainClassUpdater mainClassUpdater = MainClassUpdater.this;
                                synchronized (mainClassUpdater) {
                                    MainClassUpdater.this.current = SourceUtils.getFile((Element)te, (ClasspathInfo)cpInfo);
                                    MainClassUpdater.this.listener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)MainClassUpdater.this, (Object)MainClassUpdater.this.current);
                                    if (MainClassUpdater.this.current != null && MainClassUpdater.this.sourcePath.contains(MainClassUpdater.this.current)) {
                                        MainClassUpdater.this.current.addFileChangeListener(MainClassUpdater.this.listener);
                                    }
                                }
                            }
                        }
                    }, true);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

