/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FoDLayersProvider;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class FindComponentModules
extends Task {
    private static final RequestProcessor RP = new RequestProcessor("Find Modules");
    private final Collection<String> codeNames;
    private final FeatureInfo[] infos;
    public final String DO_CHECK = "do-check";
    private final String ENABLE_LATER = "enable-later";
    private final RequestProcessor.Task findingTask;
    private Collection<UpdateElement> forInstall;
    private Collection<UpdateElement> forEnable;
    private Map<FeatureInfo, Collection<FeatureInfo.ExtraModuleInfo>> incompleteFeatures = new HashMap<FeatureInfo, Collection<FeatureInfo.ExtraModuleInfo>>();
    private Map<String, FeatureInfo> codebaseOwners = new HashMap<String, FeatureInfo>();
    private Map<String, UpdateUnit> availUnits = null;
    private List<IOException> updateErrors = new ArrayList<IOException>();
    private Map<FeatureInfo.ExtraModuleInfo, FeatureInfo> extrasToDownload = new HashMap<FeatureInfo.ExtraModuleInfo, FeatureInfo>();
    private boolean downloadRequired;
    private Set<FeatureInfo.ExtraModuleInfo> filter;
    private final SpecificationVersion jdk = new SpecificationVersion(System.getProperty("java.specification.version"));
    private Runnable doFind = new Runnable(){

        @Override
        public void run() {
            FindComponentModules.this.findComponentModules();
        }
    };

    public FindComponentModules(FeatureInfo info, FeatureInfo ... additional) {
        this(info, Collections.emptySet(), additional);
    }

    public FindComponentModules(FeatureInfo info, Set<FeatureInfo.ExtraModuleInfo> filter, FeatureInfo ... additional) {
        this.filter = filter;
        ArrayList<FeatureInfo> l = new ArrayList<FeatureInfo>();
        l.add(info);
        l.addAll(Arrays.asList(additional));
        this.infos = l.toArray(new FeatureInfo[0]);
        if (this.infos.length == 1) {
            this.codeNames = info.getCodeNames();
        } else {
            this.codeNames = new HashSet<String>(info.getCodeNames());
            for (FeatureInfo fi : additional) {
                this.codeNames.addAll(fi.getCodeNames());
            }
        }
        this.findingTask = RP.post(this.doFind);
    }

    public Collection<UpdateElement> getModulesForInstall() {
        this.findingTask.waitFinished();
        return this.forInstall == null ? Collections.emptyList() : this.forInstall;
    }

    public Collection<UpdateElement> getModulesForEnable() {
        this.findingTask.waitFinished();
        return this.forEnable == null ? Collections.emptyList() : this.forEnable;
    }

    public Collection<FeatureInfo> getIncompleteFeatures() {
        this.findingTask.waitFinished();
        return this.incompleteFeatures.keySet();
    }

    void markIncompleteFeature(FeatureInfo fi, FeatureInfo.ExtraModuleInfo moduleInfo) {
        this.incompleteFeatures.computeIfAbsent(fi, f -> new HashSet()).add(moduleInfo);
    }

    public Collection<FeatureInfo.ExtraModuleInfo> getMissingModules(FeatureInfo info) {
        return this.incompleteFeatures.getOrDefault(info, Collections.emptyList());
    }

    public Collection<IOException> getUpdateErrors() {
        return this.updateErrors;
    }

    public void onFinished(final TaskListener l) {
        this.findingTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                l.taskFinished((Task)FindComponentModules.this);
            }
        });
    }

    public void writeEnableLater(Collection<UpdateElement> modules) {
        Preferences pref = FindComponentModules.getPreferences();
        if (modules == null) {
            pref.remove("enable-later");
            return;
        }
        String value = "";
        for (UpdateElement m : modules) {
            value = value + (value.length() == 0 ? m.getCodeName() : ", " + m.getCodeName());
        }
        if (value.trim().length() == 0) {
            pref.remove("enable-later");
        } else {
            pref.put("enable-later", value);
        }
    }

    private Set<String> clusterClosure(Collection<UpdateElement> all) {
        HashSet<String> closure = new HashSet<String>();
        for (UpdateElement ue : all) {
            for (FeatureInfo featureInfo : FeatureManager.features()) {
                if (!featureInfo.getCodeNames().contains(ue.getCodeName())) continue;
                closure.addAll(featureInfo.getCodeNames());
            }
        }
        return closure;
    }

    private Collection<UpdateElement> readEnableLater() {
        HashSet<UpdateElement> res = new HashSet<UpdateElement>();
        Preferences pref = FindComponentModules.getPreferences();
        String value = pref.get("enable-later", null);
        if (value != null && value.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreElements()) {
                String codeName = st.nextToken().trim();
                UpdateElement el = FindComponentModules.findUpdateElement(codeName, true);
                if (el == null) continue;
                res.add(el);
            }
        }
        return res;
    }

    public Collection<UpdateElement> getVisibleUpdateElements(Collection<UpdateElement> elems) {
        String prefCNB = this.infos[0].getPreferredCodeNameBase();
        HashSet<UpdateElement> res = new HashSet<UpdateElement>();
        for (UpdateElement el : new LinkedList<UpdateElement>(elems)) {
            if (UpdateManager.TYPE.KIT_MODULE.equals((Object)el.getUpdateUnit().getType())) {
                res.add(el);
            }
            if (!el.getUpdateUnit().getCodeName().equals(prefCNB)) continue;
            return Collections.singleton(el);
        }
        if (res.size() > 1) {
            FoDLayersProvider.LOG.warning("No prefCNB found " + prefCNB + " using multiple " + res);
        }
        return res;
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(FindComponentModules.class);
    }

    private void buildCodebaseIndex() {
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            for (String cnb : featureInfo.getCodeNames()) {
                this.codebaseOwners.put(cnb, featureInfo);
            }
        }
    }

    private void buildUpdateUnitIndex() {
        if (this.availUnits != null) {
            return;
        }
        List units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        HashMap<String, UpdateUnit> uumap = new HashMap<String, UpdateUnit>();
        for (UpdateUnit u : units) {
            uumap.put(u.getCodeName(), u);
        }
        this.availUnits = uumap;
    }

    private void findComponentModules() {
        long start = System.currentTimeMillis();
        List units = null;
        Collection<UpdateElement> elementsForInstall = null;
        this.buildCodebaseIndex();
        int[] refresh = new int[]{2};
        while (refresh[0] > 0) {
            if (units != null) {
                List providers = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true);
                for (UpdateUnitProvider p : providers) {
                    try {
                        p.refresh(null, true);
                    }
                    catch (IOException ex) {
                        this.updateErrors.add(ex);
                        ((IOException)Exceptions.attachSeverity((Throwable)ex, (Level)Level.INFO)).printStackTrace();
                    }
                }
                this.availUnits = null;
            }
            this.buildUpdateUnitIndex();
            units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
            elementsForInstall = this.getMissingModules(units, refresh);
        }
        this.forInstall = this.getAllForInstall(elementsForInstall);
        Collection<UpdateElement> elementsForEnable = this.getDisabledModules(units);
        this.forEnable = this.getAllForEnable(elementsForEnable, units);
    }

    public Map<FeatureInfo.ExtraModuleInfo, FeatureInfo> getExtrasToDownload() {
        return this.extrasToDownload;
    }

    private void registerExtraDownloadable(FeatureInfo fi, FeatureInfo.ExtraModuleInfo fmi) {
        boolean required = false;
        if (fmi.isRequiredFor(this.jdk)) {
            // empty if block
        }
        if (fi.getExtraModulesRequiredText() != null && fi.getExtraModulesRecommendedText() == null) {
            required = true;
        }
        this.downloadRequired |= required;
        this.extrasToDownload.put(fmi, fi);
    }

    public boolean isDownloadRequired() {
        this.findingTask.waitFinished();
        return this.downloadRequired;
    }

    private Collection<UpdateElement> getMissingModules(Collection<UpdateUnit> allUnits, int[] refresh) {
        HashSet<UpdateElement> res = new HashSet<UpdateElement>();
        for (UpdateUnit unit : allUnits) {
            if (unit.getInstalled() != null || !this.codeNames.contains(unit.getCodeName())) continue;
            res.add((UpdateElement)unit.getAvailableUpdates().get(0));
        }
        boolean decr = true;
        HashSet<String> codebasesSeen = new HashSet<String>();
        OperationContainer ocForEnable = OperationContainer.createForEnable();
        OperationContainer ocForInstall = OperationContainer.createForInstall();
        boolean firstPass = true;
        for (FeatureInfo startFi : this.infos) {
            ArrayDeque<FeatureInfo> closure = new ArrayDeque<FeatureInfo>();
            closure.add(startFi);
            codebasesSeen.add(startFi.getFeatureCodeNameBase());
            while (!closure.isEmpty()) {
                FeatureInfo fi = (FeatureInfo)closure.poll();
                Set<FeatureInfo.ExtraModuleInfo> extraModules = this.filter;
                if (this.filter.isEmpty()) {
                    extraModules = fi.getExtraModules();
                }
                block3: for (FeatureInfo.ExtraModuleInfo moduleInfo : extraModules) {
                    boolean found = false;
                    for (UpdateUnit unit : allUnits) {
                        if (!moduleInfo.matches(unit.getCodeName())) continue;
                        if (unit.getInstalled() != null) continue block3;
                        if (unit.getAvailableUpdates().isEmpty()) continue;
                        this.registerExtraDownloadable(fi, moduleInfo);
                        res.add((UpdateElement)unit.getAvailableUpdates().get(0));
                        found = true;
                    }
                    if (found) continue;
                    if (decr) {
                        refresh[0] = refresh[0] - 1;
                        if (refresh[0] > 0) {
                            return res;
                        }
                        decr = false;
                    }
                    this.markIncompleteFeature(fi, moduleInfo);
                    this.markIncompleteFeature(startFi, moduleInfo);
                    this.registerExtraDownloadable(fi, moduleInfo);
                }
                if (!firstPass) continue;
                for (String cb : fi.getCodeNames()) {
                    OperationContainer.OperationInfo thisInfo;
                    UpdateUnit cbuu = this.availUnits.get(cb);
                    if (cbuu == null) continue;
                    UpdateElement cbel = cbuu.getInstalled();
                    if (cbel != null && ocForEnable.canBeAdded(cbuu, cbel)) {
                        thisInfo = ocForEnable.add(cbuu, cbel);
                    } else {
                        if (cbuu.getAvailableUpdates().isEmpty()) {
                            if (!decr) continue;
                            refresh[0] = refresh[0] - 1;
                            if (refresh[0] > 0) {
                                return res;
                            }
                            decr = false;
                            continue;
                        }
                        UpdateElement ie = (UpdateElement)cbuu.getAvailableUpdates().get(0);
                        if (!ocForInstall.canBeAdded(cbuu, ie)) continue;
                        thisInfo = ocForInstall.add(cbuu, ie);
                    }
                    Set deps = thisInfo.getRequiredElements();
                    for (UpdateElement d : deps) {
                        FeatureInfo depF;
                        UpdateUnit du = d.getUpdateUnit();
                        if (du.getInstalled() == null) {
                            res.add(d);
                        }
                        if ((depF = this.codebaseOwners.get(du.getCodeName())) == null || !codebasesSeen.add(depF.getFeatureCodeNameBase())) continue;
                        closure.add(depF);
                    }
                }
                firstPass = false;
            }
        }
        refresh[0] = 0;
        return res;
    }

    private Collection<UpdateElement> getAllForInstall(Collection<UpdateElement> elements) {
        HashSet<UpdateElement> all = new HashSet<UpdateElement>();
        for (UpdateElement el : elements) {
            OperationContainer.OperationInfo info;
            OperationContainer ocForInstall = OperationContainer.createForInstall();
            if (!ocForInstall.canBeAdded(el.getUpdateUnit(), el) || (info = ocForInstall.add(el)) == null) continue;
            Set reqs = info.getRequiredElements();
            ocForInstall.add((Collection)reqs);
            Set breaks = info.getBrokenDependencies();
            if (!breaks.isEmpty()) continue;
            all.add(el);
            all.addAll(reqs);
        }
        return all;
    }

    private Collection<UpdateElement> getDisabledModules(Collection<UpdateUnit> allUnits) {
        HashSet<UpdateElement> res = new HashSet<UpdateElement>();
        for (UpdateUnit unit : allUnits) {
            if (unit.getInstalled() == null || !this.codeNames.contains(unit.getCodeName()) || unit.getInstalled().isEnabled()) continue;
            res.add(unit.getInstalled());
        }
        return res;
    }

    private Collection<UpdateElement> getAllForEnable(Collection<UpdateElement> elements, Collection<UpdateUnit> units) {
        Collection<UpdateElement> toAdd = elements;
        HashSet<UpdateElement> all = new HashSet<UpdateElement>();
        HashSet<String> ignore = new HashSet<String>();
        OperationContainer ocForEnable = OperationContainer.createForEnable();
        while (!toAdd.isEmpty()) {
            for (UpdateElement el : toAdd) {
                if (el == null) continue;
                if (ocForEnable.canBeAdded(el.getUpdateUnit(), el)) {
                    OperationContainer.OperationInfo inf = ocForEnable.add(el);
                    if (inf == null) continue;
                    Set reqs = inf.getRequiredElements();
                    for (UpdateElement ue : reqs) {
                        if (!ocForEnable.canBeAdded(ue.getUpdateUnit(), ue)) continue;
                        ocForEnable.add(ue.getUpdateUnit(), ue);
                    }
                    all.add(el);
                    all.addAll(reqs);
                    continue;
                }
                ignore.add(el.getCodeName());
            }
            Set<String> clusterClosure = this.clusterClosure(all);
            for (UpdateElement el : all) {
                clusterClosure.remove(el.getCodeName());
            }
            clusterClosure.removeAll(ignore);
            if (clusterClosure.isEmpty()) break;
            toAdd = new HashSet<UpdateElement>();
            for (UpdateUnit uu : units) {
                if (!clusterClosure.contains(uu.getCodeName())) continue;
                toAdd.add(uu.getInstalled());
            }
        }
        return all;
    }

    private static UpdateElement findUpdateElement(String codeName, boolean isInstalled) {
        UpdateElement res = null;
        for (UpdateUnit u : UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
            if (!codeName.equals(u.getCodeName())) continue;
            if (isInstalled && u.getInstalled() != null) {
                res = u.getInstalled();
                break;
            }
            if (isInstalled || u.getAvailableUpdates().isEmpty()) break;
            res = (UpdateElement)u.getAvailableUpdates().get(0);
            break;
        }
        return res;
    }
}

