/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.ui.OpenableInBrowser;
import org.netbeans.modules.hudson.ui.actions.LogInAction;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.actions.ProjectAssociationAction;
import org.netbeans.modules.hudson.ui.actions.StartJobAction;
import org.netbeans.modules.hudson.ui.actions.ViewConfigAction;
import org.netbeans.modules.hudson.ui.nodes.Bundle;
import org.netbeans.modules.hudson.ui.nodes.HudsonJobBuildNode;
import org.netbeans.modules.hudson.ui.nodes.HudsonWorkspaceNode;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class HudsonJobNode
extends AbstractNode {
    private String htmlDisplayName;
    private HudsonJob job;
    private PropertyChangeListener watchedListener;
    private Sheet.Set set;

    public HudsonJobNode(HudsonJob job) {
        super(HudsonJobNode.makeChildren(job), Lookups.singleton((Object)job));
        this.setName(job.getName());
        this.setHudsonJob(job);
        this.setWatchedListener();
    }

    private static Children makeChildren(final HudsonJob job) {
        if (job.getColor() == HudsonJob.Color.secured) {
            return Children.LEAF;
        }
        return Children.create((ChildFactory)new ChildFactory<Object>(){
            final Object WORKSPACE = new Object();

            protected boolean createKeys(List<Object> toPopulate) {
                if (job.getRemoteWorkspace() != null) {
                    toPopulate.add(this.WORKSPACE);
                }
                for (HudsonJobBuild b : job.getBuilds()) {
                    b.getResult();
                    toPopulate.add(b);
                }
                return true;
            }

            protected Node createNodeForKey(Object key) {
                if (key == this.WORKSPACE) {
                    return new HudsonWorkspaceNode(job);
                }
                return new HudsonJobBuildNode((HudsonJobBuild)key);
            }
        }, (boolean)true);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Action[] getActions(boolean context) {
        if (this.job.getColor() == HudsonJob.Color.secured) {
            return new Action[]{new LogInAction(this.job.getInstance())};
        }
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(SystemAction.get(StartJobAction.class));
        actions.add(new ProjectAssociationAction(this.job));
        actions.add(null);
        if (this.job instanceof OpenableInBrowser) {
            actions.add(OpenUrlAction.forOpenable((OpenableInBrowser)this.job));
        }
        actions.add(new ViewConfigAction(this.job));
        actions.add(SystemAction.get(PropertiesAction.class));
        return actions.toArray(new Action[actions.size()]);
    }

    protected Sheet createSheet() {
        Sheet s = super.createSheet();
        s.put(this.getSheetSet());
        return s;
    }

    private Sheet.Set getSheetSet() {
        if (null == this.set) {
            this.set = Sheet.createPropertiesSet();
            this.set.setDisplayName(this.getDisplayName());
            this.set.put(new Node.Property[]{new PropertySupport<String>("job_name", String.class, Bundle.TXT_Job_Prop_Name(), Bundle.DESC_Job_Prop_Name(), true, false){

                public String getValue() {
                    return HudsonJobNode.this.job.getName();
                }

                public void setValue(String val) {
                }
            }, new PropertySupport<String>("job_url", String.class, Bundle.TXT_Job_Prop_Url(), Bundle.DESC_Job_Prop_Url(), true, false){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return HudsonJobNode.this.job.getUrl();
                }

                public void setValue(String val) {
                }
            }, new PropertySupport.ReadWrite<Boolean>("salient", Boolean.TYPE, Bundle.HudsonJobImpl_watched(), Bundle.HudsonJobImpl_watched_desc()){

                public Boolean getValue() {
                    return HudsonJobNode.this.job.isSalient();
                }

                public void setValue(Boolean val) {
                    if (!this.getValue().equals(val)) {
                        HudsonJobNode.this.job.setSalient(val.booleanValue());
                    }
                }
            }});
        }
        return this.set;
    }

    private void setWatchedListener() {
        this.watchedListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String pn = evt.getPropertyName();
                if (pn.equals("suppressed_jobs") || pn.equals("pref_jobs")) {
                    HudsonJobNode.this.setHudsonJob(HudsonJobNode.this.job);
                }
            }
        };
        this.job.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.watchedListener, (Object)this.job.getInstance()));
    }

    private void setHudsonJob(HudsonJob job) {
        this.job = job;
        HudsonJob.Color color = job.getColor();
        this.setShortDescription(job.getUrl());
        this.setIconBaseWithExtension(color.iconBase());
        String oldHtmlDisplayName = this.getHtmlDisplayName();
        try {
            String escapedName = XMLUtil.toElementContent((String)job.getDisplayName());
            this.htmlDisplayName = job.isSalient() ? color.colorizeDisplayName(escapedName) : this.toGray(escapedName);
        }
        catch (CharConversionException ex) {
            assert (false) : ex;
            return;
        }
        if (!job.isSalient()) {
            this.htmlDisplayName = this.htmlDisplayName + this.toGrayWithSpace(Bundle.HudsonJobNode_not_watched());
        }
        if (color.isRunning()) {
            this.htmlDisplayName = this.htmlDisplayName + this.toGrayWithSpace(Bundle.HudsonJobNode_running());
        }
        if (color == HudsonJob.Color.secured) {
            this.htmlDisplayName = this.htmlDisplayName + this.toGrayWithSpace(Bundle.HudsonJobNode_secured());
        }
        if (job.isInQueue()) {
            this.htmlDisplayName = this.htmlDisplayName + this.toGrayWithSpace(Bundle.HudsonJobNode_in_queue());
        }
        this.fireDisplayNameChange(oldHtmlDisplayName, this.htmlDisplayName);
    }

    private String toGray(String text) {
        return "<font color='!controlShadow'>" + text + "</font>";
    }

    private String toGrayWithSpace(String text) {
        return " " + this.toGray(text);
    }
}

