/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelProvider;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.NamedCharRef;
import org.netbeans.modules.html.parser.model.ElementDescriptor;
import org.netbeans.modules.html.parser.model.HtmlTagProvider;
import org.netbeans.modules.html.parser.model.NamedCharacterReference;

public final class Html5Model
implements HtmlModel,
HtmlModelProvider {
    private static Collection<HtmlTag> ALL_TAGS;

    public HtmlModel getModel(HtmlVersion version) {
        switch (version) {
            case HTML5: 
            case XHTML5: {
                return this;
            }
        }
        return null;
    }

    public synchronized Collection<HtmlTag> getAllTags() {
        if (ALL_TAGS == null) {
            ALL_TAGS = new ArrayList<HtmlTag>();
            for (ElementDescriptor element : ElementDescriptor.values()) {
                ALL_TAGS.add(HtmlTagProvider.forElementDescriptor(element));
            }
        }
        return Collections.unmodifiableCollection(ALL_TAGS);
    }

    public HtmlTag getTag(String tagName) {
        return HtmlTagProvider.getTagForElement(tagName);
    }

    public Collection<? extends NamedCharRef> getNamedCharacterReferences() {
        return EnumSet.allOf(NamedCharacterReference.class);
    }

    @Deprecated
    public String getModelId() {
        return null;
    }
}

