/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.ojet.data;

import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;

public class OJETPreferences {
    private static final String DEFAULT_VALUE = "";
    public static final Property<String> VERSION = new Property<String>("ojet_version"){

        @Override
        public String getDefaultValue() {
            return "2.0.0";
        }
    };

    public static String get(Project project, Property<? extends Object> property) {
        if (project == null) {
            return null;
        }
        Preferences preferences = OJETPreferences.getPreferences(project);
        String value = preferences.get(property.getKey(), DEFAULT_VALUE);
        if (DEFAULT_VALUE.equals(value)) {
            Object defaultValue = property.getDefaultValue();
            if (defaultValue == null) {
                return null;
            }
            return defaultValue.toString();
        }
        if (!OJETPreferences.hasText(value)) {
            return null;
        }
        return value;
    }

    public static void put(Project project, Property<? extends Object> property, String value) {
        if (project != null) {
            if (OJETPreferences.hasText(value) && !value.equals(property.getDefaultValue())) {
                OJETPreferences.getPreferences(project).put(property.getKey(), value);
            } else {
                OJETPreferences.getPreferences(project).remove(property.getKey());
            }
        }
    }

    private static Preferences getPreferences(Project project) {
        return ProjectUtils.getPreferences((Project)project, OJETPreferences.class, (boolean)true);
    }

    private static boolean hasText(String input) {
        return input != null && !input.trim().isEmpty();
    }

    public static class Property<T> {
        private final String key;

        private Property(String key) {
            assert (key != null);
            this.key = key;
        }

        String getKey() {
            return this.key;
        }

        public T getDefaultValue() {
            return null;
        }
    }
}

