/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.gsf.testrunner.ui.annotation.TestMethodAnnotation;
import org.netbeans.spi.project.SingleMethod;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;

public class TestMethodController {
    public static void setTestMethods(Document doc, List<TestMethod> methods) {
        StyledDocument sdoc = (StyledDocument)doc;
        NbDocument.runAtomic((StyledDocument)sdoc, () -> TestMethodController.setTestMethodsImpl(sdoc, methods));
    }

    private static void setTestMethodsImpl(StyledDocument doc, List<TestMethod> methods) {
        HashMap<Integer, TestMethod> annotationLines;
        doc.putProperty(TestMethodAnnotation.DOCUMENT_METHODS_KEY, methods);
        HashMap<TestMethod, TestMethodAnnotation> annotations = (HashMap<TestMethod, TestMethodAnnotation>)doc.getProperty(TestMethodAnnotation.DOCUMENT_ANNOTATIONS_KEY);
        if (annotations == null) {
            annotations = new HashMap<TestMethod, TestMethodAnnotation>();
            doc.putProperty(TestMethodAnnotation.DOCUMENT_ANNOTATIONS_KEY, annotations);
        }
        if ((annotationLines = (HashMap<Integer, TestMethod>)doc.getProperty(TestMethodAnnotation.DOCUMENT_ANNOTATION_LINES_KEY)) == null) {
            annotationLines = new HashMap<Integer, TestMethod>();
            doc.putProperty(TestMethodAnnotation.DOCUMENT_ANNOTATION_LINES_KEY, annotationLines);
        }
        HashSet<TestMethod> added = new HashSet<TestMethod>(methods);
        HashMap removed = new HashMap(annotations);
        removed.keySet().removeAll(added);
        added.removeAll(annotations.keySet());
        for (TestMethod testMethod : added) {
            TestMethodAnnotation a = new TestMethodAnnotation(testMethod);
            NbDocument.addAnnotation((StyledDocument)doc, (Position)testMethod.preferred, (int)0, (Annotation)a);
            annotations.put(testMethod, a);
            int line = NbDocument.findLineNumber((StyledDocument)doc, (int)testMethod.preferred.getOffset());
            annotationLines.put(line, testMethod);
        }
        for (Map.Entry entry : removed.entrySet()) {
            NbDocument.removeAnnotation((StyledDocument)doc, (Annotation)((Annotation)entry.getValue()));
            annotations.remove(entry.getKey());
            int line = NbDocument.findLineNumber((StyledDocument)doc, (int)((TestMethod)entry.getKey()).preferred.getOffset());
            annotationLines.remove(line);
        }
    }

    public static final class TestMethod {
        private final String testClassName;
        private final Position testClassPosition;
        private final SingleMethod method;
        private final Position start;
        private final Position preferred;
        private final Position end;

        public TestMethod(SingleMethod method, Position start, Position end) {
            this("", method, start, end);
        }

        public TestMethod(String testClassName, SingleMethod method, Position start, Position end) {
            this(testClassName, method, start, start, end);
        }

        public TestMethod(String testClassName, SingleMethod method, Position start, Position preferred, Position end) {
            this(testClassName, null, method, start, preferred, end);
        }

        public TestMethod(String testClassName, Position testClassPosition, SingleMethod method, Position start, Position preferred, Position end) {
            this.testClassName = testClassName;
            this.testClassPosition = testClassPosition;
            this.method = method;
            this.start = start;
            this.preferred = preferred;
            this.end = end;
        }

        public String getTestClassName() {
            return this.testClassName;
        }

        public Position getTestClassPosition() {
            return this.testClassPosition;
        }

        public SingleMethod method() {
            return this.method;
        }

        public Position start() {
            return this.start;
        }

        public Position preferred() {
            return this.preferred;
        }

        public Position end() {
            return this.end;
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.testClassName);
            hash = 97 * hash + Objects.hashCode(this.method);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestMethod other = (TestMethod)obj;
            if (!Objects.equals(this.testClassName, other.testClassName)) {
                return false;
            }
            if (!Objects.equals(this.method, other.method)) {
                return false;
            }
            return Objects.equals(this.preferred.getOffset(), other.preferred.getOffset());
        }
    }
}

