/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.netbeans.modules.gsf.testrunner.ui.Bundle;
import org.netbeans.modules.gsf.testrunner.ui.api.TestCreatorPanelDisplayer;
import org.netbeans.modules.gsf.testrunner.ui.api.UICommonUtils;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class TestCreatorAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(TestCreatorAction.class.getName());

    public TestCreatorAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(TestCreatorAction.class, (String)"LBL_CreateCommonTestAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        FileObject[] activatedFOs;
        if (activatedNodes.length == 0) {
            return false;
        }
        if (activatedNodes.length == 1) {
            FileObject fo = UICommonUtils.getFileObjectFromNode(activatedNodes[0]);
            if (fo == null) {
                return false;
            }
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            if (p == null) {
                return false;
            }
            if (p.getProjectDirectory().equals(fo) && !ProjectUtils.getInformation((Project)p).getDisplayName().equals(activatedNodes[0].getDisplayName())) {
                return false;
            }
        }
        if ((activatedFOs = UICommonUtils.getFileObjectsFromNodes(activatedNodes)) == null) {
            LOGGER.log(Level.FINE, "{0}", Bundle.MSG_no_FOs_from_Nodes());
            return false;
        }
        Collection providers = Lookup.getDefault().lookupResult(TestCreatorProvider.class).allItems();
        for (Lookup.Item provider : providers) {
            boolean enable = ((TestCreatorProvider)provider.getInstance()).enable(activatedFOs);
            if (!enable) continue;
            return true;
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        TestCreatorPanelDisplayer.getDefault().displayPanel(UICommonUtils.getFileObjectsFromNodes(activatedNodes), null, null);
    }
}

