/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;
import org.netbeans.modules.gsf.testrunner.ui.api.TestsuiteNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;

final class RootNodeChildren
extends ChildFactory<TestsuiteNode> {
    private volatile int filterMask;
    private Collection<Report> reports;
    private volatile int passedSuites;
    private volatile int failedSuites;
    private String runningSuiteName;
    private TestsuiteNode runningSuiteNode;
    private final TestSession session;
    private final List<TestsuiteNode> suiteNodes;

    RootNodeChildren(TestSession session, int filterMask) {
        this.filterMask = filterMask;
        this.session = session;
        this.suiteNodes = Collections.synchronizedList(new ArrayList());
        this.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createKeys(List<TestsuiteNode> toPopulate) {
        List<TestsuiteNode> list = this.suiteNodes;
        synchronized (list) {
            for (TestsuiteNode suite : this.suiteNodes) {
                Report report = suite.getReport();
                if (report == null || this.isMaskApplied(report, this.filterMask)) continue;
                toPopulate.add(suite);
            }
        }
        return true;
    }

    protected Node createNodeForKey(TestsuiteNode suite) {
        Report report = suite.getReport();
        if (suite != this.runningSuiteNode && report != null && this.isMaskApplied(report, this.filterMask)) {
            return null;
        }
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTestSuiteFinished() {
        List<TestsuiteNode> list = this.suiteNodes;
        synchronized (list) {
            if (this.suiteNodes.size() > 0) {
                this.suiteNodes.get(this.suiteNodes.size() - 1).notifyTestSuiteFinished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNewRunningSuite() {
        List<TestsuiteNode> list = this.suiteNodes;
        synchronized (list) {
            for (TestsuiteNode node : this.suiteNodes) {
                if (!node.getDisplayName().equals(this.runningSuiteName)) continue;
                return false;
            }
        }
        return true;
    }

    void displaySuiteRunning(String suiteName) {
        assert (EventQueue.isDispatchThread());
        this.runningSuiteName = suiteName;
        this.maybeInitializeNewSuiteNode(null);
        this.refresh(false);
    }

    void displaySuiteRunning(TestSuite suite) {
        assert (EventQueue.isDispatchThread());
        this.runningSuiteName = suite.getName();
        this.maybeInitializeNewSuiteNode(suite);
        this.refresh(false);
    }

    Collection<Report> getReports() {
        return this.reports;
    }

    public TestsuiteNode displayReport(Report report) {
        TestsuiteNode correspondingNode;
        assert (EventQueue.isDispatchThread());
        if (this.reports == null) {
            this.reports = new ArrayList<Report>(10);
        }
        if (!this.reports.contains(report)) {
            this.reports.add(report);
        }
        this.updateStatistics(report);
        if (this.runningSuiteNode != null) {
            if (report.isCompleted() || !this.isMaskApplied(report, this.filterMask)) {
                this.runningSuiteNode.displayReport(report);
            }
            if (report.isCompleted() && this.isMaskApplied(report, this.filterMask)) {
                this.runningSuiteNode = null;
            }
            correspondingNode = this.runningSuiteNode;
        } else {
            correspondingNode = !report.isCompleted() || !this.isMaskApplied(report, this.filterMask) ? this.getNode(report) : null;
        }
        if (report.isCompleted()) {
            this.runningSuiteName = null;
            this.runningSuiteNode = null;
        }
        this.refresh(false);
        return correspondingNode;
    }

    void displayReports(Collection<Report> newReports) {
        assert (EventQueue.isDispatchThread());
        if (this.reports == null) {
            this.reports = new ArrayList<Report>(newReports);
        } else {
            this.reports.addAll(newReports);
        }
        if (this.runningSuiteNode == null) {
            for (Report report : this.reports) {
                this.updateStatistics(report);
            }
        } else if (this.filterMask == 0) {
            Node[] nodesToAdd = new Node[newReports.size()];
            int index = 0;
            for (Report report : newReports) {
                this.updateStatistics(report);
                nodesToAdd[index++] = this.getNode(report);
            }
        } else {
            ArrayList<TestsuiteNode> toAdd = new ArrayList<TestsuiteNode>(newReports.size());
            for (Report report : newReports) {
                boolean isFailed = !this.updateStatistics(report);
                if (!isFailed) continue;
                toAdd.add(this.getNode(report));
            }
            if (!toAdd.isEmpty()) {
                Node[] nodeArray = toAdd.toArray(new Node[toAdd.size()]);
            }
        }
        this.refresh(false);
    }

    private boolean updateStatistics(Report report) {
        this.passedSuites = 0;
        this.failedSuites = 0;
        for (Report rep : this.reports) {
            boolean isPassedSuite;
            boolean bl = isPassedSuite = !rep.containsFailed();
            if (isPassedSuite) {
                ++this.passedSuites;
                continue;
            }
            ++this.failedSuites;
        }
        return !report.containsFailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestsuiteNode getNode(Report report) {
        List<TestsuiteNode> list = this.suiteNodes;
        synchronized (list) {
            for (TestsuiteNode node : this.suiteNodes) {
                if (node.getReport() != null && node.getReport() != report) continue;
                return node;
            }
        }
        TestsuiteNode node = new TestsuiteNode(report, this.filterMask != 0);
        node.setFilterMask(this.filterMask);
        this.notifyTestSuiteFinished();
        this.suiteNodes.add(node);
        return node;
    }

    private void maybeInitializeNewSuiteNode(TestSuite suite) {
        if (this.isNewRunningSuite()) {
            this.runningSuiteNode = Manager.getInstance().getNodeFactory().createTestSuiteNode(this.runningSuiteName, this.filterMask != 0);
            this.runningSuiteNode.setFilterMask(this.filterMask);
            this.runningSuiteNode.setSuite(suite);
            this.notifyTestSuiteFinished();
            this.suiteNodes.add(this.runningSuiteNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFilterMask(int filterMask) {
        assert (EventQueue.isDispatchThread());
        if (filterMask == this.filterMask) {
            return;
        }
        this.filterMask = filterMask;
        if (this.reports == null) {
            return;
        }
        List<TestsuiteNode> list = this.suiteNodes;
        synchronized (list) {
            for (TestsuiteNode suite : this.suiteNodes) {
                suite.setFilterMask(filterMask);
                this.refresh(false);
            }
        }
    }

    private boolean isMaskApplied(Report report, int mask) {
        return (report.getStatusMask() & ~mask) == 0;
    }
}

