/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.modules.glassfish.tooling.GlassFishIdeException;
import org.netbeans.modules.glassfish.tooling.admin.Command;
import org.netbeans.modules.glassfish.tooling.admin.ResultMap;
import org.netbeans.modules.glassfish.tooling.admin.RunnerHttpClass;
import org.netbeans.modules.glassfish.tooling.admin.RunnerHttpGetProperty;
import org.netbeans.modules.glassfish.tooling.admin.RunnerRestClass;
import org.netbeans.modules.glassfish.tooling.admin.RunnerRestGetProperty;
import org.netbeans.modules.glassfish.tooling.admin.ServerAdmin;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.logging.Logger;

@RunnerHttpClass(runner=RunnerHttpGetProperty.class)
@RunnerRestClass(runner=RunnerRestGetProperty.class)
public class CommandGetProperty
extends Command {
    private static final Logger LOGGER = new Logger(CommandGetProperty.class);
    private static final String COMMAND = "get";
    String propertyPattern;

    public static ResultMap<String, String> getProperties(GlassFishServer server, String propertyPattern) throws GlassFishIdeException {
        String METHOD = "getProperties";
        Future future = ServerAdmin.exec(server, new CommandGetProperty(propertyPattern));
        try {
            return (ResultMap)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new GlassFishIdeException(LOGGER.excMsg("getProperties", "exception", propertyPattern), ee);
        }
    }

    public static ResultMap<String, String> getProperties(GlassFishServer server, String propertyPattern, long timeout) throws GlassFishIdeException {
        String METHOD = "getProperties";
        Future future = ServerAdmin.exec(server, new CommandGetProperty(propertyPattern));
        try {
            return (ResultMap)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new GlassFishIdeException(LOGGER.excMsg("getProperties", "exception", propertyPattern), ee);
        }
        catch (TimeoutException te) {
            throw new GlassFishIdeException(LOGGER.excMsg("getProperties", "exceptionWithTimeout", propertyPattern, Long.toString(timeout)), te);
        }
    }

    public CommandGetProperty(String property) {
        super(COMMAND);
        this.propertyPattern = property;
    }
}

