/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.glassfish.tooling.utils.EnumUtils;
import org.openide.util.Parameters;

public enum GlassFishVersion {
    GF_1(1, 0, 0, 0, "1"),
    GF_2(2, 0, 0, 0, "2"),
    GF_2_1(2, 1, 0, 0, "2.1"),
    GF_2_1_1(2, 1, 1, 0, "2.1.1"),
    GF_3(3, 0, 0, 0, "3"),
    GF_3_0_1(3, 0, 1, 0, "3.0.1"),
    GF_3_1(3, 1, 0, 0, "3.1"),
    GF_3_1_1(3, 1, 1, 0, "3.1.1"),
    GF_3_1_2(3, 1, 2, 0, "3.1.2"),
    GF_3_1_2_2(3, 1, 2, 2, "3.1.2.2"),
    GF_3_1_2_3(3, 1, 2, 3, "3.1.2.3"),
    GF_3_1_2_4(3, 1, 2, 4, "3.1.2.4"),
    GF_3_1_2_5(3, 1, 2, 5, "3.1.2.5"),
    GF_4(4, 0, 0, 0, "4"),
    GF_4_0_1(4, 0, 1, 0, "4.0.1"),
    GF_4_1(4, 1, 0, 0, "4.1"),
    GF_4_1_1(4, 1, 1, 0, "4.1.1"),
    GF_4_1_2(4, 1, 1, 2, "4.1.2"),
    GF_5(5, 0, 0, 0, "5"),
    GF_5_0_1(5, 0, 1, 0, "5.0.1"),
    GF_5_1_0(5, 1, 0, 0, "5.1.0"),
    GF_6(6, 0, 0, 0, "6"),
    GF_6_1_0(6, 1, 0, 0, "6.1.0"),
    GF_6_2_0(6, 2, 0, 0, "6.2.0"),
    GF_6_2_1(6, 2, 1, 0, "6.2.1"),
    GF_6_2_2(6, 2, 2, 0, "6.2.2"),
    GF_6_2_3(6, 2, 3, 0, "6.2.3"),
    GF_6_2_4(6, 2, 4, 0, "6.2.4"),
    GF_6_2_5(6, 2, 5, 0, "6.2.5");

    public static final int length;
    public static final char SEPARATOR = '.';
    public static final String SEPARATOR_PATTERN = "\\.";
    static final String GF_1_STR = "1";
    static final String[] GF_1_STR_NEXT;
    static final String GF_2_STR = "2";
    static final String[] GF_2_STR_NEXT;
    static final String GF_2_1_STR = "2.1";
    static final String[] GF_2_1_STR_NEXT;
    static final String GF_2_1_1_STR = "2.1.1";
    static final String[] GF_2_1_1_STR_NEXT;
    static final String GF_3_STR = "3";
    static final String[] GF_3_STR_NEXT;
    static final String GF_3_0_1_STR = "3.0.1";
    static final String[] GF_3_0_1_STR_NEXT;
    static final String GF_3_1_STR = "3.1";
    static final String[] GF_3_1_STR_NEXT;
    static final String GF_3_1_1_STR = "3.1.1";
    static final String[] GF_3_1_1_STR_NEXT;
    static final String GF_3_1_2_STR = "3.1.2";
    static final String[] GF_3_1_2_STR_NEXT;
    static final String GF_3_1_2_2_STR = "3.1.2.2";
    static final String GF_3_1_2_3_STR = "3.1.2.3";
    static final String GF_3_1_2_4_STR = "3.1.2.4";
    static final String GF_3_1_2_5_STR = "3.1.2.5";
    static final String GF_4_STR = "4";
    static final String[] GF_4_STR_NEXT;
    static final String GF_4_0_1_STR = "4.0.1";
    static final String[] GF_4_0_1_STR_NEXT;
    static final String GF_4_1_STR = "4.1";
    static final String[] GF_4_1_STR_NEXT;
    static final String GF_4_1_1_STR = "4.1.1";
    static final String[] GF_4_1_1_STR_NEXT;
    static final String GF_4_1_2_STR = "4.1.2";
    static final String[] GF_4_1_2_STR_NEXT;
    static final String GF_5_STR = "5";
    static final String[] GF_5_STR_NEXT;
    static final String GF_5_0_1_STR = "5.0.1";
    static final String[] GF_5_0_1_STR_NEXT;
    static final String GF_5_1_0_STR = "5.1.0";
    static final String[] GF_5_1_0_STR_NEXT;
    static final String GF_6_STR = "6";
    static final String[] GF_6_STR_NEXT;
    static final String GF_6_1_0_STR = "6.1.0";
    static final String[] GF_6_1_0_STR_NEXT;
    static final String GF_6_2_0_STR = "6.2.0";
    static final String[] GF_6_2_0_STR_NEXT;
    static final String GF_6_2_1_STR = "6.2.1";
    static final String[] GF_6_2_1_STR_NEXT;
    static final String GF_6_2_2_STR = "6.2.2";
    static final String[] GF_6_2_2_STR_NEXT;
    static final String GF_6_2_3_STR = "6.2.3";
    static final String[] GF_6_2_3_STR_NEXT;
    static final String GF_6_2_4_STR = "6.2.4";
    static final String[] GF_6_2_4_STR_NEXT;
    static final String GF_6_2_5_STR = "6.2.5";
    static final String[] GF_6_2_5_STR_NEXT;
    private static final Map<String, GlassFishVersion> stringValuesMap;
    private final short major;
    private final short minor;
    private final short update;
    private final short build;
    private final String value;

    private static void initStringValuesMapFromArray(GlassFishVersion version, String[] values) {
        for (String value : values) {
            stringValuesMap.put(value, version);
        }
    }

    @CheckForNull
    public static GlassFishVersion toValue(@NonNull String versionStr) {
        Parameters.notNull((CharSequence)"versionStr", (Object)versionStr);
        GlassFishVersion version = stringValuesMap.get(versionStr.toUpperCase(Locale.ENGLISH));
        if (version == null) {
            int i;
            ArrayList<Integer> versionNumbers = new ArrayList<Integer>(4);
            String[] versionParts = versionStr.split("[^0-9.]", 2);
            String[] versionNumberStrings = versionParts[0].split(SEPARATOR_PATTERN);
            for (i = 0; i < Math.min(4, versionNumberStrings.length); ++i) {
                try {
                    int value = Integer.parseInt(versionNumberStrings[i]);
                    versionNumbers.add(value);
                    continue;
                }
                catch (NumberFormatException ex) {
                    break;
                }
            }
            for (i = versionNumbers.size(); i < 4; ++i) {
                versionNumbers.add(0);
            }
            GlassFishVersion[] candidates = GlassFishVersion.values();
            for (int i2 = candidates.length - 1; i2 >= 0; --i2) {
                if (!GlassFishVersion.gfvSmallerOrEqual(candidates[i2], versionNumbers)) continue;
                version = candidates[i2];
                break;
            }
        }
        return version;
    }

    private static boolean gfvSmallerOrEqual(GlassFishVersion gfv, List<Integer> versionNumbers) {
        if (gfv.getMajor() < versionNumbers.get(0)) {
            return true;
        }
        if (gfv.getMajor() == versionNumbers.get(0).intValue()) {
            if (gfv.getMinor() < versionNumbers.get(1)) {
                return true;
            }
            if (gfv.getMinor() == versionNumbers.get(1).intValue()) {
                if (gfv.getUpdate() < versionNumbers.get(2)) {
                    return true;
                }
                if (gfv.getUpdate() == versionNumbers.get(2).intValue()) {
                    return gfv.getBuild() <= versionNumbers.get(3);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private GlassFishVersion(short major, short minor, short update, short build, String value) {
        this.major = major;
        this.minor = minor;
        this.update = update;
        this.build = build;
        this.value = value;
    }

    public short getMajor() {
        return this.major;
    }

    public short getMinor() {
        return this.minor;
    }

    public short getUpdate() {
        return this.update;
    }

    public short getBuild() {
        return this.build;
    }

    public boolean equalsMajorMinor(GlassFishVersion version) {
        if (version == null) {
            return false;
        }
        return this.major == version.major && this.minor == version.minor;
    }

    public boolean equals(GlassFishVersion version) {
        if (version == null) {
            return false;
        }
        return this.major == version.major && this.minor == version.minor && this.update == version.update && this.build == version.build;
    }

    public static boolean eq(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.eq(v1, v2);
    }

    public static boolean ne(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.ne(v1, v2);
    }

    public static boolean lt(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.lt(v1, v2);
    }

    public static boolean le(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.le(v1, v2);
    }

    public static boolean gt(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.gt(v1, v2);
    }

    public static boolean ge(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.ge(v1, v2);
    }

    public String toString() {
        return this.value;
    }

    public String toFullString() {
        StringBuilder sb = new StringBuilder(8);
        sb.append(Integer.toString(this.major));
        sb.append('.');
        sb.append(Integer.toString(this.minor));
        sb.append('.');
        sb.append(Integer.toString(this.update));
        sb.append('.');
        sb.append(Integer.toString(this.build));
        return sb.toString();
    }

    static {
        length = GlassFishVersion.values().length;
        GF_1_STR_NEXT = new String[]{"1.0", "1.0.0", "1.0.0.0"};
        GF_2_STR_NEXT = new String[]{"2.0", "2.0.0", "2.0.0.0"};
        GF_2_1_STR_NEXT = new String[]{"2.1.0", "2.1.0.0"};
        GF_2_1_1_STR_NEXT = new String[]{"2.1.1.0"};
        GF_3_STR_NEXT = new String[]{"3.0", "3.0.0", "3.0.0.0"};
        GF_3_0_1_STR_NEXT = new String[]{"3.0.1.0"};
        GF_3_1_STR_NEXT = new String[]{"3.1.0", "3.1.0.0"};
        GF_3_1_1_STR_NEXT = new String[]{"3.1.1.0"};
        GF_3_1_2_STR_NEXT = new String[]{"3.1.2.0"};
        GF_4_STR_NEXT = new String[]{"4.0", "4.0.0", "4.0.0.0"};
        GF_4_0_1_STR_NEXT = new String[]{"4.0.1.0"};
        GF_4_1_STR_NEXT = new String[]{"4.1.0", "4.1.0.0"};
        GF_4_1_1_STR_NEXT = new String[]{"4.1.1.0"};
        GF_4_1_2_STR_NEXT = new String[]{"4.1.2.0"};
        GF_5_STR_NEXT = new String[]{"5.0", "5.0.0", "5.0.0.0"};
        GF_5_0_1_STR_NEXT = new String[]{GF_5_0_1_STR, "5.0.1.0"};
        GF_5_1_0_STR_NEXT = new String[]{GF_5_1_0_STR, "5.1.0.0"};
        GF_6_STR_NEXT = new String[]{"6.0", "6.0.0", "6.0.0.0"};
        GF_6_1_0_STR_NEXT = new String[]{"6.1", GF_6_1_0_STR, "6.1.0.0"};
        GF_6_2_0_STR_NEXT = new String[]{"6.2", GF_6_2_0_STR, "6.2.0.0"};
        GF_6_2_1_STR_NEXT = new String[]{GF_6_2_1_STR, "6.2.1.0"};
        GF_6_2_2_STR_NEXT = new String[]{GF_6_2_2_STR, "6.2.2.0"};
        GF_6_2_3_STR_NEXT = new String[]{GF_6_2_3_STR, "6.2.3.0"};
        GF_6_2_4_STR_NEXT = new String[]{GF_6_2_4_STR, "6.2.4.0"};
        GF_6_2_5_STR_NEXT = new String[]{GF_6_2_5_STR, "6.2.5.0"};
        stringValuesMap = new HashMap<String, GlassFishVersion>(2 * GlassFishVersion.values().length);
        for (GlassFishVersion state : GlassFishVersion.values()) {
            stringValuesMap.put(state.toString().toUpperCase(), state);
        }
        GlassFishVersion.initStringValuesMapFromArray(GF_1, GF_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_2, GF_2_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_2_1, GF_2_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_2_1_1, GF_2_1_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3, GF_3_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_0_1, GF_3_0_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_1, GF_3_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_1_1, GF_3_1_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_1_2, GF_3_1_2_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_4, GF_4_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_4_0_1, GF_4_0_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_4_1, GF_4_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_4_1_1, GF_4_1_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_4_1_2, GF_4_1_2_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_5, GF_5_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_5_1_0, GF_5_1_0_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_6, GF_6_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_6_1_0, GF_6_1_0_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_6_2_0, GF_6_2_0_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_6_2_1, GF_6_2_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_6_2_2, GF_6_2_2_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_6_2_3, GF_6_2_3_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_6_2_4, GF_6_2_4_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_6_2_5, GF_6_2_5_STR_NEXT);
    }
}

