/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.netbeans.modules.glassfish.tooling.GlassFishStatusListener;
import org.netbeans.modules.glassfish.tooling.data.DataException;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServerStatus;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.server.state.GlassFishStatusEntity;
import org.netbeans.modules.glassfish.tooling.server.state.StatusJob;
import org.netbeans.modules.glassfish.tooling.server.state.StatusScheduler;

public enum GlassFishStatus {
    UNKNOWN,
    OFFLINE,
    STARTUP,
    ONLINE,
    SHUTDOWN;

    private static final Logger LOGGER;
    public static final int length;
    private static final String UNKNOWN_STR = "UNKNOWN";
    private static final String OFFLINE_STR = "OFFLINE";
    private static final String STARTUP_STR = "STARTUP";
    private static final String ONLINE_STR = "ONLINE";
    private static final String SHUTDOWN_STR = "SHUTDOWN";
    private static final Map<String, GlassFishStatus> stringValuesMap;

    public static GlassFishStatus toValue(String name) {
        if (name != null) {
            return stringValuesMap.get(name.toUpperCase());
        }
        return null;
    }

    public static void initScheduler(ScheduledThreadPoolExecutor executor) {
        StatusScheduler.init(executor);
    }

    public static boolean add(GlassFishServer srv) {
        StatusScheduler scheduler = StatusScheduler.getInstance();
        if (!scheduler.exists(srv)) {
            GlassFishStatusEntity status = new GlassFishStatusEntity(srv);
            return StatusScheduler.getInstance().add(status);
        }
        return false;
    }

    public static boolean add(GlassFishServer srv, GlassFishStatusListener listener, boolean currentState, GlassFishStatus ... newState) {
        StatusScheduler scheduler = StatusScheduler.getInstance();
        if (!scheduler.exists(srv)) {
            GlassFishStatusEntity status = new GlassFishStatusEntity(srv);
            return StatusScheduler.getInstance().add(status, listener, currentState, newState);
        }
        return false;
    }

    public static GlassFishStatus getStatus(GlassFishServer srv) {
        GlassFishServerStatus status = StatusScheduler.getInstance().get(srv, null);
        return status != null ? status.getStatus() : UNKNOWN;
    }

    public static GlassFishStatus getStatus(GlassFishServer srv, GlassFishStatusListener listener) {
        GlassFishServerStatus status = StatusScheduler.getInstance().get(srv, listener);
        return status != null ? status.getStatus() : UNKNOWN;
    }

    public static GlassFishServerStatus get(GlassFishServer srv) {
        return StatusScheduler.getInstance().get(srv, null);
    }

    public static GlassFishServerStatus get(GlassFishServer srv, GlassFishStatusListener listener) {
        return StatusScheduler.getInstance().get(srv, listener);
    }

    public static boolean start(GlassFishServer srv, boolean force, GlassFishStatusListener listener, GlassFishStatus ... newState) {
        return StatusScheduler.getInstance().start(srv, force, listener, newState);
    }

    public static boolean start(GlassFishServer srv) {
        return StatusScheduler.getInstance().start(srv, false, null, new GlassFishStatus[0]);
    }

    public static boolean shutdown(GlassFishServer srv) {
        return StatusScheduler.getInstance().shutdown(srv);
    }

    public static boolean remove(GlassFishServer srv) {
        return StatusScheduler.getInstance().remove(srv);
    }

    public static boolean suspend(GlassFishServer srv) {
        return StatusScheduler.getInstance().suspend(srv);
    }

    public static boolean addCheckListener(GlassFishServer srv, GlassFishStatusListener listener) {
        StatusJob job = StatusScheduler.getInstance().getJob(srv);
        if (job != null) {
            return job.addCurrStatusListener(listener);
        }
        return false;
    }

    public static boolean addChangeListener(GlassFishServer srv, GlassFishStatusListener listener, GlassFishStatus ... newState) {
        StatusJob job = StatusScheduler.getInstance().getJob(srv);
        if (job != null) {
            return job.addNewStatusListener(listener, newState);
        }
        return false;
    }

    public static boolean addErrorListener(GlassFishServer srv, GlassFishStatusListener listener) {
        StatusJob job = StatusScheduler.getInstance().getJob(srv);
        if (job != null) {
            return job.addErrorListener(listener);
        }
        return false;
    }

    public static boolean addListener(GlassFishServer srv, GlassFishStatusListener listener, boolean currentState, GlassFishStatus ... newState) {
        StatusJob job = StatusScheduler.getInstance().getJob(srv);
        if (job != null) {
            return job.addStatusListener(listener, currentState, newState);
        }
        return false;
    }

    public static boolean removeListener(GlassFishServer srv, GlassFishStatusListener listener) {
        StatusJob job = StatusScheduler.getInstance().getJob(srv);
        if (job != null) {
            return job.removeStatusListener(listener);
        }
        return false;
    }

    public String toString() {
        String METHOD = "toString";
        switch (this) {
            case UNKNOWN: {
                return UNKNOWN_STR;
            }
            case OFFLINE: {
                return OFFLINE_STR;
            }
            case STARTUP: {
                return STARTUP_STR;
            }
            case ONLINE: {
                return ONLINE_STR;
            }
            case SHUTDOWN: {
                return SHUTDOWN_STR;
            }
        }
        throw new DataException(LOGGER.excMsg("toString", "invalidState"));
    }

    static {
        LOGGER = new Logger(GlassFishStatus.class);
        length = GlassFishStatus.values().length;
        stringValuesMap = new HashMap<String, GlassFishStatus>(GlassFishStatus.values().length);
        for (GlassFishStatus state : GlassFishStatus.values()) {
            stringValuesMap.put(state.toString().toUpperCase(), state);
        }
    }
}

