/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.glassfish.eecommon.api.config.J2eeModuleHelper;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class Utils {
    private Utils() {
    }

    public static final boolean notEmpty(String testedString) {
        return testedString != null && testedString.length() > 0;
    }

    public static final boolean strEmpty(String testedString) {
        return testedString == null || testedString.length() == 0;
    }

    public static final boolean strEquals(String one, String two) {
        boolean result = false;
        result = one == null ? two == null : (two == null ? false : one.equals(two));
        return result;
    }

    public static final boolean strEquivalent(String one, String two) {
        boolean result = false;
        if (Utils.strEmpty(one) && Utils.strEmpty(two)) {
            result = true;
        } else if (one != null && two != null) {
            result = one.equals(two);
        }
        return result;
    }

    public static final int strCompareTo(String one, String two) {
        int result = one == null ? (two == null ? 0 : -1) : (two == null ? 1 : one.compareTo(two));
        return result;
    }

    public static String computeModuleID(J2eeModule module, File dir, String fallbackExt) {
        RootInterface rootDD;
        J2eeModuleHelper j2eeModuleHelper;
        String moduleID = null;
        FileObject fo = null;
        try {
            fo = module.getContentDirectory();
            if (null != fo) {
                moduleID = ProjectUtils.getInformation((Project)FileOwnerQuery.getOwner((FileObject)fo)).getDisplayName();
            }
        }
        catch (IOException ex) {
            Logger.getLogger("glassfish-eecommon").log(Level.FINER, null, ex);
        }
        if ((null == moduleID || moduleID.trim().length() < 1) && (j2eeModuleHelper = J2eeModuleHelper.getSunDDModuleHelper(module.getType())) != null && (rootDD = j2eeModuleHelper.getStandardRootDD(module)) != null) {
            try {
                moduleID = rootDD.getDisplayName(null);
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                // empty catch block
            }
        }
        if (null != dir && null != fallbackExt) {
            moduleID = null == moduleID || moduleID.trim().length() < 1 ? Utils.simplifyModuleID(dir.getParentFile().getParentFile().getName(), fallbackExt) : Utils.simplifyModuleID(moduleID, fallbackExt);
        }
        return moduleID;
    }

    private static String simplifyModuleID(String candidateID, String fallbackExt) {
        String moduleID = null;
        if (candidateID == null) {
            moduleID = "_default_" + fallbackExt;
        } else if (candidateID.equals("")) {
            moduleID = "_default_" + fallbackExt;
        }
        if (null == moduleID) {
            moduleID = candidateID.replace(' ', '_');
            if (moduleID.startsWith("/")) {
                moduleID = moduleID.substring(1);
            }
            moduleID = moduleID.replace('\\', '_').replace('/', '_');
            moduleID = moduleID.replace('*', '_');
            moduleID = moduleID.replace('?', '_').replace('\"', '_');
            moduleID = moduleID.replace('<', '_').replace('>', '_');
            moduleID = moduleID.replace('|', '_');
            moduleID = moduleID.replace(',', '_').replace('=', '_');
        }
        return moduleID;
    }

    public static FileObject getSunDDFromProjectsModuleVersion(J2eeModule mod, String sunDDFileName) {
        String suffix = "-java_ee/";
        String resource = "org-netbeans-modules-glassfish-eecommon-ddtemplates" + suffix + sunDDFileName;
        FileObject retVal = FileUtil.getConfigFile((String)resource);
        return retVal;
    }

    public static String getInstanceReleaseID(J2eeModuleProvider jmp) {
        String retVal = "bogusID";
        try {
            String sid = jmp.getServerInstanceID();
            if (null != sid) {
                retVal = sid.replaceFirst(".*\\]deployer:", "").replaceFirst("\\:.*$", "");
            }
        }
        catch (NullPointerException npe) {
            Logger.getLogger("glassfish").log(Level.WARNING, "could not get valid InstanceReleaseID from {0}", jmp.getServerInstanceID());
        }
        return retVal;
    }

    public static class JarFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File f) {
            return !f.isDirectory() && f.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar");
        }
    }
}

