/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.glassfish.eecommon.api.ProgressEventSupport;
import org.netbeans.modules.glassfish.eecommon.api.Utils;
import org.netbeans.modules.j2ee.common.ClasspathUtil;
import org.netbeans.modules.j2ee.common.DatasourceHelper;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class JDBCDriverDeployHelper {
    public static ProgressObject getProgressObject(File driverLoc, List listOfURLS) {
        return new JDBCDriversProgressObject(driverLoc, listOfURLS);
    }

    private static void addDriversURLs(List<URL> drivers, JDBCDriver[] jdbcDrivers) {
        for (JDBCDriver jdbcDriver : jdbcDrivers) {
            URL[] allUrls = jdbcDriver.getURLs();
            for (int i = 0; i < allUrls.length; ++i) {
                URL driverUrl = allUrls[i];
                String strUrl = driverUrl.toString();
                if (strUrl.contains("nbinst:/")) {
                    URL localURL;
                    FileObject fo = URLMapper.findFileObject((URL)driverUrl);
                    if (fo == null || (localURL = URLMapper.findURL((FileObject)fo, (int)1)) == null) continue;
                    drivers.add(localURL);
                    continue;
                }
                drivers.add(driverUrl);
            }
        }
    }

    public static List<URL> getMissingDrivers(File[] driverLocs, Set<Datasource> datasources) {
        ArrayList<URL> drivers = new ArrayList<URL>();
        for (Datasource datasource : datasources) {
            JDBCDriver[] jdbcDrivers;
            String className = datasource.getDriverClassName();
            if (null == className) continue;
            boolean exists = false;
            for (int j = 0; j < driverLocs.length; ++j) {
                File driverLoc = driverLocs[j];
                if (driverLoc != null && driverLoc.exists()) {
                    List<File> driversLocation = Arrays.asList(driverLoc.listFiles(new Utils.JarFileFilter()));
                    try {
                        exists = ClasspathUtil.containsClass(driversLocation, (String)className);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    if (!exists) continue;
                    break;
                }
                Logger.getLogger("glassfish-eecommon").finer("Invalid directory for driver deployment");
            }
            if (exists) continue;
            List databaseConnections = DatasourceHelper.findDatabaseConnections((Datasource)datasource);
            if (databaseConnections != null && databaseConnections.size() > 0) {
                for (DatabaseConnection databaseConnection : databaseConnections) {
                    JDBCDriver connDriver = databaseConnection.getJDBCDriver();
                    if (connDriver != null) {
                        jdbcDrivers = new JDBCDriver[]{connDriver};
                    } else {
                        String driverClass = databaseConnection.getDriverClass();
                        jdbcDrivers = JDBCDriverManager.getDefault().getDrivers(driverClass);
                    }
                    JDBCDriverDeployHelper.addDriversURLs(drivers, jdbcDrivers);
                }
                continue;
            }
            jdbcDrivers = JDBCDriverManager.getDefault().getDrivers(datasource.getDriverClassName());
            JDBCDriverDeployHelper.addDriversURLs(drivers, jdbcDrivers);
        }
        return drivers;
    }

    private static class JDBCDriversProgressObject
    implements ProgressObject,
    Runnable {
        private final ProgressEventSupport eventSupport = new ProgressEventSupport(this);
        private final File driverLoc;
        private List<URL> jdbcDriverURLs;

        public JDBCDriversProgressObject(File driverLoc, List jdbcDriverURLs) {
            String msg = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"MSG_CheckMissingDrivers");
            this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, msg, StateType.RUNNING));
            this.driverLoc = driverLoc;
            this.jdbcDriverURLs = jdbcDriverURLs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.jdbcDriverURLs.size() > 0) {
                String msg;
                boolean success = true;
                for (int i = 0; i < this.jdbcDriverURLs.size(); ++i) {
                    URL jarUrl = this.jdbcDriverURLs.get(i);
                    File libsDir = this.driverLoc;
                    try {
                        File toJar = new File(libsDir, new File(jarUrl.toURI()).getName());
                        try {
                            BufferedInputStream is = new BufferedInputStream(jarUrl.openStream());
                            try {
                                msg = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"MSG_DeployDriver", (Object)toJar.getPath());
                                this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, msg, StateType.RUNNING));
                                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(toJar));
                                try {
                                    FileUtil.copy((InputStream)is, (OutputStream)os);
                                }
                                finally {
                                    if (null != os) {
                                        try {
                                            os.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                            finally {
                                if (null != is) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        catch (IOException e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.FINER, "", e);
                            msg = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"ERR_DeployDriver", (Object)toJar.getPath(), (Object)libsDir.getPath());
                            this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, msg, StateType.FAILED));
                            success = false;
                        }
                        continue;
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.FINER, "", ex);
                        msg = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"ERR_DeployDriver", (Object)jarUrl, (Object)libsDir.getPath());
                        this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, msg, StateType.FAILED));
                        success = false;
                        continue;
                    }
                    catch (RuntimeException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.FINER, "", ex);
                        msg = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"ERR_DeployDriver", (Object)jarUrl, (Object)libsDir.getPath());
                        this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, msg, StateType.FAILED));
                        success = false;
                    }
                }
                msg = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"MSG_DeployDriverComplete");
                if (!success) {
                    msg = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"ERR_DeployDriverFailed");
                }
                this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, msg, success ? StateType.COMPLETED : StateType.FAILED));
            } else {
                this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, "", StateType.COMPLETED));
            }
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.eventSupport.getDeploymentStatus();
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return new TargetModuleID[0];
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return null;
        }

        public boolean isCancelSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Cancel is not supported");
        }

        public boolean isStopSupported() {
            return false;
        }

        public void stop() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Stop is not supported");
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.eventSupport.addProgressListener(progressListener);
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.eventSupport.removeProgressListener(progressListener);
        }
    }
}

