/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import org.netbeans.modules.git.Bundle;
import org.netbeans.modules.git.GitFileNode;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class GitStatusNode<T extends GitFileNode>
extends VCSStatusNode<T> {
    private static final String[] zeros = new String[]{"", "00", "0", ""};

    public GitStatusNode(T node) {
        this(node, Lookups.fixed((Object[])node.getLookupObjects()));
    }

    public GitStatusNode(T node, Lookup lkp) {
        super(node, lkp);
        this.initProperties();
    }

    public Node.Cookie getCookie(Class klass) {
        FileObject fo = (FileObject)this.getLookup().lookup(FileObject.class);
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (fo.equals(dobj.getPrimaryFile())) {
                    return dobj.getCookie(klass);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return super.getCookie(klass);
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)this.nameProperty);
        ps.put((Node.Property)this.pathProperty);
        ps.put((Node.Property)new GitStatusProperty(this));
        sheet.put(ps);
        this.setSheet(sheet);
    }

    public void refresh() {
    }

    public abstract String getStatusText();

    public static class GitStatusProperty
    extends VCSStatusNode.NodeProperty<String> {
        public static final String NAME = "gitstatus";
        public static final String DISPLAY_NAME = Bundle.LBL_Status_DisplayName();
        public static final String DESCRIPTION = Bundle.LBL_Status_Description();
        private final GitStatusNode node;

        public GitStatusProperty(GitStatusNode statusNode) {
            super(NAME, String.class, DISPLAY_NAME, DESCRIPTION);
            String sortable = Integer.toString(statusNode.getFileNode().getInformation().getComparableStatus());
            this.setValue("sortkey", zeros[sortable.length()] + sortable + "\t" + statusNode.getFileNode().getName());
            this.node = statusNode;
        }

        public String getValue() {
            return this.node.getStatusText();
        }
    }
}

