/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Format;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.extbrowser.BrowserUtils;
import org.netbeans.modules.extbrowser.Bundle;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.NbBrowserException;
import org.netbeans.modules.extbrowser.PrivateBrowserFamilyId;
import org.netbeans.modules.extbrowser.SimpleExtBrowser;
import org.netbeans.modules.extbrowser.URLUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NbDdeBrowserImpl
extends ExtBrowserImpl {
    private static final String WWW_ACTIVATE = "WWW_Activate";
    private static final String WWW_OPEN_URL = "WWW_OpenURL";
    private static final String EXTBROWSER_DLL = "extbrowser";
    private static final String EXTBROWSER_DLL_64BIT = "extbrowser64";
    private static Thread nativeThread;
    private static URLDisplayer nativeRunnable;

    public NbDdeBrowserImpl(ExtWebBrowser extBrowserFactory) {
        this.extBrowserFactory = extBrowserFactory;
        NbDdeBrowserImpl.logFine("NbDdeBrowserImpl created with factory:", extBrowserFactory);
    }

    private native byte[] reqDdeMessage(String var1, String var2, String var3, int var4) throws NbBrowserException;

    public static native String getBrowserPath(String var0) throws NbBrowserException;

    public static native String getDefaultOpenCommand() throws NbBrowserException;

    @Override
    protected void loadURLInBrowserInternal(URL url) {
        assert (!EventQueue.isDispatchThread());
        NbDdeBrowserImpl.logFine("NbDdeBrowserImpl.setUrl:", url);
        if (url == null) {
            return;
        }
        if (this.isInternetExplorer()) {
            if (nativeThread == null) {
                nativeRunnable = new URLDisplayer();
                nativeThread = new Thread((Runnable)nativeRunnable, "URLdisplayer");
                nativeThread.start();
            }
            NbDdeBrowserImpl.nativeRunnable.postTask(new DisplayTask(url, this));
        } else {
            NbProcessDescriptor np = this.extBrowserFactory.getBrowserExecutable();
            try {
                String urlTxt;
                url = URLUtil.createExternalURL(url, false);
                if (url == null) {
                    urlTxt = "";
                } else {
                    try {
                        urlTxt = url.toURI().toASCIIString();
                    }
                    catch (URISyntaxException ex) {
                        NbDdeBrowserImpl.logInfo(ex);
                        urlTxt = url.toString();
                    }
                }
                if (np != null) {
                    np.exec((Format)((Object)new SimpleExtBrowser.BrowserFormat(urlTxt)));
                }
            }
            catch (IOException ex) {
                NbDdeBrowserImpl.logInfo(ex);
                BrowserUtils.notifyMissingBrowser(np.getProcessName());
            }
        }
    }

    private static void logInfo(Exception ex) {
        ExtWebBrowser.getEM().log(Level.INFO, null, ex);
    }

    private static void logFine(String message) {
        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
            ExtWebBrowser.getEM().log(Level.FINE, "{0} {1}", new Object[]{System.currentTimeMillis(), message});
        }
    }

    private static void logFine(String message, Object object) {
        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
            ExtWebBrowser.getEM().log(Level.FINE, "{0} {1} {2}", new Object[]{System.currentTimeMillis(), message, object});
        }
    }

    @Override
    protected PrivateBrowserFamilyId detectPrivateBrowserFamilyId() {
        PrivateBrowserFamilyId id = super.detectPrivateBrowserFamilyId();
        if (id == PrivateBrowserFamilyId.UNKNOWN) {
            switch (this.realDDEServer()) {
                case "FIREFOX": {
                    id = PrivateBrowserFamilyId.FIREFOX;
                    break;
                }
                case "CHROME": {
                    id = PrivateBrowserFamilyId.CHROME;
                    break;
                }
                default: {
                    id = PrivateBrowserFamilyId.UNKNOWN;
                }
            }
        }
        return id;
    }

    private String realDDEServer() {
        NbDdeBrowserImpl.logFine("NbDdeBrowserImpl.realDDEServer");
        String srv = this.extBrowserFactory.getDDEServer();
        if (srv != null) {
            return srv;
        }
        try {
            String cmd = NbDdeBrowserImpl.getDefaultOpenCommand();
            if (cmd != null) {
                if ((cmd = cmd.toUpperCase()).contains("IEXPLORE")) {
                    return "IEXPLORE";
                }
                if (cmd.contains("CHROME")) {
                    return "CHROME";
                }
                if (cmd.contains("FIREFOX")) {
                    return "FIREFOX";
                }
                if (cmd.contains("MOZILLA")) {
                    return "MOZILLA";
                }
            }
        }
        catch (Exception ex) {
            NbDdeBrowserImpl.logInfo(ex);
        }
        return "IEXPLORE";
    }

    public int getActivateTimeout() {
        return this.extBrowserFactory.getActivateTimeout();
    }

    public int getOpenUrlTimeout() {
        return this.extBrowserFactory.getOpenurlTimeout();
    }

    private boolean isInternetExplorer() {
        return this.realDDEServer().equals("IEXPLORE");
    }

    static {
        NbDdeBrowserImpl.logFine("NbDdeBrowser: static initializer: ");
        try {
            if (Utilities.isWindows()) {
                String sunDataModel = System.getProperty("sun.arch.data.model");
                if (sunDataModel != null) {
                    if ("64".equals(sunDataModel)) {
                        System.loadLibrary(EXTBROWSER_DLL_64BIT);
                    } else {
                        System.loadLibrary(EXTBROWSER_DLL);
                    }
                } else {
                    String javaVMName = System.getProperty("java.vm.name");
                    if (javaVMName != null && javaVMName.contains("64")) {
                        System.loadLibrary(EXTBROWSER_DLL_64BIT);
                    } else {
                        System.loadLibrary(EXTBROWSER_DLL);
                    }
                }
            }
        }
        catch (Exception e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(NbDdeBrowserImpl.class, (String)"ERR_cant_locate_dll"), 1));
        }
        nativeThread = null;
        nativeRunnable = null;
    }

    private static class DisplayTask {
        URL url;
        NbDdeBrowserImpl browser;

        DisplayTask(URL url, NbDdeBrowserImpl browser) {
            this.url = url;
            this.browser = browser;
        }
    }

    static class URLDisplayer
    implements Runnable {
        private static final int ADDITIONAL_WAIT_TIMEOUT = 6000;
        Vector tasks = new Vector();
        boolean isDisplaying = false;

        private URLDisplayer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postTask(DisplayTask task) {
            URLDisplayer uRLDisplayer = this;
            synchronized (uRLDisplayer) {
                boolean shouldNotify = this.tasks.isEmpty();
                this.tasks.add(task);
                if (shouldNotify) {
                    this.notifyAll();
                }
            }
        }

        private synchronized DisplayTask getNextTask() throws InterruptedException {
            while (this.tasks.isEmpty()) {
                this.wait();
            }
            return (DisplayTask)this.tasks.remove(0);
        }

        @Override
        public void run() {
            NbDdeBrowserImpl.logFine("NbDdeBrowserImpl.run");
            while (true) {
                try {
                    DisplayTask task = this.getNextTask();
                    this.isDisplaying = true;
                    Timer timer = new Timer();
                    timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (isDisplaying) {
                                nativeThread.interrupt();
                                NbDdeBrowserImpl.logFine("interrupted in URLDisplayer.run.TimerTask.run()");
                                BrowserUtils.notifyMissingBrowser(Bundle.NbDdeBrowserImpl_browser_external());
                            }
                        }
                    }, 6000L);
                    this.dispatchURL(task);
                    timer.cancel();
                    continue;
                }
                catch (InterruptedException ex) {
                    ExtWebBrowser.getEM().log(Level.INFO, "interrupted in run(): " + ex);
                    continue;
                }
                finally {
                    this.isDisplaying = false;
                    continue;
                }
                break;
            }
        }

        public void dispatchURL(DisplayTask task) {
            NbDdeBrowserImpl.logFine("NbDdeBrowserImpl.dispatchURL:", task);
            try {
                URL url = task.url;
                NbDdeBrowserImpl.logFine("URLDispatcher.url:", url);
                url = URLUtil.createExternalURL(url, URLUtil.browserHandlesJarURLs(task.browser.realDDEServer()));
                NbDdeBrowserImpl.logFine("url:", url);
                String urlStr = url.toString();
                boolean triedStart = false;
                int MAX_URL_LENGTH = 199;
                if (urlStr != null && urlStr.length() > 199) {
                    urlStr = this.getFileUrl(urlStr);
                }
                NbDdeBrowserImpl.logFine("urlstr:", urlStr);
                if (!this.win9xHack(task.browser.realDDEServer())) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbDdeBrowserImpl.class, (String)"MSG_activatingBrowser"));
                    try {
                        task.browser.reqDdeMessage(task.browser.realDDEServer(), NbDdeBrowserImpl.WWW_ACTIVATE, "-1,0x0", task.browser.getActivateTimeout());
                    }
                    catch (NbBrowserException ex) {
                        NbDdeBrowserImpl.logFine("Exception, gonna start browser:", ex);
                        triedStart = true;
                        this.startBrowser(task.browser.extBrowserFactory.getBrowserExecutable(), urlStr);
                    }
                }
                NbDdeBrowserImpl.logFine("firstpart");
                if (!triedStart) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbDdeBrowserImpl.class, (String)"MSG_openingURLInBrowser", (Object)urlStr));
                    String args1 = "\"" + urlStr + "\",,-1,0x1,,,";
                    try {
                        Thread.sleep(500L);
                        task.browser.reqDdeMessage(task.browser.realDDEServer(), NbDdeBrowserImpl.WWW_OPEN_URL, args1, task.browser.getOpenUrlTimeout());
                    }
                    catch (NbBrowserException ex) {
                        NbDdeBrowserImpl.logFine("Restarting browser.");
                        this.startBrowser(task.browser.extBrowserFactory.getBrowserExecutable(), urlStr);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                NbDdeBrowserImpl.logFine("secondpart");
                task.browser.pcs.firePropertyChange("url", task.browser.getURL(), url);
            }
            catch (Exception ex) {
                NbDdeBrowserImpl.logFine("Interrupted in URLDisplayer.dispatchURL.end");
                Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(NbDdeBrowserImpl.class, (String)"MSG_win_browser_invocation_failed"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getFileUrl(String url) {
            NbDdeBrowserImpl.logFine("Gonna get redirect file for long url:", url);
            String newurl = null;
            OutputStreamWriter fw = null;
            File f = null;
            int retries = 10;
            while (f == null && retries > 0) {
                --retries;
                try {
                    f = File.createTempFile(NbDdeBrowserImpl.EXTBROWSER_DLL, ".html");
                    NbDdeBrowserImpl.logFine("file:", f);
                    if (f == null) continue;
                    fw = new FileWriter(f);
                    if (f.canWrite()) {
                        String s1 = NbBundle.getMessage(NbDdeBrowserImpl.class, (String)"TXT_RedirectURL1");
                        String s2 = NbBundle.getMessage(NbDdeBrowserImpl.class, (String)"TXT_RedirectURL2");
                        String s = s1.concat(url).concat(s2);
                        fw.write(s);
                        fw.flush();
                    }
                    newurl = "file:/" + f.getAbsolutePath();
                }
                catch (IOException ioe) {
                    NbDdeBrowserImpl.logInfo(ioe);
                }
                finally {
                    if (fw == null) continue;
                    try {
                        fw.close();
                    }
                    catch (IOException ioe) {
                        NbDdeBrowserImpl.logInfo(ioe);
                    }
                }
            }
            if (newurl != null) {
                NbDdeBrowserImpl.logFine("New URL:", newurl);
                return newurl;
            }
            return url;
        }

        private boolean win9xHack(String browser) {
            return browser.equals("IEXPLORE") && (Utilities.getOperatingSystem() == 4 || Utilities.getOperatingSystem() == 2);
        }

        private void startBrowser(NbProcessDescriptor cmd, String url) throws IOException {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbDdeBrowserImpl.class, (String)"MSG_startingBrowser", (Object)url));
            cmd.exec((Format)((Object)new ExtWebBrowser.UnixBrowserFormat(url)));
        }
    }
}

