/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.wizard.Configuration;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ConfigurationLinuxPanel
extends JPanel
implements Configuration {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton certBrowseButton;
    private JLabel certDirectoryLabel;
    private JTextField certTextField;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton socketBrowseButton;
    private JLabel socketLabel;
    private JRadioButton socketRadioButton;
    private JTextField socketTextField;
    private ButtonGroup switchButtonGroup;
    private JLabel urlLabel;
    private JRadioButton urlRadioButton;
    private JTextField urlTextField;

    public ConfigurationLinuxPanel() {
        this.initComponents();
        DefaultDocumentListener listener = new DefaultDocumentListener();
        this.nameTextField.getDocument().addDocumentListener(listener);
        this.socketTextField.getDocument().addDocumentListener(listener);
        this.urlTextField.getDocument().addDocumentListener(listener);
        this.certTextField.getDocument().addDocumentListener(listener);
    }

    @Override
    public void setInputEnabled(boolean enabled) {
        this.nameTextField.setEnabled(enabled);
        this.socketRadioButton.setEnabled(enabled);
        this.urlRadioButton.setEnabled(enabled);
        if (!enabled) {
            this.socketTextField.setEnabled(enabled);
            this.socketBrowseButton.setEnabled(enabled);
            this.urlTextField.setEnabled(enabled);
            this.certTextField.setEnabled(enabled);
            this.certBrowseButton.setEnabled(enabled);
        } else {
            boolean socketSelected = this.socketRadioButton.isSelected();
            this.socketTextField.setEnabled(socketSelected);
            this.socketBrowseButton.setEnabled(socketSelected);
            this.urlTextField.setEnabled(!socketSelected);
            this.certTextField.setEnabled(!socketSelected);
            this.certBrowseButton.setEnabled(!socketSelected);
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public String getDisplayName() {
        return UiUtils.getValue(this.nameTextField);
    }

    @Override
    public void setDisplayName(String displayName) {
        this.nameTextField.setText(displayName);
    }

    @Override
    public boolean isSocketSelected() {
        return this.socketRadioButton.isSelected();
    }

    @Override
    public void setSocketSelected(boolean socketSelected) {
        this.socketRadioButton.setSelected(socketSelected);
        this.refresh();
    }

    @Override
    public File getSocket() {
        String value = UiUtils.getValue(this.socketTextField);
        if (value != null) {
            return new File(value);
        }
        return null;
    }

    @Override
    public void setSocket(File socket) {
        if (socket != null) {
            this.socketTextField.setText(socket.getAbsolutePath());
        }
    }

    @Override
    public String getUrl() {
        return UiUtils.getValue(this.urlTextField);
    }

    @Override
    public void setUrl(String url) {
        this.urlTextField.setText(url);
    }

    @Override
    public String getCertPath() {
        return UiUtils.getValue(this.certTextField);
    }

    @Override
    public void setCertPath(String path) {
        this.certTextField.setText(path);
    }

    private void refresh() {
        boolean socketSelected = this.socketRadioButton.isSelected();
        this.socketTextField.setEnabled(socketSelected);
        this.socketBrowseButton.setEnabled(socketSelected);
        this.urlTextField.setEnabled(!socketSelected);
        this.certTextField.setEnabled(!socketSelected);
        this.certBrowseButton.setEnabled(!socketSelected);
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.switchButtonGroup = new ButtonGroup();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.certDirectoryLabel = new JLabel();
        this.certTextField = new JTextField();
        this.certBrowseButton = new JButton();
        this.socketRadioButton = new JRadioButton();
        this.socketLabel = new JLabel();
        this.socketBrowseButton = new JButton();
        this.socketTextField = new JTextField();
        this.urlRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(ConfigurationLinuxPanel.class, (String)"ConfigurationLinuxPanel.nameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(ConfigurationLinuxPanel.class, (String)"ConfigurationLinuxPanel.urlLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.certDirectoryLabel, (String)NbBundle.getMessage(ConfigurationLinuxPanel.class, (String)"ConfigurationLinuxPanel.certDirectoryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.certBrowseButton, (String)NbBundle.getMessage(ConfigurationLinuxPanel.class, (String)"ConfigurationLinuxPanel.certBrowseButton.text"));
        this.certBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationLinuxPanel.this.certBrowseButtonActionPerformed(evt);
            }
        });
        this.switchButtonGroup.add(this.socketRadioButton);
        this.socketRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.socketRadioButton, (String)NbBundle.getMessage(ConfigurationLinuxPanel.class, (String)"ConfigurationLinuxPanel.socketRadioButton.text"));
        this.socketRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationLinuxPanel.this.socketRadioButtonActionPerformed(evt);
            }
        });
        this.socketLabel.setLabelFor(this.socketTextField);
        Mnemonics.setLocalizedText((JLabel)this.socketLabel, (String)NbBundle.getMessage(ConfigurationLinuxPanel.class, (String)"ConfigurationLinuxPanel.socketLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.socketBrowseButton, (String)NbBundle.getMessage(ConfigurationLinuxPanel.class, (String)"ConfigurationLinuxPanel.socketBrowseButton.text"));
        this.socketBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationLinuxPanel.this.socketBrowseButtonActionPerformed(evt);
            }
        });
        this.switchButtonGroup.add(this.urlRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.urlRadioButton, (String)NbBundle.getMessage(ConfigurationLinuxPanel.class, (String)"ConfigurationLinuxPanel.urlRadioButton.text"));
        this.urlRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationLinuxPanel.this.urlRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameTextField)).addGroup(layout.createSequentialGroup().addComponent(this.socketRadioButton).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.urlRadioButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.socketLabel).addComponent(this.urlLabel).addComponent(this.certDirectoryLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.socketTextField, -1, 190, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.socketBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.certTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.certBrowseButton)).addComponent(this.urlTextField))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.socketRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.socketLabel).addComponent(this.socketTextField, -2, -1, -2).addComponent(this.socketBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.urlRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.urlLabel).addComponent(this.urlTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.certDirectoryLabel).addComponent(this.certTextField, -2, -1, -2).addComponent(this.certBrowseButton))));
    }

    private void certBrowseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setFileHidingEnabled(false);
        String text = UiUtils.getValue(this.certTextField);
        if (text != null) {
            chooser.setSelectedFile(new File(text));
        }
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.certTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void socketBrowseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setFileHidingEnabled(false);
        String text = UiUtils.getValue(this.socketTextField);
        if (text != null) {
            chooser.setSelectedFile(new File(text));
        }
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.socketTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void socketRadioButtonActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void urlRadioButtonActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ConfigurationLinuxPanel.this.changeSupport.fireChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ConfigurationLinuxPanel.this.changeSupport.fireChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ConfigurationLinuxPanel.this.changeSupport.fireChange();
        }
    }
}

