/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.nativeexecution.ExternalTerminalAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.TerminalProfile;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ExternalTerminalProvider {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final HashMap<String, List<TerminalProfile>> profiles = new HashMap();
    private static final HashMap<ExternalTerminal.TermEnvPair, TerminalProfile> hash = new HashMap();

    private ExternalTerminalProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalTerminal getTerminal(ExecutionEnvironment execEnv, String id) {
        HashMap<ExternalTerminal.TermEnvPair, TerminalProfile> hashMap = hash;
        synchronized (hashMap) {
            ExternalTerminal.TermEnvPair key = new ExternalTerminal.TermEnvPair(execEnv, id);
            TerminalProfile terminalProfile = hash.get(key);
            if (terminalProfile != null) {
                return new ExternalTerminal(terminalProfile);
            }
            List<TerminalProfile> terminalProfiles = profiles.get(id);
            if (terminalProfiles == null) {
                throw new IllegalArgumentException("Unsupported terminal type");
            }
            ExternalTerminalAccessor terminalInfo = ExternalTerminalAccessor.getDefault();
            for (TerminalProfile p : terminalProfiles) {
                ExternalTerminal t = new ExternalTerminal(p);
                List<String> validationCommands = p.getValidationCommands();
                if (validationCommands == null || validationCommands.isEmpty()) {
                    return t;
                }
                for (String command : validationCommands) {
                    try {
                        if (command.contains("$self")) {
                            String executable = terminalInfo.getExecutable(t, execEnv);
                            if (executable == null) {
                                return null;
                            }
                            command = command.replaceAll("\\$self", executable);
                        }
                        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(execEnv);
                        HostInfo hostInfo = HostInfoUtils.getHostInfo(execEnv);
                        npb.setExecutable(hostInfo.getShell()).setArguments("-c", command);
                        ProcessUtils.ExitStatus res = ProcessUtils.execute(npb);
                        if (!res.isOK()) continue;
                        hash.put(key, p);
                        return t;
                    }
                    catch (IOException npb) {
                    }
                    catch (ConnectionManager.CancellationException ex) {
                        return null;
                    }
                }
            }
            return null;
        }
    }

    public static Collection<String> getSupportedTerminalIDs() {
        return profiles.keySet();
    }

    private static void init() {
        FileObject folder = FileUtil.getConfigFile((String)"NativeExecution/ExtTerminalSupport");
        if (folder != null && folder.isFolder()) {
            FileObject[] files;
            for (FileObject file : files = folder.getChildren()) {
                try {
                    ExternalTerminalProvider.readConfiguration(file.getInputStream());
                }
                catch (FileNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static void readConfiguration(InputStream inputStream) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        XMLReader xmlReader = null;
        try {
            SAXParser saxParser = spf.newSAXParser();
            xmlReader = saxParser.getXMLReader();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        SAXHandler handler = new SAXHandler();
        xmlReader.setContentHandler(handler);
        try {
            InputSource source = new InputSource(inputStream);
            xmlReader.parse(source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        ExternalTerminalProvider.init();
    }

    private static final class SAXHandler
    extends DefaultHandler {
        private Stack<Context> context = new Stack();
        private TerminalProfile info;
        private StringBuilder accumulator = new StringBuilder();
        private int version = 1;

        private SAXHandler() {
            this.info = new TerminalProfile();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.accumulator.setLength(0);
            if ("terminaldefinition".equals(qName)) {
                this.context.push(Context.root);
                String xmlns = attributes.getValue("xmlns");
                if (xmlns != null) {
                    int lastSlash = xmlns.lastIndexOf(47);
                    if (lastSlash >= 0 && lastSlash + 1 < xmlns.length()) {
                        String versionStr = xmlns.substring(lastSlash + 1);
                        if (versionStr.length() > 0) {
                            try {
                                this.version = Integer.parseInt(versionStr);
                            }
                            catch (NumberFormatException ex) {
                                log.fine("Incorrect version information:" + xmlns);
                            }
                            log.log(Level.FINE, "Terminal definition XML version: " + this.version);
                        }
                    } else {
                        log.fine("Incorrect version information:" + xmlns);
                    }
                }
            } else {
                this.context.push(this.elementStarted(qName, attributes));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.accumulator.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Context cont = this.context.pop();
            if (cont != Context.root) {
                this.elementEnded(cont, this.accumulator.toString());
            } else {
                List<TerminalProfile> list = profiles.get(this.info.getID());
                if (list == null) {
                    list = new ArrayList<TerminalProfile>();
                    profiles.put(this.info.getID(), list);
                }
                list.add(this.info);
            }
        }

        public Context elementStarted(String name, Attributes attributes) {
            Context parentContext = (Context)((Object)this.context.lastElement());
            if ("terminal".equals(name)) {
                this.info.setID(attributes.getValue("id"));
                return Context.terminal;
            }
            if ("validation".equals(name)) {
                return Context.validation;
            }
            if (parentContext == Context.validation) {
                if ("platforms".equals(name)) {
                    return Context.validation_platform;
                }
                if ("test".equals(name)) {
                    this.info.addValidationCommand(attributes.getValue("command"));
                    return Context.validation_test;
                }
            }
            if ("searchpaths".equals(name)) {
                return Context.searchpaths;
            }
            if (parentContext == Context.searchpaths && "path".equals(name)) {
                return Context.searchpath;
            }
            if ("platforms".equals(name)) {
                return Context.terminaldefinition;
            }
            if ("command".equals(name)) {
                this.info.setCommand(attributes.getValue("stringvalue"));
                return Context.terminaldefinition;
            }
            if ("arguments".equals(name)) {
                return Context.arguments;
            }
            if (parentContext == Context.arguments && "arg".equals(name)) {
                return Context.argument;
            }
            return Context.unknown;
        }

        private void elementEnded(Context context, String text) {
            switch (context) {
                case argument: {
                    this.info.addArgument(text);
                    break;
                }
                case validation_platform: {
                    this.info.setSupportedPlatforms(text);
                    break;
                }
                case searchpath: {
                    this.info.addSearchPath(text);
                }
            }
        }
    }

    static enum Context {
        unknown,
        root,
        terminaldefinition,
        terminal,
        searchpaths,
        searchpath,
        arguments,
        argument,
        validation,
        validation_platform,
        validation_test;

    }
}

