/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.signals;

import java.util.Collection;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.signals.SignalSupportImplementation;
import org.openide.util.Lookup;

public final class SignalSupport {
    public static int signalProcess(ExecutionEnvironment env, int pid, Signal signal) {
        Collection impls = Lookup.getDefault().lookupAll(SignalSupportImplementation.class);
        for (SignalSupportImplementation impl : impls) {
            if (!impl.isSupported(env, SIGNAL_SCOPE.SIGNAL_PROCESS)) continue;
            try {
                return impl.sendSignal(env, SIGNAL_SCOPE.SIGNAL_PROCESS, pid, signal);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        throw new UnsupportedOperationException("Sending signal to a pid is not supported on " + env.getDisplayName());
    }

    public static int signalProcessGroup(ExecutionEnvironment env, int gid, Signal signal) {
        Collection impls = Lookup.getDefault().lookupAll(SignalSupportImplementation.class);
        for (SignalSupportImplementation impl : impls) {
            if (!impl.isSupported(env, SIGNAL_SCOPE.SIGNAL_GROUP)) continue;
            try {
                return impl.sendSignal(env, SIGNAL_SCOPE.SIGNAL_GROUP, gid, signal);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        throw new UnsupportedOperationException("Sending signal to a group of processes is not supported on " + env.getDisplayName());
    }

    public static int signalProcessSession(ExecutionEnvironment env, int psid, Signal signal) {
        Collection impls = Lookup.getDefault().lookupAll(SignalSupportImplementation.class);
        for (SignalSupportImplementation impl : impls) {
            if (!impl.isSupported(env, SIGNAL_SCOPE.SIGNAL_SESSION)) continue;
            try {
                return impl.sendSignal(env, SIGNAL_SCOPE.SIGNAL_SESSION, psid, signal);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        throw new UnsupportedOperationException("Sending signal to a session of processes is not supported on " + env.getDisplayName());
    }

    public static int signalProcessesByEnv(ExecutionEnvironment env, String environment, Signal signal) {
        Collection impls = Lookup.getDefault().lookupAll(SignalSupportImplementation.class);
        for (SignalSupportImplementation impl : impls) {
            if (!impl.isSupported(env, SIGNAL_SCOPE.SIGNAL_BY_ENV)) continue;
            try {
                return impl.sendSignal(env, environment, signal);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        throw new UnsupportedOperationException("Sending signal to processes by env is not supported on " + env.getDisplayName());
    }

    public static int sigqueue(ExecutionEnvironment env, int pid, Signal signal, int sigvalue) {
        Collection impls = Lookup.getDefault().lookupAll(SignalSupportImplementation.class);
        int result = 0;
        for (SignalSupportImplementation impl : impls) {
            if (!impl.isSupported(env, SIGNAL_SCOPE.SIGQUEUE_PROCESS)) continue;
            try {
                result = impl.sigqueue(env, pid, signal, sigvalue);
                if (result < 0) continue;
                return result;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        if (result == 0) {
            throw new UnsupportedOperationException("Sigqueue is not supported on " + env.getDisplayName());
        }
        return result;
    }

    public static enum SIGNAL_SCOPE {
        SIGNAL_PROCESS,
        SIGNAL_GROUP,
        SIGNAL_SESSION,
        SIGNAL_BY_ENV,
        SIGQUEUE_PROCESS;

    }
}

