/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.signals.impl;

import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.signals.SignalSupport;
import org.netbeans.modules.nativeexecution.signals.SignalSupportImplementation;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.ShellSession;

public final class SignalSupportImpl
implements SignalSupportImplementation {
    private static final java.util.logging.Logger log = Logger.getInstance();

    @Override
    public boolean isSupported(ExecutionEnvironment env, SignalSupport.SIGNAL_SCOPE scope) {
        if (!HostInfoUtils.isHostInfoAvailable(env)) {
            return false;
        }
        try {
            if (this.isWindows(env) && WindowsSupport.getInstance().getActiveShell() == null) {
                return false;
            }
            switch (scope) {
                case SIGNAL_BY_ENV: 
                case SIGNAL_SESSION: 
                case SIGQUEUE_PROCESS: {
                    return false;
                }
                case SIGNAL_PROCESS: 
                case SIGNAL_GROUP: {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, "SignalSupportImpl.isSupported()", ex);
        }
        return false;
    }

    @Override
    public int sendSignal(ExecutionEnvironment env, SignalSupport.SIGNAL_SCOPE scope, int id, Signal signal) {
        try {
            StringBuilder cmd = new StringBuilder("kill -");
            cmd.append(signal == Signal.NULL ? "0" : signal.name().substring(3));
            cmd.append(SignalSupport.SIGNAL_SCOPE.SIGNAL_GROUP.equals((Object)scope) ? " -" : " ");
            cmd.append(id);
            ProcessUtils.ExitStatus status = ShellSession.execute(env, cmd.toString());
            return status.exitCode;
        }
        catch (IOException ex) {
            log.log(Level.FINE, "SignalSupportImpl.sendSignal()", ex);
            return -1;
        }
    }

    @Override
    public int sendSignal(ExecutionEnvironment env, String environment, Signal signal) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int sigqueue(ExecutionEnvironment env, int id, Signal signal, int value) {
        throw new UnsupportedOperationException("Not supported.");
    }

    private boolean isWindows(ExecutionEnvironment env) throws IOException, ConnectionManager.CancellationException {
        HostInfo hinfo = HostInfoUtils.getHostInfo(env);
        return HostInfo.OSFamily.WINDOWS.equals((Object)hinfo.getOSFamily());
    }
}

