/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.pty;

import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.nativeexecution.api.util.HelperUtility;
import org.openide.util.Exceptions;

final class PtyOpenUtility
extends HelperUtility {
    private static final PtyOpenUtility instance = new PtyOpenUtility();

    private PtyOpenUtility() {
        super("bin/nativeexecution/$osname-${platform}$_isa/pty_open");
    }

    public static PtyOpenUtility getInstance() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PtyInfo readSatelliteOutput(InputStream input) {
        int pid = -1;
        String tty = null;
        boolean stop = false;
        int state = 0;
        StringBuilder sb = new StringBuilder();
        try {
            char c;
            block8: while (!stop && (c = (char)input.read()) != '\uffff') {
                switch (c) {
                    case '\n': {
                        if (state == 1) {
                            pid = Integer.parseInt(sb.toString());
                            ++state;
                            continue block8;
                        }
                        if (state == 2) {
                            tty = sb.toString();
                            ++state;
                            continue block8;
                        }
                        stop = true;
                        continue block8;
                    }
                    case 'P': {
                        state = 1;
                        continue block8;
                    }
                    case 'T': {
                        state = 2;
                        continue block8;
                    }
                    case ' ': {
                        sb.setLength(0);
                        continue block8;
                    }
                }
                sb.append(c);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (tty != null && pid >= 0) {
            return new PtyInfo(pid, tty);
        }
        return null;
    }

    static final class PtyInfo {
        final int pid;
        final String tty;

        public PtyInfo(int pid, String tty) {
            this.pid = pid;
            this.tty = tty;
        }
    }
}

