/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.ui;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Pattern;
import org.netbeans.modules.nativeexecution.api.util.Authentication;

public class SSHKeyFileFilter
implements FileFilter {
    private static final Pattern pattern = Pattern.compile("-+ *BEGIN.*PRIVATE.*KEY *-+.*");
    private static final SSHKeyFileFilter instance = new SSHKeyFileFilter();

    private SSHKeyFileFilter() {
    }

    public static SSHKeyFileFilter getInstance() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (!file.canRead()) {
            return false;
        }
        long flen = file.length();
        if (flen < 100L) return false;
        if (flen > 10000L) {
            return false;
        }
        int limit = 40;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), limit);){
            int c;
            StringBuilder head = new StringBuilder(limit);
            for (int n = 0; n < limit && (c = ((InputStream)is).read()) != -1 && c != 10 && c != 13; ++n) {
                head.append((char)c);
            }
            if (pattern.matcher(head).matches()) return Authentication.isValidSSHKeyFile((String)file.getAbsolutePath());
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

