/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

public class BreakpointModelActiveSessionFilter
implements ExtendedNodeModelFilter,
PropertyChangeListener {
    private static final String DEACTIVATED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/Breakpoint_stroke.png";
    private static final String DEACTIVATED_DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/DisabledBreakpoint_stroke.png";
    private static final String DEACTIVATED_NONLINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/Breakpoint_nonline_stroke.png";
    private static final String DEACTIVATED_DISABLED_NONLINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/DisabledBreakpoint_nonline_stroke.png";
    private static final RequestProcessor RP = new RequestProcessor(BreakpointModelActiveSessionFilter.class.getName());
    private JPDADebugger debugger;
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();

    public BreakpointModelActiveSessionFilter(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.debugger));
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        return original.getDisplayName(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        return original.getShortDescription(node);
    }

    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (!this.debugger.getBreakpointsActive()) {
            if (node instanceof LineBreakpoint) {
                LineBreakpoint breakpoint = (LineBreakpoint)node;
                if (!breakpoint.isEnabled()) {
                    return DEACTIVATED_DISABLED_LINE_BREAKPOINT;
                }
                return DEACTIVATED_LINE_BREAKPOINT;
            }
            if (node instanceof JPDABreakpoint) {
                JPDABreakpoint breakpoint = (JPDABreakpoint)node;
                if (!breakpoint.isEnabled()) {
                    return DEACTIVATED_DISABLED_NONLINE_BREAKPOINT;
                }
                return DEACTIVATED_NONLINE_BREAKPOINT;
            }
        }
        return original.getIconBaseWithExtension(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported, overriden by getIconBaseWithExtension().");
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canRename(node);
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCopy(node);
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCut(node);
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCopy(node);
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCut(node);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        return original.getPasteTypes(node, t);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("breakpointsActive".equals(propertyName)) {
            this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, null, 2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ModelEvent me) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener ml : ls) {
            ml.modelChanged(me);
        }
    }
}

