/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContextChild;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class CurrentThreadAnnotationListener
extends DebuggerManagerAdapter {
    private static final int ANNOTATION_SCHEDULE_TIME = 100;
    private static final int ANNOTATION_STACK_SCHEDULE_TIME = 500;
    private transient Object currentPC;
    private final transient Object currentPCLock = new Object();
    private transient boolean currentPCSet = false;
    private JPDAThread currentThread;
    private JPDADebugger currentDebugger;
    private SourcePath currentSourcePath;
    private AllThreadsAnnotator allThreadsAnnotator;
    private static final String PROP_OPERATIONS_UPDATE = "operationsUpdate";
    private static final String PROP_OPERATIONS_SET = "operationsSet";
    private HashMap stackAnnotations = new HashMap();
    private final RequestProcessor rp = new RequestProcessor("Debugger Thread Annotation Refresher");
    private RequestProcessor.Task taskRemove;
    private RequestProcessor.Task taskAnnotate;
    private JPDAThread threadToAnnotate;
    private CallStackFrame[] stackToAnnotate;
    private SourcePath sourcePathToAnnotate;

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("currentEngine".equals(propertyName)) {
            this.updateCurrentDebugger((DebuggerEngine)e.getNewValue());
            this.updateCurrentThread();
            this.annotate();
        } else if ("currentThread".equals(propertyName)) {
            this.updateCurrentThread((JPDAThread)e.getNewValue());
            this.annotate();
        } else if ("currentCallStackFrame".equals(propertyName)) {
            this.showCurrentFrame((CallStackFrame)e.getNewValue());
        } else if ("state".equals(propertyName)) {
            this.annotate();
        } else if ("threadStarted".equals(propertyName)) {
            CurrentThreadAnnotationListener currentThreadAnnotationListener = this;
            synchronized (currentThreadAnnotationListener) {
                if (this.allThreadsAnnotator != null) {
                    this.allThreadsAnnotator.add((JPDAThread)e.getNewValue());
                }
            }
        }
    }

    private synchronized void updateCurrentDebugger(DebuggerEngine currentEngine) {
        JPDADebugger newDebugger = currentEngine == null ? null : (JPDADebugger)currentEngine.lookupFirst(null, JPDADebugger.class);
        if (this.currentDebugger == newDebugger) {
            return;
        }
        if (this.currentDebugger != null) {
            this.currentDebugger.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.allThreadsAnnotator != null) {
            this.allThreadsAnnotator.cancel();
            this.allThreadsAnnotator = null;
        }
        this.currentSourcePath = null;
        if (newDebugger != null) {
            newDebugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.allThreadsAnnotator = new AllThreadsAnnotator(newDebugger);
            this.currentSourcePath = this.getCurrentSourcePath(newDebugger);
        }
        this.currentDebugger = newDebugger;
        if (this.currentThread != null && this.allThreadsAnnotator != null) {
            this.allThreadsAnnotator.remove(this.currentThread);
            this.currentThread = null;
        }
        this.updateCurrentThread();
    }

    private synchronized void updateCurrentThread() {
        this.updateCurrentThread(this.currentDebugger != null ? this.currentDebugger.getCurrentThread() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateCurrentThread(JPDAThread newCurrentThread) {
        JPDAThread oldCurrent = null;
        JPDAThread newCurrent = null;
        CurrentThreadAnnotationListener currentThreadAnnotationListener = this;
        synchronized (currentThreadAnnotationListener) {
            oldCurrent = this.currentThread;
            if (this.currentDebugger != null) {
                newCurrent = this.currentThread = newCurrentThread;
            } else {
                this.currentThread = null;
            }
            AllThreadsAnnotator allThreadsAnnotator = this.allThreadsAnnotator;
            if (allThreadsAnnotator != null) {
                if (oldCurrent != null) {
                    allThreadsAnnotator.annotate(oldCurrent, false);
                }
                if (newCurrent != null) {
                    allThreadsAnnotator.annotate(newCurrent, true);
                }
            }
        }
    }

    private SourcePath getCurrentSourcePath(JPDADebugger debugger) {
        Session currentSession = null;
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i].lookupFirst(null, JPDADebugger.class) != debugger) continue;
            currentSession = sessions[i];
            break;
        }
        DebuggerEngine currentEngine = currentSession == null ? null : currentSession.getCurrentEngine();
        SourcePath sourcePath = currentEngine == null ? null : (SourcePath)currentEngine.lookupFirst(null, SourcePath.class);
        return sourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate() {
        Session s;
        JPDAThread thread;
        SourcePath sourcePath;
        JPDADebugger debugger;
        CurrentThreadAnnotationListener currentThreadAnnotationListener = this;
        synchronized (currentThreadAnnotationListener) {
            debugger = this.currentDebugger;
            if (this.currentThread == null || debugger.getState() != 3) {
                Object object = this.currentPCLock;
                synchronized (object) {
                    this.currentPCSet = false;
                }
                this.removeAnnotations();
                return;
            }
            sourcePath = this.currentSourcePath;
            thread = this.currentThread;
        }
        try {
            s = (Session)debugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)debugger, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            s = null;
        }
        RequestProcessor rProcessor = null;
        if (s != null) {
            rProcessor = (RequestProcessor)s.lookupFirst(null, RequestProcessor.class);
        }
        if (rProcessor == null) {
            rProcessor = this.rp;
        }
        rProcessor.post(new Runnable(){

            @Override
            public void run() {
                CurrentThreadAnnotationListener.this.annotate(debugger, thread, sourcePath);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate(JPDADebugger debugger, JPDAThread currentThread, SourcePath sourcePath) {
        Session s;
        CallStackFrame[] stack = null;
        CallStackFrame csf = debugger.getCurrentCallStackFrame();
        try {
            s = (Session)debugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)debugger, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            s = null;
        }
        String language = s != null ? s.getCurrentLanguage() : null;
        Object ex = this.currentPCLock;
        synchronized (ex) {
            this.currentPCSet = true;
        }
        if (csf != null && sourcePath != null && currentThread != null) {
            CallStackFrame frameToShow = csf;
            int lineNumber = frameToShow.getLineNumber(language);
            if (lineNumber < 1) {
                try {
                    stack = currentThread.getCallStack();
                }
                catch (AbsentInformationException ex2) {
                    Object object = this.currentPCLock;
                    synchronized (object) {
                        this.currentPCSet = false;
                    }
                    this.removeAnnotations();
                    return;
                }
                block10: for (int x = 0; x < stack.length; ++x) {
                    if (!csf.equals(stack[x])) continue;
                    for (int xx = x + 1; xx < stack.length; ++xx) {
                        if (stack[xx].getLineNumber(language) < 1) continue;
                        frameToShow = stack[xx];
                        break block10;
                    }
                    break;
                }
            }
            sourcePath.showSource(frameToShow, language);
        }
        int lineNumber = currentThread.getLineNumber(language);
        String url = this.getTheURL(sourcePath, currentThread, language);
        this.annotateCurrentPosition(currentThread, sourcePath, csf, language, url, lineNumber);
        this.annotateCallStack(currentThread, stack, sourcePath);
    }

    private void annotateCurrentPosition(final JPDAThread currentThread, final SourcePath sourcePath, final CallStackFrame csf, final String language, final String url, final int lineNumber) {
        final Runnable updateCurrentAnnotation = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CurrentThreadAnnotationListener.this.currentPCLock;
                synchronized (object) {
                    if (CurrentThreadAnnotationListener.this.currentPC != null) {
                        EditorContextBridge.getContext().removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                    }
                    if (csf != null && sourcePath != null && currentThread != null && url != null && lineNumber >= 0) {
                        CurrentThreadAnnotationListener.this.currentPC = sourcePath.annotate(currentThread, language, url, lineNumber);
                    } else {
                        CurrentThreadAnnotationListener.this.currentPC = null;
                    }
                }
            }
        };
        PropertyChangeListener operationsUpdateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (CurrentThreadAnnotationListener.PROP_OPERATIONS_UPDATE.equals(name)) {
                    SwingUtilities.invokeLater(updateCurrentAnnotation);
                }
                if (CurrentThreadAnnotationListener.PROP_OPERATIONS_SET.equals(name)) {
                    ((BeanContextChild)currentThread).removePropertyChangeListener(CurrentThreadAnnotationListener.PROP_OPERATIONS_UPDATE, this);
                    ((BeanContextChild)currentThread).removePropertyChangeListener(CurrentThreadAnnotationListener.PROP_OPERATIONS_SET, this);
                }
            }
        };
        ((BeanContextChild)currentThread).addPropertyChangeListener(PROP_OPERATIONS_UPDATE, operationsUpdateListener);
        ((BeanContextChild)currentThread).addPropertyChangeListener(PROP_OPERATIONS_SET, operationsUpdateListener);
        SwingUtilities.invokeLater(updateCurrentAnnotation);
    }

    private String getTheURL(SourcePath sourcePath, JPDAThread currentThread, String language) {
        return sourcePath.getURL(currentThread, language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCurrentFrame(CallStackFrame frame) {
        JPDADebugger dbg;
        SourcePath sp;
        if (frame == null) {
            return;
        }
        CurrentThreadAnnotationListener currentThreadAnnotationListener = this;
        synchronized (currentThreadAnnotationListener) {
            sp = this.currentSourcePath;
            dbg = this.currentDebugger;
        }
        if (sp != null && dbg != null) {
            Session s;
            try {
                s = (Session)dbg.getClass().getMethod("getSession", new Class[0]).invoke((Object)dbg, new Object[0]);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
                return;
            }
            sp.showSource(frame, s.getCurrentLanguage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotations() {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove == null) {
                this.taskRemove = this.rp.create((Runnable)new RemoveAnnotationsTask());
            }
            if (this.taskAnnotate != null) {
                this.taskAnnotate.cancel();
            }
        }
        this.taskRemove.schedule(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateCallStack(JPDAThread thread, CallStackFrame[] stack, SourcePath sourcePath) {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove != null) {
                this.taskRemove.cancel();
            }
            this.threadToAnnotate = thread;
            this.stackToAnnotate = stack;
            this.sourcePathToAnnotate = sourcePath;
            if (this.taskAnnotate == null) {
                this.taskAnnotate = this.rp.create((Runnable)new AnnotateCallStackTask());
            }
        }
        this.taskAnnotate.schedule(500);
    }

    static /* synthetic */ CallStackFrame[] access$1202(CurrentThreadAnnotationListener x0, CallStackFrame[] x1) {
        x0.stackToAnnotate = x1;
        return x1;
    }

    private class AllThreadsAnnotator
    implements Runnable,
    PropertyChangeListener {
        private boolean active = true;
        private final JPDADebugger debugger;
        private final Map<JPDAThread, Object> threadAnnotations = new HashMap<JPDAThread, Object>();
        private final Set<JPDAThread> threadsToAnnotate = new HashSet<JPDAThread>();
        private final Map<JPDAThread, FutureAnnotation> futureAnnotations = new HashMap<JPDAThread, FutureAnnotation>();
        private final Set<Object> annotationsToRemove = new HashSet<Object>();
        private final RequestProcessor.Task task;

        public AllThreadsAnnotator(JPDADebugger debugger) {
            this.debugger = debugger;
            this.task = CurrentThreadAnnotationListener.this.rp.create((Runnable)this);
            for (JPDAThread t : debugger.getThreadsCollector().getAllThreads()) {
                this.add(t);
            }
        }

        private void add(JPDAThread t) {
            ((Customizer)t).addPropertyChangeListener(this);
            this.annotate(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(JPDAThread t) {
            ((Customizer)t).removePropertyChangeListener(this);
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                Object annotation = this.threadAnnotations.remove(t);
                if (annotation != null) {
                    this.threadsToAnnotate.remove(t);
                    this.annotationsToRemove.add(annotation);
                    this.task.schedule(100);
                }
            }
        }

        private synchronized void cancel() {
            this.active = false;
            for (JPDAThread t : new HashSet<JPDAThread>(this.threadAnnotations.keySet())) {
                this.remove(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                if (!this.active) {
                    ((Customizer)evt.getSource()).removePropertyChangeListener(this);
                    return;
                }
            }
            JPDAThread t = (JPDAThread)evt.getSource();
            this.annotate(t);
        }

        private void annotate(JPDAThread t) {
            this.annotate(t, t == this.debugger.getCurrentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void annotate(JPDAThread t, boolean isCurrentThread) {
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                Object annotation = this.threadAnnotations.remove(t);
                if (annotation != null) {
                    this.threadsToAnnotate.remove(t);
                    this.annotationsToRemove.add(annotation);
                    this.task.schedule(100);
                }
                if (!isCurrentThread && t.isSuspended()) {
                    this.threadsToAnnotate.add(t);
                    FutureAnnotation future = this.futureAnnotations.get(t);
                    if (future == null) {
                        future = new FutureAnnotation(t);
                    }
                    this.threadAnnotations.put(t, future);
                    this.futureAnnotations.put(t, future);
                    this.task.schedule(100);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Session s;
            SourcePath theCurrentSourcePath;
            HashMap<JPDAThread, FutureAnnotation> futureAnnotations;
            HashSet<JPDAThread> threadsToAnnotate;
            HashSet<Object> annotationsToRemove;
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                annotationsToRemove = new HashSet<Object>(this.annotationsToRemove);
                this.annotationsToRemove.clear();
                threadsToAnnotate = new HashSet<JPDAThread>(this.threadsToAnnotate);
                this.threadsToAnnotate.clear();
                futureAnnotations = new HashMap<JPDAThread, FutureAnnotation>(this.futureAnnotations);
                this.futureAnnotations.clear();
                theCurrentSourcePath = CurrentThreadAnnotationListener.this.currentSourcePath;
            }
            for (Object e : annotationsToRemove) {
                void var6_7;
                Object object;
                if (e instanceof FutureAnnotation && (object = ((FutureAnnotation)e).getAnnotation()) == null) continue;
                EditorContextBridge.getContext().removeAnnotation((Object)var6_7);
            }
            HashMap<JPDAThread, FutureAnnotation> threadFutureAnnotations = new HashMap<JPDAThread, FutureAnnotation>();
            HashSet<JPDAThread> hashSet = new HashSet<JPDAThread>();
            try {
                s = (Session)this.debugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)this.debugger, new Object[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                s = null;
            }
            String language = s != null ? s.getCurrentLanguage() : null;
            for (JPDAThread t : threadsToAnnotate) {
                Object annotation;
                if (theCurrentSourcePath != null) {
                    int lineNumber = t.getLineNumber(language);
                    String url = CurrentThreadAnnotationListener.this.getTheURL(theCurrentSourcePath, t, language);
                    annotation = theCurrentSourcePath.annotate(t, language, url, lineNumber, false);
                } else {
                    annotation = null;
                }
                if (annotation != null) {
                    FutureAnnotation fa = (FutureAnnotation)futureAnnotations.get(t);
                    fa.setAnnotation(annotation);
                    threadFutureAnnotations.put(t, fa);
                    continue;
                }
                hashSet.add(t);
            }
            AllThreadsAnnotator allThreadsAnnotator2 = this;
            synchronized (allThreadsAnnotator2) {
                this.threadAnnotations.keySet().removeAll(hashSet);
                for (JPDAThread t : threadFutureAnnotations.keySet()) {
                    FutureAnnotation fa = (FutureAnnotation)threadFutureAnnotations.get(t);
                    if (this.annotationsToRemove.contains(fa)) continue;
                    this.threadAnnotations.put(t, fa.getAnnotation());
                }
            }
        }

        private final class FutureAnnotation {
            private JPDAThread thread;
            private Object annotation;

            public FutureAnnotation(JPDAThread thread) {
                this.thread = thread;
            }

            public JPDAThread getThread() {
                return this.thread;
            }

            public void setAnnotation(Object annotation) {
                this.annotation = annotation;
            }

            public Object getAnnotation() {
                return this.annotation;
            }

            public String toString() {
                return "Future annotation (" + this.annotation + ") for " + this.thread;
            }
        }
    }

    private class AnnotateCallStackTask
    implements Runnable {
        private AnnotateCallStackTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SourcePath sourcePath;
            CallStackFrame[] stack;
            JPDAThread thread = null;
            RequestProcessor requestProcessor = CurrentThreadAnnotationListener.this.rp;
            synchronized (requestProcessor) {
                if (CurrentThreadAnnotationListener.this.stackToAnnotate == null) {
                    if (CurrentThreadAnnotationListener.this.threadToAnnotate != null) {
                        thread = CurrentThreadAnnotationListener.this.threadToAnnotate;
                    } else {
                        return;
                    }
                }
                stack = CurrentThreadAnnotationListener.this.stackToAnnotate;
                sourcePath = CurrentThreadAnnotationListener.this.sourcePathToAnnotate;
                CurrentThreadAnnotationListener.this.threadToAnnotate = null;
                CurrentThreadAnnotationListener.access$1202(CurrentThreadAnnotationListener.this, null);
                CurrentThreadAnnotationListener.this.sourcePathToAnnotate = null;
            }
            if (thread != null) {
                try {
                    stack = thread.getCallStack();
                }
                catch (AbsentInformationException ex) {
                    return;
                }
            }
            HashMap newAnnotations = new HashMap();
            int k = stack.length;
            for (int i = 1; i < k; ++i) {
                String language = stack[i].getDefaultStratum();
                String resourceName = EditorContextBridge.getRelativePath(stack[i], language);
                int lineNumber = stack[i].getLineNumber(language);
                String line = resourceName + lineNumber;
                if (newAnnotations.containsKey(line)) continue;
                Object da = CurrentThreadAnnotationListener.this.stackAnnotations.remove(line);
                if (da == null) {
                    da = sourcePath.annotate(stack[i], language);
                }
                if (da == null) continue;
                newAnnotations.put(line, da);
            }
            Iterator iter = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
            while (iter.hasNext()) {
                EditorContextBridge.getContext().removeAnnotation(iter.next());
            }
            CurrentThreadAnnotationListener.this.stackAnnotations = newAnnotations;
        }
    }

    private class RemoveAnnotationsTask
    implements Runnable {
        private RemoveAnnotationsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CurrentThreadAnnotationListener.this.currentPCLock;
            synchronized (object) {
                if (CurrentThreadAnnotationListener.this.currentPCSet) {
                    return;
                }
                if (CurrentThreadAnnotationListener.this.currentPC != null) {
                    EditorContextBridge.getContext().removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                }
                CurrentThreadAnnotationListener.this.currentPC = null;
            }
            Iterator i = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
            while (i.hasNext()) {
                EditorContextBridge.getContext().removeAnnotation(i.next());
            }
            CurrentThreadAnnotationListener.this.stackAnnotations.clear();
        }
    }
}

