/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TreeSet;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.OutlineComboBox;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

abstract class BreakpointsExpandableGroup<T>
implements OutlineComboBox.Expandable {
    private boolean expanded = false;
    private T[] items;

    BreakpointsExpandableGroup() {
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public T[] getItems() {
        if (this.items == null) {
            this.items = this.createItems();
        }
        return this.items;
    }

    protected abstract T[] createItems();

    private static String getFormattedValue(String format, String newString) {
        int i2ns;
        int i;
        for (i = 0; i < newString.length() && i < format.length() && Character.toUpperCase(newString.charAt(i)) == Character.toUpperCase(format.charAt(i)); ++i) {
        }
        int i2 = format.length() - 1;
        for (i2ns = newString.length() - 1; i2 > i && i2ns > i && Character.toUpperCase(newString.charAt(i2ns)) == Character.toUpperCase(format.charAt(i2)); --i2, --i2ns) {
        }
        if (i >= i2 && i <= i2ns) {
            return newString.substring(i, i2ns + 1);
        }
        return null;
    }

    static class TypeItem
    implements Comparable<TypeItem>,
    OutlineComboBox.PopupMenuItem {
        private String type;

        public TypeItem(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TypeItem && ((TypeItem)obj).type.equals(this.type);
        }

        @Override
        public int compareTo(TypeItem o) {
            return o.toString().compareTo(this.toString());
        }

        public String toString() {
            return NbBundle.getMessage(ActionsPanel.class, (String)"LBL_TypeGroupItem", (Object)this.type);
        }

        @Override
        public String toPopupMenuString() {
            return this.type;
        }

        public static Object valueOf(String newString) {
            String format = NbBundle.getMessage(ActionsPanel.class, (String)"LBL_ProjectGroupItem", (Object)"");
            String type = BreakpointsExpandableGroup.getFormattedValue(format, newString);
            if (type != null) {
                return new TypeItem(type);
            }
            return newString;
        }
    }

    static class ProjectItem
    implements Comparable<ProjectItem>,
    OutlineComboBox.PopupMenuItem {
        private Project p;

        public ProjectItem(Project p) {
            this.p = p;
        }

        public Project getProject() {
            return this.p;
        }

        public int hashCode() {
            return this.p.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ProjectItem && ((ProjectItem)obj).p.equals(this.p);
        }

        @Override
        public int compareTo(ProjectItem o) {
            return o.toString().compareTo(this.toString());
        }

        public String toString() {
            return NbBundle.getMessage(ActionsPanel.class, (String)"LBL_ProjectGroupItem", (Object)this.p.getProjectDirectory().getPath());
        }

        @Override
        public String toPopupMenuString() {
            return ProjectUtils.getInformation((Project)this.p).getDisplayName();
        }

        public static Object valueOf(String newString) {
            FileObject fo;
            String format = NbBundle.getMessage(ActionsPanel.class, (String)"LBL_ProjectGroupItem", (Object)"");
            String dir = BreakpointsExpandableGroup.getFormattedValue(format, newString);
            if (dir != null && (fo = FileUtil.toFileObject((File)new File(dir))) != null) {
                try {
                    Project project = ProjectManager.getDefault().findProject(fo);
                    if (project != null) {
                        return new ProjectItem(project);
                    }
                }
                catch (IOException iOException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return newString;
        }
    }

    static class FileItem
    implements Comparable<FileItem>,
    OutlineComboBox.PopupMenuItem {
        private FileObject fo;

        public FileItem(FileObject fo) {
            this.fo = fo;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public int hashCode() {
            return this.fo.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof FileItem && ((FileItem)obj).fo.equals(this.fo);
        }

        @Override
        public int compareTo(FileItem o) {
            return o.toString().compareTo(this.toString());
        }

        public String toString() {
            try {
                return this.fo.getURL().toExternalForm();
            }
            catch (FileStateInvalidException ex) {
                return "file://" + this.fo.getPath();
            }
        }

        @Override
        public String toPopupMenuString() {
            return this.fo.getNameExt();
        }

        public static Object valueOf(String newString) {
            URL url;
            try {
                url = new URL(newString);
            }
            catch (MalformedURLException ex) {
                return newString;
            }
            FileObject fo = URLMapper.findFileObject((URL)url);
            if (fo != null) {
                return new FileItem(fo);
            }
            return newString;
        }
    }

    static class TypesGroup
    extends BreakpointsExpandableGroup<TypeItem> {
        TypesGroup() {
        }

        public TypeItem[] createItems() {
            TreeSet<TypeItem> items = new TreeSet<TypeItem>();
            Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
            for (int i = 0; i < bs.length; ++i) {
                String type;
                Breakpoint.GroupProperties groupProperties = bs[i].getGroupProperties();
                if (groupProperties == null || (type = groupProperties.getType()) == null) continue;
                items.add(new TypeItem(type));
            }
            return items.toArray(new TypeItem[0]);
        }

        public String toString() {
            return NbBundle.getMessage(ActionsPanel.class, (String)"LBL_TypesGroup");
        }
    }

    static class ProjectsGroup
    extends BreakpointsExpandableGroup<ProjectItem> {
        ProjectsGroup() {
        }

        public ProjectItem[] createItems() {
            TreeSet<ProjectItem> items = new TreeSet<ProjectItem>();
            Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
            for (int i = 0; i < bs.length; ++i) {
                Project[] projects;
                Breakpoint.GroupProperties groupProperties = bs[i].getGroupProperties();
                if (groupProperties == null || (projects = groupProperties.getProjects()) == null) continue;
                for (Project p : projects) {
                    items.add(new ProjectItem(p));
                }
            }
            return items.toArray(new ProjectItem[0]);
        }

        public String toString() {
            return NbBundle.getMessage(ActionsPanel.class, (String)"LBL_ProjectsGroup");
        }
    }

    static class FilesGroup
    extends BreakpointsExpandableGroup<FileItem> {
        FilesGroup() {
        }

        public FileItem[] createItems() {
            TreeSet<FileItem> items = new TreeSet<FileItem>();
            Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
            for (int i = 0; i < bs.length; ++i) {
                FileObject[] files;
                Breakpoint.GroupProperties groupProperties = bs[i].getGroupProperties();
                if (groupProperties == null || (files = groupProperties.getFiles()) == null) continue;
                for (FileObject fo : files) {
                    items.add(new FileItem(fo));
                }
            }
            return items.toArray(new FileItem[0]);
        }

        public String toString() {
            return NbBundle.getMessage(ActionsPanel.class, (String)"LBL_FilesGroup");
        }
    }
}

