/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.base.ProcessBuilder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.debugger.jpda.truffle.RemoteServices;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class MIMETypes {
    private static final Logger LOG = Logger.getLogger(MIMETypes.class.getName());
    public static final String PROP_MIME_TYPES = "MIME types";
    private static final String MIME_TYPES_MAIN = "org.netbeans.modules.debugger.jpda.backend.truffle.GetMIMETypes";
    private static final MIMETypes INSTANCE = new MIMETypes();
    private static String TEMP_TRUFFLE_JAR;
    private final Map<JavaPlatform, Set<String>> platformMIMETypes = new WeakHashMap<JavaPlatform, Set<String>>();
    private Set<String> allPlatformsMIMETypes;
    private PropertyChangeListener allPlatformsListener;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    private MIMETypes() {
    }

    public static MIMETypes getDefault() {
        return INSTANCE;
    }

    public Set<String> get(Project prj) {
        JavaPlatform jp = MIMETypes.getProjectPlatform(prj);
        if (jp == null) {
            return Collections.emptySet();
        }
        return this.get(jp);
    }

    private synchronized Set<String> get(JavaPlatform jp) {
        Set<String> mTypes = this.platformMIMETypes.get(jp);
        if (mTypes == null) {
            File javaFile;
            FileObject graalvm = jp.findTool("polyglot");
            FileObject java = jp.findTool("java");
            if (graalvm != null && java != null && (javaFile = FileUtil.toFile((FileObject)java)) != null) {
                ProcessBuilder pb = ProcessBuilder.getLocal();
                pb.setExecutable(javaFile.getAbsolutePath());
                try {
                    pb.setArguments(Arrays.asList("-cp", MIMETypes.getTruffleJarPath(), MIME_TYPES_MAIN));
                    Process proc = pb.call();
                    try (BufferedReader r = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                        String line;
                        mTypes = new HashSet<String>();
                        while ((line = r.readLine()) != null) {
                            mTypes.add(line);
                        }
                    }
                    r = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    var9_10 = null;
                    try {
                        while ((line = r.readLine()) != null) {
                            LOG.info("Error from " + javaFile + " : " + line);
                        }
                    }
                    catch (Throwable throwable) {
                        var9_10 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (r != null) {
                            if (var9_10 != null) {
                                try {
                                    r.close();
                                }
                                catch (Throwable throwable) {
                                    var9_10.addSuppressed(throwable);
                                }
                            } else {
                                r.close();
                            }
                        }
                    }
                    LOG.log(Level.FINE, "MIME types of {0} are: {1}", new Object[]{jp, mTypes});
                }
                catch (IOException ioex) {
                    LOG.log(Level.CONFIG, "", ioex);
                }
            }
            if (mTypes == null) {
                mTypes = Collections.emptySet();
            }
            this.platformMIMETypes.put(jp, mTypes);
        }
        return mTypes;
    }

    private static synchronized String getTruffleJarPath() throws IOException {
        if (TEMP_TRUFFLE_JAR == null) {
            File truffleJarFile = File.createTempFile("TmpTruffleBcknd", ".jar");
            truffleJarFile.deleteOnExit();
            FileUtil.copy((InputStream)RemoteServices.openRemoteClasses(), (OutputStream)new FileOutputStream(truffleJarFile));
            TEMP_TRUFFLE_JAR = truffleJarFile.getAbsolutePath();
        }
        return TEMP_TRUFFLE_JAR;
    }

    public synchronized Set<String> get() {
        if (this.allPlatformsMIMETypes != null) {
            return this.allPlatformsMIMETypes;
        }
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        if (this.allPlatformsListener == null) {
            this.allPlatformsListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MIMETypes mIMETypes = MIMETypes.this;
                    synchronized (mIMETypes) {
                        MIMETypes.this.allPlatformsMIMETypes = null;
                    }
                    MIMETypes.this.pcs.firePropertyChange(MIMETypes.PROP_MIME_TYPES, null, null);
                }
            };
            pm.addPropertyChangeListener(this.allPlatformsListener);
        }
        JavaPlatform[] installedPlatforms = pm.getPlatforms(null, new Specification("j2se", null));
        HashSet<String> mTypes = new HashSet<String>();
        for (int i = 0; i < installedPlatforms.length; ++i) {
            mTypes.addAll(this.get(installedPlatforms[i]));
        }
        this.allPlatformsMIMETypes = mTypes;
        return mTypes;
    }

    public synchronized Set<String> getCached() {
        return this.allPlatformsMIMETypes;
    }

    private static JavaPlatform getProjectPlatform(Project prj) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)prj).getSourceGroups("java");
        ClassPath bootClassPath = ClassPath.getClassPath((FileObject)sourceGroups[0].getRootFolder(), (String)"classpath/boot");
        Object[] prjBootRoots = bootClassPath.getRoots();
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        JavaPlatform[] installedPlatforms = pm.getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            ClassPath bootstrapLibraries = installedPlatforms[i].getBootstrapLibraries();
            if (!Arrays.equals(prjBootRoots, bootstrapLibraries.getRoots())) continue;
            return installedPlatforms[i];
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }
}

