/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.vars;

import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.js.vars.DebuggerSupport;

public class JSVariable {
    private final JPDADebugger debugger;
    private final Variable valueInfoDesc;
    private final String key;
    private final String value;
    private final boolean expandable;
    private final ObjectVariable valueObject;

    protected JSVariable(JPDADebugger debugger, Variable valueInfoDesc) {
        String className;
        JPDAClassType classType;
        Variable valueObjectVar;
        this.debugger = debugger;
        this.valueInfoDesc = valueInfoDesc;
        this.value = JSVariable.getStringValue(debugger, valueInfoDesc);
        this.key = DebuggerSupport.getDescriptionKey(valueInfoDesc);
        this.expandable = DebuggerSupport.isDescriptionExpandable(valueInfoDesc);
        ObjectVariable valueObject = null;
        if (!this.expandable && (valueObjectVar = DebuggerSupport.getDescriptionValueObject(valueInfoDesc)) instanceof ObjectVariable && (classType = ((ObjectVariable)valueObjectVar).getClassType()) != null && !(className = classType.getName()).startsWith("jdk.nashorn") && !String.class.getName().equals(className)) {
            valueObject = (ObjectVariable)valueObjectVar;
        }
        this.valueObject = valueObject;
    }

    private static String getStringValue(JPDADebugger debugger, Variable valueInfoDesc) {
        String value = DebuggerSupport.getDescriptionValue(valueInfoDesc);
        if ("{}".equals(value)) {
            Variable valueObject = DebuggerSupport.getDescriptionValueObject(valueInfoDesc);
            value = DebuggerSupport.getVarValue(debugger, valueObject);
        }
        return value;
    }

    public static JSVariable[] createScopeVars(JPDADebugger debugger, Variable scope) {
        String value = scope.getValue();
        if ("null".equals(value)) {
            return new JSVariable[0];
        }
        Variable[] valueInfos = DebuggerSupport.getValueInfos(debugger, scope, false);
        if (valueInfos == null) {
            return new JSVariable[0];
        }
        int n = valueInfos.length;
        JSVariable[] jVars = new JSVariable[n];
        for (int i = 0; i < n; ++i) {
            jVars[i] = new JSVariable(debugger, valueInfos[i]);
        }
        return jVars;
    }

    public static JSVariable create(JPDADebugger debugger, LocalVariable lv) {
        Variable valueInfoDesc = DebuggerSupport.getValueInfoDesc(debugger, lv.getName(), (Variable)lv, false);
        if (valueInfoDesc == null) {
            return null;
        }
        return new JSVariable(debugger, valueInfoDesc);
    }

    public static JSVariable createIfScriptObject(JPDADebugger debugger, ObjectVariable ov, String name) {
        JPDAClassType classType = ov.getClassType();
        if (classType == null) {
            return null;
        }
        boolean isScript = classType.isInstanceOf("jdk.nashorn.internal.runtime.ScriptObject");
        if (!isScript) {
            return null;
        }
        Variable valueInfoDesc = DebuggerSupport.getValueInfoDesc(debugger, name, (Variable)ov, false);
        if (valueInfoDesc == null) {
            return null;
        }
        return new JSVariable(debugger, valueInfoDesc);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public ObjectVariable getValueObject() {
        return this.valueObject;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public JSVariable[] getChildren() {
        Variable descriptionValueObject = DebuggerSupport.getDescriptionValueObject(this.valueInfoDesc);
        return JSVariable.createScopeVars(this.debugger, descriptionValueObject);
    }
}

