/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.impl.SampleProviderHelper;
import org.netbeans.modules.db.mysql.spi.sample.SampleProvider;
import org.netbeans.modules.db.mysql.util.Utils;

public class SampleManager {
    public static List<String> getSampleNames() {
        Collection<SampleProvider> providers = SampleProviderHelper.getProviders();
        ArrayList<String> sampleNames = new ArrayList<String>();
        for (SampleProvider provider : providers) {
            sampleNames.addAll(provider.getSampleNames());
        }
        return sampleNames;
    }

    public static boolean isSample(String name) {
        Collection<SampleProvider> providers = SampleProviderHelper.getProviders();
        ArrayList<String> sampleNames = new ArrayList<String>();
        for (SampleProvider provider : providers) {
            sampleNames.addAll(provider.getSampleNames());
        }
        return sampleNames.contains(name);
    }

    private static SampleProvider getProvider(String sampleName) {
        Collection<SampleProvider> providers = SampleProviderHelper.getProviders();
        for (SampleProvider provider : providers) {
            if (!provider.supportsSample(sampleName)) continue;
            return provider;
        }
        return null;
    }

    public static void createSample(String sampleName, DatabaseConnection dbconn) throws DatabaseException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("You can not call this method from the event dispatch thread");
        }
        SampleProvider provider = SampleManager.getProvider(sampleName);
        if (provider == null) {
            throw new DatabaseException(Utils.getMessage("MSG_NoSuchSample", sampleName));
        }
        provider.create(sampleName, dbconn);
    }
}

