/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBTable;

public class DataViewDBTable {
    private final DBTable[] dbTables;
    private final List<DBColumn> columns;

    public DataViewDBTable(Collection<DBTable> tables) {
        assert (tables != null);
        this.dbTables = new DBTable[tables.size()];
        ArrayList<DBColumn> cols = new ArrayList<DBColumn>();
        for (DBTable tbl : tables.toArray(this.dbTables)) {
            cols.addAll(tbl.getColumnList());
        }
        Collections.sort(cols, new ColumnOrderComparator());
        this.columns = Collections.unmodifiableList(cols);
    }

    public DBTable getTable(int index) {
        return this.dbTables[index];
    }

    public int getTableCount() {
        return this.dbTables.length;
    }

    public boolean hasOneTable() {
        return this.dbTables != null && this.dbTables.length == 1 && !this.dbTables[0].getName().equals("");
    }

    public String getFullyQualifiedName(int index, boolean quoteAlways) {
        return this.dbTables[index].getFullyQualifiedName(quoteAlways);
    }

    public DBColumn getColumn(int index) {
        return this.columns.get(index);
    }

    public int getColumnType(int index) {
        return this.columns.get(index).getJdbcType();
    }

    public String getColumnName(int index) {
        return this.columns.get(index).getName();
    }

    public String getQualifiedName(int index, boolean quoteAlways) {
        return this.columns.get(index).getQualifiedName(quoteAlways);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public List<DBColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public synchronized Map<String, DBColumn> getColumnMap() {
        HashMap<String, DBColumn> colMap = new HashMap<String, DBColumn>();
        for (DBTable tbl : this.dbTables) {
            colMap.putAll(tbl.getColumns());
        }
        return Collections.unmodifiableMap(colMap);
    }

    private final class ColumnOrderComparator
    implements Comparator<DBColumn> {
        private ColumnOrderComparator() {
        }

        @Override
        public int compare(DBColumn col1, DBColumn col2) {
            return col1.getOrdinalPosition() - col2.getOrdinalPosition();
        }
    }
}

