/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.RequestProcessor;

public final class CPPLiteActionsProvider
extends ActionsProviderSupport {
    private static final Logger LOGGER = Logger.getLogger(CPPLiteActionsProvider.class.getName());
    private static final Set<Object> ACTIONS = new HashSet<Object>();
    private static final Set<Object> ACTIONS_TO_DISABLE = new HashSet<Object>();
    private static RequestProcessor actionsRequestProcessor;
    private static RequestProcessor killRequestProcessor;
    private final CPPLiteDebugger debugger;

    public CPPLiteActionsProvider(ContextProvider contextProvider) {
        this.debugger = (CPPLiteDebugger)contextProvider.lookupFirst(null, CPPLiteDebugger.class);
        for (Object action : ACTIONS) {
            this.setEnabled(action, true);
        }
    }

    public Set getActions() {
        return ACTIONS;
    }

    public void doAction(Object action) {
        LOGGER.log(Level.FINE, "CPPLiteDebugger.doAction({0}), is kill = {1}", new Object[]{action, action == ActionsManager.ACTION_KILL});
        if (action == ActionsManager.ACTION_KILL) {
            this.debugger.finish(true);
        } else if (action == ActionsManager.ACTION_CONTINUE) {
            this.debugger.resume();
        } else if (action == ActionsManager.ACTION_PAUSE) {
            this.debugger.pause();
        } else {
            if (action == ActionsManager.ACTION_START) {
                return;
            }
            if (action == ActionsManager.ACTION_STEP_INTO || action == ActionsManager.ACTION_STEP_OUT || action == ActionsManager.ACTION_STEP_OVER) {
                this.debugger.doStep(action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        if (action == ActionsManager.ACTION_KILL) {
            Class<CPPLiteDebugger> clazz = CPPLiteDebugger.class;
            synchronized (CPPLiteDebugger.class) {
                if (killRequestProcessor == null) {
                    killRequestProcessor = new RequestProcessor("CPPLite debugger finish RP", 1);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                killRequestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CPPLiteActionsProvider.this.doAction(action);
                        }
                        finally {
                            actionPerformedNotifier.run();
                        }
                    }
                });
                return;
            }
        }
        this.setDebugActionsEnabled(false);
        Class<CPPLiteDebugger> clazz = CPPLiteDebugger.class;
        synchronized (CPPLiteDebugger.class) {
            if (actionsRequestProcessor == null) {
                actionsRequestProcessor = new RequestProcessor("CPPLite debugger actions RP", 1);
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            actionsRequestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        CPPLiteActionsProvider.this.doAction(action);
                    }
                    finally {
                        actionPerformedNotifier.run();
                        CPPLiteActionsProvider.this.setDebugActionsEnabled(true);
                    }
                }
            });
            return;
        }
    }

    private void setDebugActionsEnabled(boolean enabled) {
        for (Object action : ACTIONS_TO_DISABLE) {
            this.setEnabled(action, enabled);
        }
    }

    static {
        ACTIONS.add(ActionsManager.ACTION_KILL);
        ACTIONS.add(ActionsManager.ACTION_CONTINUE);
        ACTIONS.add(ActionsManager.ACTION_PAUSE);
        ACTIONS.add(ActionsManager.ACTION_START);
        ACTIONS.add(ActionsManager.ACTION_STEP_INTO);
        ACTIONS.add(ActionsManager.ACTION_STEP_OVER);
        ACTIONS.add(ActionsManager.ACTION_STEP_OUT);
        ACTIONS_TO_DISABLE.addAll(ACTIONS);
        ACTIONS_TO_DISABLE.remove(ActionsManager.ACTION_KILL);
    }
}

