/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cpplite.debugger.breakpoints.CPPLiteBreakpoint;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class CPPLiteBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final String[] C_MIME_TYPES = new String[]{"text/X-c", "text/X-c++", "text/X-h", "text/X-h++"};
    private static final Set<String> C_MIME_TYPES_SET = new HashSet<String>(Arrays.asList(C_MIME_TYPES));
    private static final Set ACTIONS = Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    EditorContextDispatcher context = EditorContextDispatcher.getDefault();

    public CPPLiteBreakpointActionProvider() {
        for (String mimeType : C_MIME_TYPES) {
            this.context.addPropertyChangeListener(mimeType, WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.context));
        }
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
    }

    public void doAction(Object action) {
        int i;
        Line line = CPPLiteBreakpointActionProvider.getCurrentLine();
        if (line == null) {
            return;
        }
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = breakpoints.length;
        for (i = 0; i < k; ++i) {
            if (!(breakpoints[i] instanceof CPPLiteBreakpoint) || !((CPPLiteBreakpoint)breakpoints[i]).getLine().equals(line)) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint(breakpoints[i]);
            break;
        }
        if (i == k) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)new CPPLiteBreakpoint(line));
        }
    }

    public Set getActions() {
        return ACTIONS;
    }

    private static Line getCurrentLine() {
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        if (!CPPLiteBreakpointActionProvider.isCFile(fo)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }

    private static boolean isCFile(FileObject fo) {
        if (fo == null) {
            return false;
        }
        return C_MIME_TYPES_SET.contains(fo.getMIMEType());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled = CPPLiteBreakpointActionProvider.getCurrentLine() != null;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, enabled);
    }
}

