/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.cpplite.debugger.breakpoints.CPPLiteBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public class BreakpointsReader
implements Properties.Reader {
    public String[] getSupportedClassNames() {
        return new String[]{CPPLiteBreakpoint.class.getName()};
    }

    public Object read(String typeID, Properties properties) {
        if (!typeID.equals(CPPLiteBreakpoint.class.getName())) {
            return null;
        }
        Line line = this.getLine(properties.getString("url", null), properties.getInt("lineNumber", 1));
        if (line == null) {
            return null;
        }
        CPPLiteBreakpoint b = new CPPLiteBreakpoint(line);
        b.setGroupName(properties.getString("groupName", ""));
        int hitCountFilter = properties.getInt("hitCountFilter", 0);
        Breakpoint.HIT_COUNT_FILTERING_STYLE hitCountFilteringStyle = hitCountFilter > 0 ? Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[properties.getInt("hitCountFilter_style", 0)] : null;
        b.setHitCountFilter(hitCountFilter, hitCountFilteringStyle);
        String condition = properties.getString("condition", null);
        if (condition != null && !condition.isEmpty()) {
            b.setCondition(condition);
        }
        if (properties.getBoolean("enabled", true)) {
            b.enable();
        } else {
            b.disable();
        }
        return b;
    }

    public void write(Object object, Properties properties) {
        CPPLiteBreakpoint b = (CPPLiteBreakpoint)((Object)object);
        FileObject fo = (FileObject)b.getLine().getLookup().lookup(FileObject.class);
        properties.setString("url", fo.toURL().toString());
        properties.setInt("lineNumber", b.getLine().getLineNumber());
        properties.setString("groupName", b.getGroupName());
        properties.setBoolean("enabled", b.isEnabled());
        properties.setInt("hitCountFilter", b.getHitCountFilter());
        Breakpoint.HIT_COUNT_FILTERING_STYLE style = b.getHitCountFilteringStyle();
        properties.setInt("hitCountFilter_style", style != null ? style.ordinal() : 0);
        String condition = b.getCondition();
        if (condition == null) {
            condition = "";
        }
        properties.setString("condition", condition);
    }

    private Line getLine(String url, int lineNumber) {
        DataObject dataObject;
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        try {
            dataObject = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        if (dataObject == null) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        Line.Set ls = lineCookie.getLineSet();
        if (ls == null) {
            return null;
        }
        try {
            return ls.getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }
}

