/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.cli;

import java.util.List;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.cli.Bundle;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;

final class Status {
    final String txt;

    static String[] toArray(UpdateUnit uu) {
        if (uu.getInstalled() != null) {
            return new String[]{uu.getCodeName(), uu.getInstalled().getSpecificationVersion(), Status.installed(uu).toString()};
        }
        List updates = uu.getAvailableUpdates();
        if (updates.isEmpty()) {
            return new String[]{uu.getCodeName(), "N/A", "N/A"};
        }
        UpdateElement first = (UpdateElement)updates.get(0);
        return new String[]{uu.getCodeName(), first.getSpecificationVersion(), Status.update(uu).toString()};
    }

    private Status(String txt) {
        this.txt = txt;
    }

    private static Status installed(UpdateUnit uu) {
        assert (uu.getInstalled() != null);
        ModuleInfo mi = Status.find(uu.getCodeName());
        List updates = uu.getAvailableUpdates();
        String install = !updates.isEmpty() ? Bundle.MSG_UpdateAvailable(((UpdateElement)updates.get(0)).getSpecificationVersion()) : (mi == null ? Bundle.MSG_Unknown() : (mi.isEnabled() ? Bundle.MSG_Enabled() : Bundle.MSG_Disabled()));
        return new Status(install);
    }

    private static Status update(UpdateUnit uu) {
        assert (uu.getInstalled() == null && !uu.getAvailableUpdates().isEmpty());
        return new Status(Bundle.MSG_Updateable());
    }

    public String toString() {
        return this.txt;
    }

    private static ModuleInfo find(String cnb) {
        for (ModuleInfo mi : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            if (!cnb.equals(mi.getCodeNameBase())) continue;
            return mi;
        }
        return null;
    }
}

